/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io;

import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.io.UnsignedNumber;

public class UnsignedVarInt
extends UnsignedNumber
implements Comparable<UnsignedVarInt> {
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0xFFFFFFFFFFFFFFFL;
    private static final long UNSIGNED_MASK = 0xFFFFFFFFFFFFFFL;
    private final long value;

    private UnsignedVarInt(long value) {
        Preconditions.requireThat(value).isLessThanOrEqualTo(0xFFFFFFFFFFFFFFFL);
        Preconditions.requireThat(value).isGreaterThanOrEqualTo(0L);
        this.value = value;
    }

    public static UnsignedVarInt fromInt(int value) {
        return UnsignedVarInt.fromLong(value);
    }

    public static UnsignedVarInt fromLong(long value) {
        Guards.checkGreaterThanOrEqualTo(value, 0L, "value");
        Guards.checkLessThanOrEqualTo(value, 0xFFFFFFFFFFFFFFFL, "value");
        long unsigned = value & 0xFFFFFFFFFFFFFFL;
        return new UnsignedVarInt(unsigned);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedVarInt that = (UnsignedVarInt)obj;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(UnsignedVarInt other) {
        return Long.compare(this.value, other.value);
    }

    @Override
    @Nonnull
    public byte[] toBytes() {
        if (this.value == 0L) {
            return new byte[]{0};
        }
        int length = 0;
        while (this.value >> 7 * length++ > 127L) {
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            int shift = 7 * i;
            bytes[i] = (byte)(0x80L | this.value >> shift);
        }
        int n = length - 1;
        bytes[n] = (byte)(bytes[n] & 0x7F);
        return bytes;
    }

    public static UnsignedVarInt fromBytes(byte[] bytes) {
        int i;
        Guards.checkNotNull(bytes, "bytes");
        long value = 0L;
        for (i = 0; (bytes[i] & 0x80) > 0 && i < bytes.length; ++i) {
            long cleanValue = bytes[i] & 0x7F;
            value |= (cleanValue <<= 7 * i);
        }
        return UnsignedVarInt.fromLong(value |= (long)bytes[i] << 7 * i);
    }

    public static UnsignedVarInt fromByteBuffer(ByteBuffer buffer) {
        byte current;
        int i;
        Guards.checkNotNull(buffer, "buffer");
        long value = 0L;
        for (i = 0; ((current = buffer.get()) & 0x80) > 0 && i < 8 && buffer.hasRemaining(); ++i) {
            long cleanValue = current & 0x7F;
            value |= (cleanValue <<= 7 * i);
        }
        return UnsignedVarInt.fromLong(value |= (long)current << 7 * i);
    }
}

