/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.log;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.function.TriConsumer;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public enum Level {
    TRACE(Logger::trace, Logger::isTraceEnabled),
    DEBUG(Logger::debug, Logger::isDebugEnabled),
    INFO(Logger::info, Logger::isInfoEnabled),
    WARN(Logger::warn, Logger::isWarnEnabled),
    ERROR(Logger::error, Logger::isErrorEnabled);

    @Nonnull
    private final TriConsumer<Logger, String, Throwable> loggingFunction;
    @Nonnull
    private final Predicate<Logger> isEnabledPredicate;

    private Level(TriConsumer<Logger, String, Throwable> loggingFunction, Predicate<Logger> isEnabledPredicate) {
        this.loggingFunction = loggingFunction;
        this.isEnabledPredicate = isEnabledPredicate;
    }

    void logWith(Logger logger, @Nullable String message, @Nullable Throwable e) {
        this.loggingFunction.accept(logger, message, e);
    }

    boolean isEnabledFor(Logger logger) {
        return this.isEnabledPredicate.test(logger);
    }
}

