/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.predicate;

import org.atlanmod.commons.collect.MoreArrays;
import org.atlanmod.commons.predicate.ObjectPredicate;
import org.atlanmod.commons.predicate.PredicateContext;

public class ArrayPredicate
extends ObjectPredicate<ArrayPredicate, Object[]> {
    private static final String PATTERN = "\nExpecting array %s (%s)";

    public ArrayPredicate(PredicateContext context, Object[] value) {
        super(context, value);
    }

    public ArrayPredicate contains(Object elm) {
        if (!MoreArrays.contains((Object[])this.value, elm)) {
            this.context.send(PATTERN, "to contain", elm);
        }
        return this;
    }

    public ArrayPredicate containsAll(Object[] subArray) {
        if (!MoreArrays.containsAll((Object[])this.value, subArray)) {
            this.context.send(PATTERN, "to contain all from", subArray);
        }
        return this;
    }

    public ArrayPredicate lengthIs(int size) {
        if (((Object[])this.value).length != size) {
            this.context.send(PATTERN, "length to be", size);
        }
        return this;
    }
}

