/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.predicate;

import java.util.Collection;
import org.atlanmod.commons.predicate.ObjectPredicate;
import org.atlanmod.commons.predicate.PredicateContext;

public class CollectionPredicate<Yourself extends CollectionPredicate, T extends Collection>
extends ObjectPredicate<Yourself, T> {
    private static final String PATTERN = "\nExpecting collection %s (%s)";

    public CollectionPredicate(PredicateContext context, T value) {
        super(context, value);
    }

    public Yourself contains(Object elm) {
        if (!((Collection)this.value).contains(elm)) {
            this.context.send(PATTERN, "to contain", elm);
        }
        return (Yourself)((CollectionPredicate)this.me());
    }

    public Yourself containsAll(Collection<?> subCollection) {
        if (!((Collection)this.value).containsAll(subCollection)) {
            this.context.send(PATTERN, "to contain all from", subCollection);
        }
        return (Yourself)((CollectionPredicate)this.me());
    }

    public Yourself isEmpty() {
        if (!((Collection)this.value).isEmpty()) {
            this.context.send(PATTERN, "to be empty", "");
        }
        return (Yourself)((CollectionPredicate)this.me());
    }

    public Yourself notEmpty() {
        if (((Collection)this.value).isEmpty()) {
            this.context.send(PATTERN, "not to be empty", "");
        }
        return (Yourself)((CollectionPredicate)this.me());
    }

    public Yourself sizeIs(int size) {
        if (((Collection)this.value).size() != size) {
            this.context.send(PATTERN, "size to be", size);
        }
        return (Yourself)((CollectionPredicate)this.me());
    }
}

