/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.predicate;

import org.atlanmod.commons.predicate.Predicate;
import org.atlanmod.commons.predicate.PredicateContext;

public class IntPredicate
extends Predicate {
    private static final String PATTERN = "\nExpecting value (%d) to be %s (%d)";
    private final int value;

    public IntPredicate(PredicateContext context, int value) {
        super(context);
        this.value = value;
    }

    public IntPredicate isZero() {
        if (this.value != 0) {
            this.context.send(PATTERN, this.value, "exactly", 0);
        }
        return this;
    }

    public IntPredicate isGreaterThan(int other) {
        if (this.value <= other) {
            this.context.send(PATTERN, this.value, "greater than", other);
        }
        return this;
    }

    public IntPredicate isGreaterThanOrEqualTo(int other) {
        if (this.value < other) {
            this.context.send(PATTERN, this.value, "greater than or equal to", other);
        }
        return this;
    }

    public IntPredicate isLessThan(int other) {
        if (this.value >= other) {
            this.context.send(PATTERN, this.value, "less than", other);
        }
        return this;
    }

    public IntPredicate isLessThanOrEqualTo(int other) {
        if (this.value > other) {
            this.context.send(PATTERN, this.value, "less than or equal to", other);
        }
        return this;
    }

    public IntPredicate isBetween(int first, int last) {
        if (this.value < first || this.value > last) {
            this.context.send("\nExpecting value (%d) to be %s (%d) and (%d)", this.value, "between", first, last);
        }
        return this;
    }

    public IntPredicate isEqualTo(int other) {
        if (this.value != other) {
            this.context.send(PATTERN, this.value, "equal to", other);
        }
        return this;
    }

    public IntPredicate is(int other) {
        if (this.value != other) {
            this.context.send(PATTERN, this.value, "exactly", other);
        }
        return this;
    }

    public IntPredicate isDifferentFrom(int other) {
        if (this.value == other) {
            this.context.send(PATTERN, this.value, "different from", other);
        }
        return this;
    }

    public IntPredicate withMessage(String message) {
        return this;
    }
}

