/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.predicate;

import java.util.Objects;
import org.atlanmod.commons.predicate.Predicate;
import org.atlanmod.commons.predicate.PredicateContext;

public class ObjectPredicate<YOURSELF extends ObjectPredicate, T>
extends Predicate {
    static final String PATTERN = "\nExpecting value (%s) to be %s (%s)";
    final T value;

    public ObjectPredicate(PredicateContext context, T value) {
        super(context);
        this.value = value;
    }

    public YOURSELF isNull() {
        if (!Objects.isNull(this.value)) {
            this.context.send(PATTERN, this.value, "null", "");
        }
        return this.me();
    }

    public YOURSELF isNotNull() {
        if (Objects.isNull(this.value)) {
            this.context.send(PATTERN, this.value, "non null", "");
        }
        return this.me();
    }

    public YOURSELF isEqualTo(Object other) {
        if (!Objects.equals(this.value, other)) {
            this.context.send(PATTERN, this.value, "equal to", other);
        }
        return this.me();
    }

    public YOURSELF isSameAs(Object other) {
        if (this.value != other) {
            this.context.send(PATTERN, this.value, "same as", other);
        }
        return this.me();
    }

    public YOURSELF isDifferentFrom(T other) {
        if (this.value.equals(other)) {
            this.context.send(PATTERN, this.value, "different from", other);
        }
        return this.me();
    }

    public YOURSELF withMessage(String message) {
        return this.me();
    }

    public YOURSELF me() {
        return (YOURSELF)this;
    }
}

