/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Builder;
import org.atlanmod.commons.annotation.Singleton;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.reflect.ReflectionException;
import sun.reflect.ReflectionFactory;

@ParametersAreNonnullByDefault
public final class MoreReflection {
    private static final Map<Class<?>, Class<?>> primitiveToWrapper = new HashMap();

    private MoreReflection() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static <T> T newInstance(Class<T> type) {
        Object instance;
        Guards.checkNotNull(type, "type");
        Optional<String> methodName = MoreReflection.findConstructionMethod(type);
        try {
            if (methodName.isPresent()) {
                Method method = type.getMethod(methodName.get(), new Class[0]);
                method.setAccessible(true);
                instance = method.invoke(null, new Object[0]);
            } else {
                instance = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        return instance;
    }

    @Nonnull
    private static Optional<String> findConstructionMethod(Class<?> type) {
        Guards.checkArgument(!type.isAnnotationPresent(Static.class), "%s is annotated with @%s: cannot be instantiated", type.getName(), Static.class.getSimpleName());
        Optional<String> methodName = type.isAnnotationPresent(Singleton.class) ? Optional.of(type.getAnnotation(Singleton.class).value()) : (type.isAnnotationPresent(Builder.class) ? Optional.of(type.getAnnotation(Builder.class).value()) : Optional.empty());
        return methodName;
    }

    @Nonnull
    public static Set<Class<?>> getAllInterfaces(Class<?> type) {
        LinkedHashSet interfaces = new LinkedHashSet();
        MoreReflection.appendAllInterfaces(type, interfaces);
        return interfaces;
    }

    private static void appendAllInterfaces(Class<?> type, Set<Class<?>> interfaces) {
        while (type != null) {
            Arrays.stream(type.getInterfaces()).filter(interfaces::add).forEachOrdered(i -> MoreReflection.appendAllInterfaces(i, interfaces));
            type = type.getSuperclass();
        }
    }

    public static Optional<Constructor> findConstructor(Class type, Class[] argumentTypes) {
        return Stream.of(type.getConstructors()).filter(each -> MoreReflection.matches(each, argumentTypes)).findFirst();
    }

    public static Optional<Method> findFactoryMethod(Class type, Class[] argumentTypes) {
        return Stream.of(type.getMethods()).filter(each -> Modifier.isStatic(each.getModifiers())).filter(each -> each.getReturnType().isAssignableFrom(type)).filter(each -> MoreReflection.matches(each, argumentTypes)).findFirst();
    }

    public static <T> Function<Object[], T> getInstantiator(Class<T> type, Class[] argumentTypes) {
        Optional<Constructor> constructor = MoreReflection.findConstructor(type, argumentTypes);
        if (constructor.isPresent()) {
            return arguments -> {
                try {
                    return ((Constructor)constructor.get()).newInstance(arguments);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Could not instantiate class with constructor");
                }
            };
        }
        Optional<Method> factory = MoreReflection.findFactoryMethod(type, argumentTypes);
        if (factory.isPresent()) {
            return arguments -> {
                try {
                    return ((Method)factory.get()).invoke(null, arguments);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Could not instantiate class with factory method");
                }
            };
        }
        throw new IllegalArgumentException("Could not find compatible constructor or factory method");
    }

    public static boolean matches(Executable executable, Class[] argumentTypes) {
        Class<?>[] types = executable.getParameterTypes();
        if (types.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < argumentTypes.length; ++i) {
            if (MoreReflection.isAssignable(types[i], argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class<?> leftOperand, Class<?> rightOperand) {
        return MoreReflection.wrapperClassFor(leftOperand).isAssignableFrom(MoreReflection.wrapperClassFor(rightOperand));
    }

    private static Class<?> wrapperClassFor(Class<?> type) {
        assert (!type.isPrimitive() || primitiveToWrapper.containsKey(type));
        if (!type.isPrimitive()) {
            return type;
        }
        return primitiveToWrapper.get(type);
    }

    public static <T> T softInstantiate(Class<T> type) {
        return (T)MoreReflection.softInstantiate(type, Object.class);
    }

    public static <T> T softInstantiate(Class<T> type, Class<? super T> parent) {
        try {
            ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
            Constructor<? super T> parentConstructor = parent.getDeclaredConstructor(new Class[0]);
            Constructor<?> softConstructor = rf.newConstructorForSerialization(type, parentConstructor);
            return type.cast(softConstructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    static {
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
    }
}

