/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.service;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Lazy;
import org.atlanmod.commons.service.ServiceContext;
import org.atlanmod.commons.service.ServiceDefinition;
import org.atlanmod.commons.service.ServiceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@ParametersAreNonnullByDefault
@Component(immediate=true)
public class OSGiContext
implements ServiceContext {
    private BundleContext context;

    @Activate
    final void onInit(BundleContext context) {
        this.context = context;
        ServiceProvider.getInstance().setContext(this);
    }

    @Deactivate
    final void onDestroy() {
        this.context = null;
        ServiceProvider.getInstance().unloadContext();
    }

    @Nonnull
    public <S> Stream<ServiceDefinition<S>> getServices(Class<S> type) {
        return this.getServices(type, null);
    }

    @Nonnull
    public <T> Stream<ServiceDefinition<T>> getServices(Class<T> type, @Nullable String filter) {
        try {
            return this.context.getServiceReferences(type, filter).parallelStream().map(x$0 -> new OSGiServiceDefinition(x$0));
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @ParametersAreNonnullByDefault
    private class OSGiServiceDefinition<S>
    implements ServiceDefinition<S> {
        @Nonnull
        private final ServiceReference<S> reference;
        @Nonnull
        private final Lazy<S> service;

        public OSGiServiceDefinition(ServiceReference<S> reference) {
            this.reference = reference;
            this.service = Lazy.with(() -> OSGiContext.this.context.getService(this.reference));
        }

        @Override
        @Nonnull
        public Class<? extends S> type() {
            return this.get().getClass();
        }

        @Override
        @Nonnull
        public S get() {
            return this.service.get();
        }
    }
}

