/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.testing;

import java.util.Objects;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.atlanmod.testing.Person;
import org.atlanmod.testing.Verifier;
import org.junit.jupiter.api.Test;

class EqualsVerifierTest {
    EqualsVerifierTest() {
    }

    @Test
    void test() {
        Verifier.verifyEqualsOf(String.class).withArguments(new Object[]{"aaaa"}).andVariants(new Object[]{"bbbb"}).check();
    }

    @Test
    void testEqualsWithTwoArguments() {
        Verifier.verifyEqualsOf(Person.class).withArguments(new Object[]{"Anna", 33}).andVariants(new Object[]{"Carol", 44}).check();
    }

    @Test
    void incompatibleArgumentsLength() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Verifier.verifyEqualsOf(String.class).withArguments(new Object[]{1, "value"}).andVariants(new Object[]{2, "other"}).check()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Could not find compatible constructor or factory method");
    }

    @Test
    void differentArgumentLengths() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Verifier.verifyEqualsOf(String.class).withArguments(new Object[]{1, "string"}).andVariants(new Object[]{"Longer string"}).check()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("must have the same length");
    }

    @Test
    void sameArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Verifier.verifyEqualsOf(String.class).withArguments(new Object[]{"same"}).andVariants(new Object[]{"same"}).check()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("different elements");
    }

    @Test
    void alwaysEqualClass() {
        Assertions.assertThatThrownBy(() -> Verifier.verifyEqualsOf(AlwaysEqualTestData.class).withArguments(new Object[]{1}).andVariants(new Object[]{2}).check()).isInstanceOf(AssertionError.class);
    }

    @Test
    void alwaysNotEqualClass() {
        Assertions.assertThatThrownBy(() -> Verifier.verifyEqualsOf(AlwaysDifferentTestData.class).withArguments(new Object[]{1}).andVariants(new Object[]{2}).check()).isInstanceOf(AssertionError.class);
    }

    @Test
    void asymmetricEquals() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Verifier.verifyEqualsOf(AsymmetricEqualsTestData.class).withArguments(new Object[]{1}).andVariants(new Object[]{4}).check()).isInstanceOf(AssertionError.class)).hasMessageContaining("symmetric");
    }

    @Test
    void equalsToNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Verifier.verifyEqualsOf(EqualsToNullTestData.class).withArguments(new Object[]{1}).andVariants(new Object[]{4}).check()).isInstanceOf(AssertionError.class)).hasMessageContaining("null");
    }

    public static class EqualsToNullTestData {
        private final int i;

        public EqualsToNullTestData(Integer i) {
            this.i = i;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return true;
            }
            if (!(o instanceof EqualsToNullTestData)) {
                return false;
            }
            EqualsToNullTestData that = (EqualsToNullTestData)o;
            return this.i == that.i;
        }

        public int hashCode() {
            return Objects.hash(this.i);
        }
    }

    public static class AsymmetricEqualsTestData {
        static int lastId = 0;
        private final int i;

        public AsymmetricEqualsTestData(Integer i) {
            this.i = i + ++lastId;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.i <= ((AsymmetricEqualsTestData)obj).i;
        }

        public int hashCode() {
            return 1;
        }
    }

    public static class AlwaysDifferentTestData {
        public AlwaysDifferentTestData(Integer i) {
        }

        public boolean equals(Object obj) {
            return true;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class AlwaysEqualTestData {
        public AlwaysEqualTestData(Integer i) {
        }

        public boolean equals(Object obj) {
            return true;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

