/*
 * Decompiled with CFR 0.152.
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ApplicationLayer implements Enumerator
{
    MQTT(0, "MQTT", "MQTT"),
    HTTP(1, "HTTP", "HTTP"),
    AMQP(2, "AMQP", "AMQP"),
    CO_AP(3, "CoAP", "CoAP"),
    WEBSOCKET(4, "Websocket", "Websocket"),
    ZIGBEE(5, "Zigbee", "Zigbee");

    public static final int MQTT_VALUE = 0;
    public static final int HTTP_VALUE = 1;
    public static final int AMQP_VALUE = 2;
    public static final int CO_AP_VALUE = 3;
    public static final int WEBSOCKET_VALUE = 4;
    public static final int ZIGBEE_VALUE = 5;
    private static final ApplicationLayer[] VALUES_ARRAY;
    public static final List<ApplicationLayer> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ApplicationLayer get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ApplicationLayer result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ApplicationLayer getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ApplicationLayer result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ApplicationLayer get(int value) {
        switch (value) {
            case 0: {
                return MQTT;
            }
            case 1: {
                return HTTP;
            }
            case 2: {
                return AMQP;
            }
            case 3: {
                return CO_AP;
            }
            case 4: {
                return WEBSOCKET;
            }
            case 5: {
                return ZIGBEE;
            }
        }
        return null;
    }

    private ApplicationLayer(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ApplicationLayer[]{MQTT, HTTP, AMQP, CO_AP, WEBSOCKET, ZIGBEE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

