/*
 * Decompiled with CFR 0.152.
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LanguageList implements Enumerator
{
    CPOSIX(0, "C_Posix", "C_Posix"),
    NES_C(1, "nesC", "nesC"),
    CPLUS_PLUS(2, "CPlusPlus", "CPlusPlus"),
    JAVA(3, "Java", "Java"),
    JAVASCRIPT(4, "Javascript", "Javascript"),
    GO(5, "Go", "Go"),
    PYTHON(6, "Python", "Python"),
    ASSEMBLER(7, "Assembler", "Assembler"),
    NODEJS(8, "Nodejs", "Nodejs"),
    CARDUINO(9, "C_Arduino", "C_Arduino");

    public static final int CPOSIX_VALUE = 0;
    public static final int NES_C_VALUE = 1;
    public static final int CPLUS_PLUS_VALUE = 2;
    public static final int JAVA_VALUE = 3;
    public static final int JAVASCRIPT_VALUE = 4;
    public static final int GO_VALUE = 5;
    public static final int PYTHON_VALUE = 6;
    public static final int ASSEMBLER_VALUE = 7;
    public static final int NODEJS_VALUE = 8;
    public static final int CARDUINO_VALUE = 9;
    private static final LanguageList[] VALUES_ARRAY;
    public static final List<LanguageList> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LanguageList get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LanguageList result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LanguageList getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LanguageList result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LanguageList get(int value) {
        switch (value) {
            case 0: {
                return CPOSIX;
            }
            case 1: {
                return NES_C;
            }
            case 2: {
                return CPLUS_PLUS;
            }
            case 3: {
                return JAVA;
            }
            case 4: {
                return JAVASCRIPT;
            }
            case 5: {
                return GO;
            }
            case 6: {
                return PYTHON;
            }
            case 7: {
                return ASSEMBLER;
            }
            case 8: {
                return NODEJS;
            }
            case 9: {
                return CARDUINO;
            }
        }
        return null;
    }

    private LanguageList(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LanguageList[]{CPOSIX, NES_C, CPLUS_PLUS, JAVA, JAVASCRIPT, GO, PYTHON, ASSEMBLER, NODEJS, CARDUINO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

