/*
 * Decompiled with CFR 0.152.
 */
package iotmodel.util;

import iotmodel.AccessControlPolicy;
import iotmodel.Action;
import iotmodel.Actor;
import iotmodel.Actuator;
import iotmodel.AllowPermission;
import iotmodel.AppChannel;
import iotmodel.AppPort;
import iotmodel.ApplicationLayer;
import iotmodel.Behavior;
import iotmodel.ConstraintExpression;
import iotmodel.Data;
import iotmodel.DefaultPolicy;
import iotmodel.DenyPermission;
import iotmodel.DesktopApp;
import iotmodel.EdgeDevice;
import iotmodel.Event;
import iotmodel.Gateway;
import iotmodel.ID;
import iotmodel.IdList;
import iotmodel.IoTMetamodel;
import iotmodel.IoTOs;
import iotmodel.IoTPlatform;
import iotmodel.IotmodelPackage;
import iotmodel.LanguageList;
import iotmodel.MaliciousActor;
import iotmodel.Message;
import iotmodel.MessageBroker;
import iotmodel.MessageFormat;
import iotmodel.MobileApp;
import iotmodel.Network;
import iotmodel.NetworkLayer;
import iotmodel.OsList;
import iotmodel.Permission;
import iotmodel.PhysicalLinkLayer;
import iotmodel.PrivatePolicy;
import iotmodel.ProgrammingModel;
import iotmodel.ProtocolStack;
import iotmodel.PublishSubscribe;
import iotmodel.RequestResponse;
import iotmodel.Rule;
import iotmodel.Sensor;
import iotmodel.SharedAction;
import iotmodel.Thing;
import iotmodel.Topic;
import iotmodel.TransportLayer;
import iotmodel.UserApplication;
import iotmodel.WebServer;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class IotmodelValidator
extends EObjectValidator {
    public static final IotmodelValidator INSTANCE = new IotmodelValidator();
    public static final String DIAGNOSTIC_SOURCE = "iotmodel";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String PROTOCOL_STACK__CHECK_NAME_SIZE__EEXPRESSION = "self.name.size()>=5";

    protected EPackage getEPackage() {
        return IotmodelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateGateway((Gateway)value, diagnostics, context);
            }
            case 1: {
                return this.validateEdgeDevice((EdgeDevice)value, diagnostics, context);
            }
            case 2: {
                return this.validateAppChannel((AppChannel)value, diagnostics, context);
            }
            case 3: {
                return this.validateNetwork((Network)value, diagnostics, context);
            }
            case 4: {
                return this.validateRequestResponse((RequestResponse)value, diagnostics, context);
            }
            case 5: {
                return this.validatePublishSubscribe((PublishSubscribe)value, diagnostics, context);
            }
            case 6: {
                return this.validateThing((Thing)value, diagnostics, context);
            }
            case 7: {
                return this.validateAccessControlPolicy((AccessControlPolicy)value, diagnostics, context);
            }
            case 8: {
                return this.validateProtocolStack((ProtocolStack)value, diagnostics, context);
            }
            case 9: {
                return this.validateRule((Rule)value, diagnostics, context);
            }
            case 10: {
                return this.validateIoTOs((IoTOs)value, diagnostics, context);
            }
            case 11: {
                return this.validateIoTPlatform((IoTPlatform)value, diagnostics, context);
            }
            case 12: {
                return this.validateMessage((Message)value, diagnostics, context);
            }
            case 13: {
                return this.validateMessageFormat((MessageFormat)value, diagnostics, context);
            }
            case 14: {
                return this.validateMessageBroker((MessageBroker)value, diagnostics, context);
            }
            case 15: {
                return this.validateTopic((Topic)value, diagnostics, context);
            }
            case 16: {
                return this.validateUserApplication((UserApplication)value, diagnostics, context);
            }
            case 17: {
                return this.validateDesktopApp((DesktopApp)value, diagnostics, context);
            }
            case 18: {
                return this.validateMobileApp((MobileApp)value, diagnostics, context);
            }
            case 19: {
                return this.validateWebServer((WebServer)value, diagnostics, context);
            }
            case 20: {
                return this.validateDefaultPolicy((DefaultPolicy)value, diagnostics, context);
            }
            case 21: {
                return this.validatePrivatePolicy((PrivatePolicy)value, diagnostics, context);
            }
            case 22: {
                return this.validatePermission((Permission)value, diagnostics, context);
            }
            case 23: {
                return this.validateConstraintExpression((ConstraintExpression)value, diagnostics, context);
            }
            case 24: {
                return this.validateAllowPermission((AllowPermission)value, diagnostics, context);
            }
            case 25: {
                return this.validateDenyPermission((DenyPermission)value, diagnostics, context);
            }
            case 26: {
                return this.validateSensor((Sensor)value, diagnostics, context);
            }
            case 27: {
                return this.validateActuator((Actuator)value, diagnostics, context);
            }
            case 28: {
                return this.validateIoTMetamodel((IoTMetamodel)value, diagnostics, context);
            }
            case 29: {
                return this.validateID((ID)value, diagnostics, context);
            }
            case 30: {
                return this.validateBehavior((Behavior)value, diagnostics, context);
            }
            case 31: {
                return this.validateAction((Action)value, diagnostics, context);
            }
            case 32: {
                return this.validateEvent((Event)value, diagnostics, context);
            }
            case 33: {
                return this.validateProgrammingModel((ProgrammingModel)value, diagnostics, context);
            }
            case 34: {
                return this.validateSharedAction((SharedAction)value, diagnostics, context);
            }
            case 35: {
                return this.validateAppPort((AppPort)value, diagnostics, context);
            }
            case 36: {
                return this.validateData((Data)value, diagnostics, context);
            }
            case 37: {
                return this.validateActor((Actor)value, diagnostics, context);
            }
            case 38: {
                return this.validateMaliciousActor((MaliciousActor)value, diagnostics, context);
            }
            case 39: {
                return this.validateOsList((OsList)((Object)value), diagnostics, context);
            }
            case 40: {
                return this.validatePhysicalLinkLayer((PhysicalLinkLayer)((Object)value), diagnostics, context);
            }
            case 41: {
                return this.validateTransportLayer((TransportLayer)((Object)value), diagnostics, context);
            }
            case 42: {
                return this.validateNetworkLayer((NetworkLayer)((Object)value), diagnostics, context);
            }
            case 43: {
                return this.validateApplicationLayer((ApplicationLayer)((Object)value), diagnostics, context);
            }
            case 44: {
                return this.validateIdList((IdList)((Object)value), diagnostics, context);
            }
            case 45: {
                return this.validateLanguageList((LanguageList)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateGateway(Gateway gateway, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(gateway, diagnostics, context);
    }

    public boolean validateEdgeDevice(EdgeDevice edgeDevice, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(edgeDevice, diagnostics, context);
    }

    public boolean validateAppChannel(AppChannel appChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(appChannel, diagnostics, context);
    }

    public boolean validateNetwork(Network network, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(network, diagnostics, context);
    }

    public boolean validateRequestResponse(RequestResponse requestResponse, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(requestResponse, diagnostics, context);
    }

    public boolean validatePublishSubscribe(PublishSubscribe publishSubscribe, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(publishSubscribe, diagnostics, context);
    }

    public boolean validateThing(Thing thing, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(thing, diagnostics, context);
    }

    public boolean validateAccessControlPolicy(AccessControlPolicy accessControlPolicy, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(accessControlPolicy, diagnostics, context);
    }

    public boolean validateProtocolStack(ProtocolStack protocolStack, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(protocolStack, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(protocolStack, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(protocolStack, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(protocolStack, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(protocolStack, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(protocolStack, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(protocolStack, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(protocolStack, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(protocolStack, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProtocolStack_CheckNameSize(protocolStack, diagnostics, context);
        }
        return result;
    }

    public boolean validateProtocolStack_CheckNameSize(ProtocolStack protocolStack, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(IotmodelPackage.Literals.PROTOCOL_STACK, protocolStack, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "CheckNameSize", PROTOCOL_STACK__CHECK_NAME_SIZE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateRule(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(rule, diagnostics, context);
    }

    public boolean validateIoTOs(IoTOs ioTOs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(ioTOs, diagnostics, context);
    }

    public boolean validateIoTPlatform(IoTPlatform ioTPlatform, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(ioTPlatform, diagnostics, context);
    }

    public boolean validateMessage(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(message, diagnostics, context);
    }

    public boolean validateMessageFormat(MessageFormat messageFormat, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(messageFormat, diagnostics, context);
    }

    public boolean validateMessageBroker(MessageBroker messageBroker, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(messageBroker, diagnostics, context);
    }

    public boolean validateTopic(Topic topic, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(topic, diagnostics, context);
    }

    public boolean validateUserApplication(UserApplication userApplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(userApplication, diagnostics, context);
    }

    public boolean validateDesktopApp(DesktopApp desktopApp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(desktopApp, diagnostics, context);
    }

    public boolean validateMobileApp(MobileApp mobileApp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(mobileApp, diagnostics, context);
    }

    public boolean validateWebServer(WebServer webServer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(webServer, diagnostics, context);
    }

    public boolean validateDefaultPolicy(DefaultPolicy defaultPolicy, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(defaultPolicy, diagnostics, context);
    }

    public boolean validatePrivatePolicy(PrivatePolicy privatePolicy, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(privatePolicy, diagnostics, context);
    }

    public boolean validatePermission(Permission permission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(permission, diagnostics, context);
    }

    public boolean validateConstraintExpression(ConstraintExpression constraintExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(constraintExpression, diagnostics, context);
    }

    public boolean validateAllowPermission(AllowPermission allowPermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(allowPermission, diagnostics, context);
    }

    public boolean validateDenyPermission(DenyPermission denyPermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(denyPermission, diagnostics, context);
    }

    public boolean validateSensor(Sensor sensor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(sensor, diagnostics, context);
    }

    public boolean validateActuator(Actuator actuator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(actuator, diagnostics, context);
    }

    public boolean validateIoTMetamodel(IoTMetamodel ioTMetamodel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(ioTMetamodel, diagnostics, context);
    }

    public boolean validateID(ID id, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(id, diagnostics, context);
    }

    public boolean validateBehavior(Behavior behavior, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(behavior, diagnostics, context);
    }

    public boolean validateAction(Action action, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(action, diagnostics, context);
    }

    public boolean validateEvent(Event event, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(event, diagnostics, context);
    }

    public boolean validateProgrammingModel(ProgrammingModel programmingModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(programmingModel, diagnostics, context);
    }

    public boolean validateSharedAction(SharedAction sharedAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(sharedAction, diagnostics, context);
    }

    public boolean validateAppPort(AppPort appPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(appPort, diagnostics, context);
    }

    public boolean validateData(Data data, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(data, diagnostics, context);
    }

    public boolean validateActor(Actor actor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(actor, diagnostics, context);
    }

    public boolean validateMaliciousActor(MaliciousActor maliciousActor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(maliciousActor, diagnostics, context);
    }

    public boolean validateOsList(OsList osList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePhysicalLinkLayer(PhysicalLinkLayer physicalLinkLayer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateTransportLayer(TransportLayer transportLayer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateNetworkLayer(NetworkLayer networkLayer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApplicationLayer(ApplicationLayer applicationLayer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateIdList(IdList idList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLanguageList(LanguageList languageList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

