/**
 */
package iotmodel.impl;

import iotmodel.AppPort;
import iotmodel.Behavior;
import iotmodel.Data;
import iotmodel.ID;
import iotmodel.IoTOs;
import iotmodel.IotmodelPackage;
import iotmodel.Message;
import iotmodel.Thing;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Thing</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.impl.ThingImpl#getIotos <em>Iotos</em>}</li>
 *   <li>{@link iotmodel.impl.ThingImpl#getName <em>Name</em>}</li>
 *   <li>{@link iotmodel.impl.ThingImpl#getId <em>Id</em>}</li>
 *   <li>{@link iotmodel.impl.ThingImpl#getBehavior <em>Behavior</em>}</li>
 *   <li>{@link iotmodel.impl.ThingImpl#getMessage <em>Message</em>}</li>
 *   <li>{@link iotmodel.impl.ThingImpl#getContainsPorts <em>Contains Ports</em>}</li>
 *   <li>{@link iotmodel.impl.ThingImpl#getProduce <em>Produce</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class ThingImpl extends MinimalEObjectImpl.Container implements Thing {
	/**
	 * The cached value of the '{@link #getIotos() <em>Iotos</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIotos()
	 * @generated
	 * @ordered
	 */
	protected IoTOs iotos;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected EList<ID> id;

	/**
	 * The cached value of the '{@link #getBehavior() <em>Behavior</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBehavior()
	 * @generated
	 * @ordered
	 */
	protected EList<Behavior> behavior;

	/**
	 * The cached value of the '{@link #getMessage() <em>Message</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessage()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> message;

	/**
	 * The cached value of the '{@link #getContainsPorts() <em>Contains Ports</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContainsPorts()
	 * @generated
	 * @ordered
	 */
	protected EList<AppPort> containsPorts;

	/**
	 * The cached value of the '{@link #getProduce() <em>Produce</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProduce()
	 * @generated
	 * @ordered
	 */
	protected Data produce;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThingImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IotmodelPackage.Literals.THING;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IoTOs getIotos() {
		if (iotos != null && iotos.eIsProxy()) {
			InternalEObject oldIotos = (InternalEObject)iotos;
			iotos = (IoTOs)eResolveProxy(oldIotos);
			if (iotos != oldIotos) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IotmodelPackage.THING__IOTOS, oldIotos, iotos));
			}
		}
		return iotos;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IoTOs basicGetIotos() {
		return iotos;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIotos(IoTOs newIotos, NotificationChain msgs) {
		IoTOs oldIotos = iotos;
		iotos = newIotos;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IotmodelPackage.THING__IOTOS, oldIotos, newIotos);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIotos(IoTOs newIotos) {
		if (newIotos != iotos) {
			NotificationChain msgs = null;
			if (iotos != null)
				msgs = ((InternalEObject)iotos).eInverseRemove(this, IotmodelPackage.IO_TOS__THING, IoTOs.class, msgs);
			if (newIotos != null)
				msgs = ((InternalEObject)newIotos).eInverseAdd(this, IotmodelPackage.IO_TOS__THING, IoTOs.class, msgs);
			msgs = basicSetIotos(newIotos, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.THING__IOTOS, newIotos, newIotos));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.THING__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ID> getId() {
		if (id == null) {
			id = new EObjectContainmentEList<ID>(ID.class, this, IotmodelPackage.THING__ID);
		}
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Behavior> getBehavior() {
		if (behavior == null) {
			behavior = new EObjectContainmentEList<Behavior>(Behavior.class, this, IotmodelPackage.THING__BEHAVIOR);
		}
		return behavior;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Message> getMessage() {
		if (message == null) {
			message = new EObjectContainmentEList<Message>(Message.class, this, IotmodelPackage.THING__MESSAGE);
		}
		return message;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AppPort> getContainsPorts() {
		if (containsPorts == null) {
			containsPorts = new EObjectContainmentEList<AppPort>(AppPort.class, this, IotmodelPackage.THING__CONTAINS_PORTS);
		}
		return containsPorts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Data getProduce() {
		if (produce != null && produce.eIsProxy()) {
			InternalEObject oldProduce = (InternalEObject)produce;
			produce = (Data)eResolveProxy(oldProduce);
			if (produce != oldProduce) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IotmodelPackage.THING__PRODUCE, oldProduce, produce));
			}
		}
		return produce;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Data basicGetProduce() {
		return produce;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProduce(Data newProduce) {
		Data oldProduce = produce;
		produce = newProduce;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.THING__PRODUCE, oldProduce, produce));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.THING__IOTOS:
				if (iotos != null)
					msgs = ((InternalEObject)iotos).eInverseRemove(this, IotmodelPackage.IO_TOS__THING, IoTOs.class, msgs);
				return basicSetIotos((IoTOs)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.THING__IOTOS:
				return basicSetIotos(null, msgs);
			case IotmodelPackage.THING__ID:
				return ((InternalEList<?>)getId()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.THING__BEHAVIOR:
				return ((InternalEList<?>)getBehavior()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.THING__MESSAGE:
				return ((InternalEList<?>)getMessage()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.THING__CONTAINS_PORTS:
				return ((InternalEList<?>)getContainsPorts()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IotmodelPackage.THING__IOTOS:
				if (resolve) return getIotos();
				return basicGetIotos();
			case IotmodelPackage.THING__NAME:
				return getName();
			case IotmodelPackage.THING__ID:
				return getId();
			case IotmodelPackage.THING__BEHAVIOR:
				return getBehavior();
			case IotmodelPackage.THING__MESSAGE:
				return getMessage();
			case IotmodelPackage.THING__CONTAINS_PORTS:
				return getContainsPorts();
			case IotmodelPackage.THING__PRODUCE:
				if (resolve) return getProduce();
				return basicGetProduce();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IotmodelPackage.THING__IOTOS:
				setIotos((IoTOs)newValue);
				return;
			case IotmodelPackage.THING__NAME:
				setName((String)newValue);
				return;
			case IotmodelPackage.THING__ID:
				getId().clear();
				getId().addAll((Collection<? extends ID>)newValue);
				return;
			case IotmodelPackage.THING__BEHAVIOR:
				getBehavior().clear();
				getBehavior().addAll((Collection<? extends Behavior>)newValue);
				return;
			case IotmodelPackage.THING__MESSAGE:
				getMessage().clear();
				getMessage().addAll((Collection<? extends Message>)newValue);
				return;
			case IotmodelPackage.THING__CONTAINS_PORTS:
				getContainsPorts().clear();
				getContainsPorts().addAll((Collection<? extends AppPort>)newValue);
				return;
			case IotmodelPackage.THING__PRODUCE:
				setProduce((Data)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IotmodelPackage.THING__IOTOS:
				setIotos((IoTOs)null);
				return;
			case IotmodelPackage.THING__NAME:
				setName(NAME_EDEFAULT);
				return;
			case IotmodelPackage.THING__ID:
				getId().clear();
				return;
			case IotmodelPackage.THING__BEHAVIOR:
				getBehavior().clear();
				return;
			case IotmodelPackage.THING__MESSAGE:
				getMessage().clear();
				return;
			case IotmodelPackage.THING__CONTAINS_PORTS:
				getContainsPorts().clear();
				return;
			case IotmodelPackage.THING__PRODUCE:
				setProduce((Data)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IotmodelPackage.THING__IOTOS:
				return iotos != null;
			case IotmodelPackage.THING__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case IotmodelPackage.THING__ID:
				return id != null && !id.isEmpty();
			case IotmodelPackage.THING__BEHAVIOR:
				return behavior != null && !behavior.isEmpty();
			case IotmodelPackage.THING__MESSAGE:
				return message != null && !message.isEmpty();
			case IotmodelPackage.THING__CONTAINS_PORTS:
				return containsPorts != null && !containsPorts.isEmpty();
			case IotmodelPackage.THING__PRODUCE:
				return produce != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //ThingImpl
