/**
 */
package iotmodel;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Access Control Policy</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.AccessControlPolicy#getRule <em>Rule</em>}</li>
 *   <li>{@link iotmodel.AccessControlPolicy#getIsEnforced <em>Is Enforced</em>}</li>
 *   <li>{@link iotmodel.AccessControlPolicy#getPolicyName <em>Policy Name</em>}</li>
 * </ul>
 *
 * @see iotmodel.IotmodelPackage#getAccessControlPolicy()
 * @model abstract="true"
 * @generated
 */
public interface AccessControlPolicy extends EObject {
	/**
	 * Returns the value of the '<em><b>Rule</b></em>' containment reference list.
	 * The list contents are of type {@link iotmodel.Rule}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rule</em>' containment reference list.
	 * @see iotmodel.IotmodelPackage#getAccessControlPolicy_Rule()
	 * @model containment="true"
	 * @generated
	 */
	EList<Rule> getRule();

	/**
	 * Returns the value of the '<em><b>Is Enforced</b></em>' reference list.
	 * The list contents are of type {@link iotmodel.Network}.
	 * It is bidirectional and its opposite is '{@link iotmodel.Network#getEnforce <em>Enforce</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Is Enforced</em>' reference list.
	 * @see iotmodel.IotmodelPackage#getAccessControlPolicy_IsEnforced()
	 * @see iotmodel.Network#getEnforce
	 * @model opposite="enforce"
	 * @generated
	 */
	EList<Network> getIsEnforced();

	/**
	 * Returns the value of the '<em><b>Policy Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Policy Name</em>' attribute.
	 * @see #setPolicyName(String)
	 * @see iotmodel.IotmodelPackage#getAccessControlPolicy_PolicyName()
	 * @model unique="false" id="true"
	 * @generated
	 */
	String getPolicyName();

	/**
	 * Sets the value of the '{@link iotmodel.AccessControlPolicy#getPolicyName <em>Policy Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Policy Name</em>' attribute.
	 * @see #getPolicyName()
	 * @generated
	 */
	void setPolicyName(String value);

} // AccessControlPolicy
