/**
 */
package iotmodel;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Message Broker</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.MessageBroker#getUsedBy <em>Used By</em>}</li>
 *   <li>{@link iotmodel.MessageBroker#getTopic <em>Topic</em>}</li>
 *   <li>{@link iotmodel.MessageBroker#getIotplatform <em>Iotplatform</em>}</li>
 * </ul>
 *
 * @see iotmodel.IotmodelPackage#getMessageBroker()
 * @model
 * @generated
 */
public interface MessageBroker extends EObject {
	/**
	 * Returns the value of the '<em><b>Used By</b></em>' reference list.
	 * The list contents are of type {@link iotmodel.PublishSubscribe}.
	 * It is bidirectional and its opposite is '{@link iotmodel.PublishSubscribe#getPublishSubscribe <em>Publish Subscribe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Used By</em>' reference list.
	 * @see iotmodel.IotmodelPackage#getMessageBroker_UsedBy()
	 * @see iotmodel.PublishSubscribe#getPublishSubscribe
	 * @model opposite="publishSubscribe"
	 * @generated
	 */
	EList<PublishSubscribe> getUsedBy();

	/**
	 * Returns the value of the '<em><b>Topic</b></em>' containment reference list.
	 * The list contents are of type {@link iotmodel.Topic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Topic</em>' containment reference list.
	 * @see iotmodel.IotmodelPackage#getMessageBroker_Topic()
	 * @model containment="true"
	 * @generated
	 */
	EList<Topic> getTopic();

	/**
	 * Returns the value of the '<em><b>Iotplatform</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link iotmodel.IoTPlatform#getMessagebroker <em>Messagebroker</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Iotplatform</em>' reference.
	 * @see #setIotplatform(IoTPlatform)
	 * @see iotmodel.IotmodelPackage#getMessageBroker_Iotplatform()
	 * @see iotmodel.IoTPlatform#getMessagebroker
	 * @model opposite="messagebroker"
	 * @generated
	 */
	IoTPlatform getIotplatform();

	/**
	 * Sets the value of the '{@link iotmodel.MessageBroker#getIotplatform <em>Iotplatform</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Iotplatform</em>' reference.
	 * @see #getIotplatform()
	 * @generated
	 */
	void setIotplatform(IoTPlatform value);

} // MessageBroker
