/**
 */
package iotmodel.impl;

import iotmodel.IoTPlatform;
import iotmodel.IotmodelPackage;
import iotmodel.MessageBroker;
import iotmodel.PublishSubscribe;
import iotmodel.Topic;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Message Broker</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.impl.MessageBrokerImpl#getUsedBy <em>Used By</em>}</li>
 *   <li>{@link iotmodel.impl.MessageBrokerImpl#getTopic <em>Topic</em>}</li>
 *   <li>{@link iotmodel.impl.MessageBrokerImpl#getIotplatform <em>Iotplatform</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MessageBrokerImpl extends MinimalEObjectImpl.Container implements MessageBroker {
	/**
	 * The cached value of the '{@link #getUsedBy() <em>Used By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsedBy()
	 * @generated
	 * @ordered
	 */
	protected EList<PublishSubscribe> usedBy;

	/**
	 * The cached value of the '{@link #getTopic() <em>Topic</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTopic()
	 * @generated
	 * @ordered
	 */
	protected EList<Topic> topic;

	/**
	 * The cached value of the '{@link #getIotplatform() <em>Iotplatform</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIotplatform()
	 * @generated
	 * @ordered
	 */
	protected IoTPlatform iotplatform;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageBrokerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IotmodelPackage.Literals.MESSAGE_BROKER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<PublishSubscribe> getUsedBy() {
		if (usedBy == null) {
			usedBy = new EObjectWithInverseResolvingEList<PublishSubscribe>(PublishSubscribe.class, this, IotmodelPackage.MESSAGE_BROKER__USED_BY, IotmodelPackage.PUBLISH_SUBSCRIBE__PUBLISH_SUBSCRIBE);
		}
		return usedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Topic> getTopic() {
		if (topic == null) {
			topic = new EObjectContainmentEList<Topic>(Topic.class, this, IotmodelPackage.MESSAGE_BROKER__TOPIC);
		}
		return topic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IoTPlatform getIotplatform() {
		if (iotplatform != null && iotplatform.eIsProxy()) {
			InternalEObject oldIotplatform = (InternalEObject)iotplatform;
			iotplatform = (IoTPlatform)eResolveProxy(oldIotplatform);
			if (iotplatform != oldIotplatform) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM, oldIotplatform, iotplatform));
			}
		}
		return iotplatform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IoTPlatform basicGetIotplatform() {
		return iotplatform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIotplatform(IoTPlatform newIotplatform, NotificationChain msgs) {
		IoTPlatform oldIotplatform = iotplatform;
		iotplatform = newIotplatform;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM, oldIotplatform, newIotplatform);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIotplatform(IoTPlatform newIotplatform) {
		if (newIotplatform != iotplatform) {
			NotificationChain msgs = null;
			if (iotplatform != null)
				msgs = ((InternalEObject)iotplatform).eInverseRemove(this, IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER, IoTPlatform.class, msgs);
			if (newIotplatform != null)
				msgs = ((InternalEObject)newIotplatform).eInverseAdd(this, IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER, IoTPlatform.class, msgs);
			msgs = basicSetIotplatform(newIotplatform, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM, newIotplatform, newIotplatform));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.MESSAGE_BROKER__USED_BY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getUsedBy()).basicAdd(otherEnd, msgs);
			case IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM:
				if (iotplatform != null)
					msgs = ((InternalEObject)iotplatform).eInverseRemove(this, IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER, IoTPlatform.class, msgs);
				return basicSetIotplatform((IoTPlatform)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.MESSAGE_BROKER__USED_BY:
				return ((InternalEList<?>)getUsedBy()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.MESSAGE_BROKER__TOPIC:
				return ((InternalEList<?>)getTopic()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM:
				return basicSetIotplatform(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IotmodelPackage.MESSAGE_BROKER__USED_BY:
				return getUsedBy();
			case IotmodelPackage.MESSAGE_BROKER__TOPIC:
				return getTopic();
			case IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM:
				if (resolve) return getIotplatform();
				return basicGetIotplatform();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IotmodelPackage.MESSAGE_BROKER__USED_BY:
				getUsedBy().clear();
				getUsedBy().addAll((Collection<? extends PublishSubscribe>)newValue);
				return;
			case IotmodelPackage.MESSAGE_BROKER__TOPIC:
				getTopic().clear();
				getTopic().addAll((Collection<? extends Topic>)newValue);
				return;
			case IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM:
				setIotplatform((IoTPlatform)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IotmodelPackage.MESSAGE_BROKER__USED_BY:
				getUsedBy().clear();
				return;
			case IotmodelPackage.MESSAGE_BROKER__TOPIC:
				getTopic().clear();
				return;
			case IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM:
				setIotplatform((IoTPlatform)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IotmodelPackage.MESSAGE_BROKER__USED_BY:
				return usedBy != null && !usedBy.isEmpty();
			case IotmodelPackage.MESSAGE_BROKER__TOPIC:
				return topic != null && !topic.isEmpty();
			case IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM:
				return iotplatform != null;
		}
		return super.eIsSet(featureID);
	}

} //MessageBrokerImpl
