/**
 */
package iotmodel;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see iotmodel.IotmodelFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore invocationDelegates='http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot' settingDelegates='http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot' validationDelegates='http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot'"
 *        annotation="http://www.eclipse.org/emf/2011/Xcore Pivot='http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot'"
 * @generated
 */
public interface IotmodelPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "iotmodel";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.example.org/iotmodel";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "iotmodel";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	IotmodelPackage eINSTANCE = iotmodel.impl.IotmodelPackageImpl.init();

	/**
	 * The meta object id for the '{@link iotmodel.impl.ThingImpl <em>Thing</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.ThingImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getThing()
	 * @generated
	 */
	int THING = 6;

	/**
	 * The feature id for the '<em><b>Iotos</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING__IOTOS = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING__NAME = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING__ID = 2;

	/**
	 * The feature id for the '<em><b>Behavior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING__BEHAVIOR = 3;

	/**
	 * The feature id for the '<em><b>Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING__MESSAGE = 4;

	/**
	 * The feature id for the '<em><b>Contains Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING__CONTAINS_PORTS = 5;

	/**
	 * The feature id for the '<em><b>Produce</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING__PRODUCE = 6;

	/**
	 * The number of structural features of the '<em>Thing</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>Thing</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THING_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.GatewayImpl <em>Gateway</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.GatewayImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getGateway()
	 * @generated
	 */
	int GATEWAY = 0;

	/**
	 * The feature id for the '<em><b>Iotos</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY__IOTOS = THING__IOTOS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY__NAME = THING__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY__ID = THING__ID;

	/**
	 * The feature id for the '<em><b>Behavior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY__BEHAVIOR = THING__BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY__MESSAGE = THING__MESSAGE;

	/**
	 * The feature id for the '<em><b>Contains Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY__CONTAINS_PORTS = THING__CONTAINS_PORTS;

	/**
	 * The feature id for the '<em><b>Produce</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY__PRODUCE = THING__PRODUCE;

	/**
	 * The number of structural features of the '<em>Gateway</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY_FEATURE_COUNT = THING_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Gateway</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GATEWAY_OPERATION_COUNT = THING_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.EdgeDeviceImpl <em>Edge Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.EdgeDeviceImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getEdgeDevice()
	 * @generated
	 */
	int EDGE_DEVICE = 1;

	/**
	 * The feature id for the '<em><b>Iotos</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE__IOTOS = THING__IOTOS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE__NAME = THING__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE__ID = THING__ID;

	/**
	 * The feature id for the '<em><b>Behavior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE__BEHAVIOR = THING__BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE__MESSAGE = THING__MESSAGE;

	/**
	 * The feature id for the '<em><b>Contains Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE__CONTAINS_PORTS = THING__CONTAINS_PORTS;

	/**
	 * The feature id for the '<em><b>Produce</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE__PRODUCE = THING__PRODUCE;

	/**
	 * The feature id for the '<em><b>Router</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE__ROUTER = THING_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Edge Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE_FEATURE_COUNT = THING_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Edge Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EDGE_DEVICE_OPERATION_COUNT = THING_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.AppChannelImpl <em>App Channel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.AppChannelImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getAppChannel()
	 * @generated
	 */
	int APP_CHANNEL = 2;

	/**
	 * The feature id for the '<em><b>Bind To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APP_CHANNEL__BIND_TO = 0;

	/**
	 * The number of structural features of the '<em>App Channel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APP_CHANNEL_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>App Channel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APP_CHANNEL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.NetworkImpl <em>Network</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.NetworkImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getNetwork()
	 * @generated
	 */
	int NETWORK = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK__NAME = 0;

	/**
	 * The feature id for the '<em><b>Domain</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK__DOMAIN = 1;

	/**
	 * The feature id for the '<em><b>Enforce</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK__ENFORCE = 2;

	/**
	 * The feature id for the '<em><b>Thing</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK__THING = 3;

	/**
	 * The feature id for the '<em><b>Data</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK__DATA = 4;

	/**
	 * The number of structural features of the '<em>Network</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Network</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.RequestResponseImpl <em>Request Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.RequestResponseImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getRequestResponse()
	 * @generated
	 */
	int REQUEST_RESPONSE = 4;

	/**
	 * The feature id for the '<em><b>Bind To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_RESPONSE__BIND_TO = APP_CHANNEL__BIND_TO;

	/**
	 * The feature id for the '<em><b>Server</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_RESPONSE__SERVER = APP_CHANNEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Request Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_RESPONSE_FEATURE_COUNT = APP_CHANNEL_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Request Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_RESPONSE_OPERATION_COUNT = APP_CHANNEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.PublishSubscribeImpl <em>Publish Subscribe</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.PublishSubscribeImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getPublishSubscribe()
	 * @generated
	 */
	int PUBLISH_SUBSCRIBE = 5;

	/**
	 * The feature id for the '<em><b>Bind To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUBLISH_SUBSCRIBE__BIND_TO = APP_CHANNEL__BIND_TO;

	/**
	 * The feature id for the '<em><b>Publish Subscribe</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUBLISH_SUBSCRIBE__PUBLISH_SUBSCRIBE = APP_CHANNEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Publish Subscribe</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUBLISH_SUBSCRIBE_FEATURE_COUNT = APP_CHANNEL_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Publish Subscribe</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PUBLISH_SUBSCRIBE_OPERATION_COUNT = APP_CHANNEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.AccessControlPolicyImpl <em>Access Control Policy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.AccessControlPolicyImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getAccessControlPolicy()
	 * @generated
	 */
	int ACCESS_CONTROL_POLICY = 7;

	/**
	 * The feature id for the '<em><b>Rule</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_CONTROL_POLICY__RULE = 0;

	/**
	 * The feature id for the '<em><b>Is Enforced</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_CONTROL_POLICY__IS_ENFORCED = 1;

	/**
	 * The feature id for the '<em><b>Policy Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_CONTROL_POLICY__POLICY_NAME = 2;

	/**
	 * The number of structural features of the '<em>Access Control Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_CONTROL_POLICY_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Access Control Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACCESS_CONTROL_POLICY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.ProtocolStackImpl <em>Protocol Stack</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.ProtocolStackImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getProtocolStack()
	 * @generated
	 */
	int PROTOCOL_STACK = 8;

	/**
	 * The feature id for the '<em><b>PHYDATA</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STACK__PHYDATA = 0;

	/**
	 * The feature id for the '<em><b>NWK</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STACK__NWK = 1;

	/**
	 * The feature id for the '<em><b>Transport</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STACK__TRANSPORT = 2;

	/**
	 * The feature id for the '<em><b>Application Protocol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STACK__APPLICATION_PROTOCOL = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STACK__NAME = 4;

	/**
	 * The number of structural features of the '<em>Protocol Stack</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STACK_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Protocol Stack</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROTOCOL_STACK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.RuleImpl <em>Rule</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.RuleImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getRule()
	 * @generated
	 */
	int RULE = 9;

	/**
	 * The feature id for the '<em><b>Thing</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RULE__THING = 0;

	/**
	 * The feature id for the '<em><b>Permission</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RULE__PERMISSION = 1;

	/**
	 * The feature id for the '<em><b>Constraintexpression</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RULE__CONSTRAINTEXPRESSION = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RULE__NAME = 3;

	/**
	 * The number of structural features of the '<em>Rule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RULE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Rule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RULE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.IoTOsImpl <em>Io TOs</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.IoTOsImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getIoTOs()
	 * @generated
	 */
	int IO_TOS = 10;

	/**
	 * The feature id for the '<em><b>Implements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TOS__IMPLEMENTS = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TOS__NAME = 1;

	/**
	 * The feature id for the '<em><b>Thing</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TOS__THING = 2;

	/**
	 * The feature id for the '<em><b>Programmingmodel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TOS__PROGRAMMINGMODEL = 3;

	/**
	 * The number of structural features of the '<em>Io TOs</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TOS_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Io TOs</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TOS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.IoTPlatformImpl <em>Io TPlatform</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.IoTPlatformImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getIoTPlatform()
	 * @generated
	 */
	int IO_TPLATFORM = 11;

	/**
	 * The feature id for the '<em><b>Use Protocol</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TPLATFORM__USE_PROTOCOL = 0;

	/**
	 * The feature id for the '<em><b>Sent Received By Platform</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM = 1;

	/**
	 * The feature id for the '<em><b>Communicate Through</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TPLATFORM__COMMUNICATE_THROUGH = 2;

	/**
	 * The feature id for the '<em><b>Userapplication</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TPLATFORM__USERAPPLICATION = 3;

	/**
	 * The feature id for the '<em><b>Messagebroker</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TPLATFORM__MESSAGEBROKER = 4;

	/**
	 * The feature id for the '<em><b>Webserver</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TPLATFORM__WEBSERVER = 5;

	/**
	 * The number of structural features of the '<em>Io TPlatform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TPLATFORM_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Io TPlatform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TPLATFORM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.MessageImpl <em>Message</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.MessageImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getMessage()
	 * @generated
	 */
	int MESSAGE = 12;

	/**
	 * The feature id for the '<em><b>Send Receive Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__SEND_RECEIVE_MESSAGE = 0;

	/**
	 * The feature id for the '<em><b>Encapsualte</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__ENCAPSUALTE = 1;

	/**
	 * The number of structural features of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.MessageFormatImpl <em>Message Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.MessageFormatImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getMessageFormat()
	 * @generated
	 */
	int MESSAGE_FORMAT = 13;

	/**
	 * The feature id for the '<em><b>Send Receive Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FORMAT__SEND_RECEIVE_MESSAGE = MESSAGE__SEND_RECEIVE_MESSAGE;

	/**
	 * The feature id for the '<em><b>Encapsualte</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FORMAT__ENCAPSUALTE = MESSAGE__ENCAPSUALTE;

	/**
	 * The number of structural features of the '<em>Message Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FORMAT_FEATURE_COUNT = MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Message Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FORMAT_OPERATION_COUNT = MESSAGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.MessageBrokerImpl <em>Message Broker</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.MessageBrokerImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getMessageBroker()
	 * @generated
	 */
	int MESSAGE_BROKER = 14;

	/**
	 * The feature id for the '<em><b>Used By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_BROKER__USED_BY = 0;

	/**
	 * The feature id for the '<em><b>Topic</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_BROKER__TOPIC = 1;

	/**
	 * The feature id for the '<em><b>Iotplatform</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_BROKER__IOTPLATFORM = 2;

	/**
	 * The number of structural features of the '<em>Message Broker</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_BROKER_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Message Broker</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_BROKER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.TopicImpl <em>Topic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.TopicImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getTopic()
	 * @generated
	 */
	int TOPIC = 15;

	/**
	 * The number of structural features of the '<em>Topic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOPIC_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Topic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TOPIC_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.UserApplicationImpl <em>User Application</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.UserApplicationImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getUserApplication()
	 * @generated
	 */
	int USER_APPLICATION = 16;

	/**
	 * The feature id for the '<em><b>Iotplatform</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_APPLICATION__IOTPLATFORM = 0;

	/**
	 * The number of structural features of the '<em>User Application</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_APPLICATION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>User Application</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int USER_APPLICATION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.DesktopAppImpl <em>Desktop App</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.DesktopAppImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getDesktopApp()
	 * @generated
	 */
	int DESKTOP_APP = 17;

	/**
	 * The feature id for the '<em><b>Iotplatform</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESKTOP_APP__IOTPLATFORM = USER_APPLICATION__IOTPLATFORM;

	/**
	 * The number of structural features of the '<em>Desktop App</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESKTOP_APP_FEATURE_COUNT = USER_APPLICATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Desktop App</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DESKTOP_APP_OPERATION_COUNT = USER_APPLICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.MobileAppImpl <em>Mobile App</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.MobileAppImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getMobileApp()
	 * @generated
	 */
	int MOBILE_APP = 18;

	/**
	 * The feature id for the '<em><b>Iotplatform</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOBILE_APP__IOTPLATFORM = USER_APPLICATION__IOTPLATFORM;

	/**
	 * The number of structural features of the '<em>Mobile App</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOBILE_APP_FEATURE_COUNT = USER_APPLICATION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Mobile App</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MOBILE_APP_OPERATION_COUNT = USER_APPLICATION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.WebServerImpl <em>Web Server</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.WebServerImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getWebServer()
	 * @generated
	 */
	int WEB_SERVER = 19;

	/**
	 * The feature id for the '<em><b>Requestresponse</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SERVER__REQUESTRESPONSE = 0;

	/**
	 * The feature id for the '<em><b>Iotplatform</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SERVER__IOTPLATFORM = 1;

	/**
	 * The number of structural features of the '<em>Web Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SERVER_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Web Server</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEB_SERVER_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.DefaultPolicyImpl <em>Default Policy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.DefaultPolicyImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getDefaultPolicy()
	 * @generated
	 */
	int DEFAULT_POLICY = 20;

	/**
	 * The feature id for the '<em><b>Rule</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_POLICY__RULE = ACCESS_CONTROL_POLICY__RULE;

	/**
	 * The feature id for the '<em><b>Is Enforced</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_POLICY__IS_ENFORCED = ACCESS_CONTROL_POLICY__IS_ENFORCED;

	/**
	 * The feature id for the '<em><b>Policy Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_POLICY__POLICY_NAME = ACCESS_CONTROL_POLICY__POLICY_NAME;

	/**
	 * The number of structural features of the '<em>Default Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_POLICY_FEATURE_COUNT = ACCESS_CONTROL_POLICY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Default Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEFAULT_POLICY_OPERATION_COUNT = ACCESS_CONTROL_POLICY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.PrivatePolicyImpl <em>Private Policy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.PrivatePolicyImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getPrivatePolicy()
	 * @generated
	 */
	int PRIVATE_POLICY = 21;

	/**
	 * The feature id for the '<em><b>Rule</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVATE_POLICY__RULE = ACCESS_CONTROL_POLICY__RULE;

	/**
	 * The feature id for the '<em><b>Is Enforced</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVATE_POLICY__IS_ENFORCED = ACCESS_CONTROL_POLICY__IS_ENFORCED;

	/**
	 * The feature id for the '<em><b>Policy Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVATE_POLICY__POLICY_NAME = ACCESS_CONTROL_POLICY__POLICY_NAME;

	/**
	 * The number of structural features of the '<em>Private Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVATE_POLICY_FEATURE_COUNT = ACCESS_CONTROL_POLICY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Private Policy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIVATE_POLICY_OPERATION_COUNT = ACCESS_CONTROL_POLICY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.PermissionImpl <em>Permission</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.PermissionImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getPermission()
	 * @generated
	 */
	int PERMISSION = 22;

	/**
	 * The feature id for the '<em><b>Permit Or Deny</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERMISSION__PERMIT_OR_DENY = 0;

	/**
	 * The number of structural features of the '<em>Permission</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERMISSION_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Permission</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERMISSION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.ConstraintExpressionImpl <em>Constraint Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.ConstraintExpressionImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getConstraintExpression()
	 * @generated
	 */
	int CONSTRAINT_EXPRESSION = 23;

	/**
	 * The number of structural features of the '<em>Constraint Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_EXPRESSION_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Constraint Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_EXPRESSION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.AllowPermissionImpl <em>Allow Permission</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.AllowPermissionImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getAllowPermission()
	 * @generated
	 */
	int ALLOW_PERMISSION = 24;

	/**
	 * The feature id for the '<em><b>Permit Or Deny</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOW_PERMISSION__PERMIT_OR_DENY = PERMISSION__PERMIT_OR_DENY;

	/**
	 * The number of structural features of the '<em>Allow Permission</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOW_PERMISSION_FEATURE_COUNT = PERMISSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Allow Permission</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALLOW_PERMISSION_OPERATION_COUNT = PERMISSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.DenyPermissionImpl <em>Deny Permission</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.DenyPermissionImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getDenyPermission()
	 * @generated
	 */
	int DENY_PERMISSION = 25;

	/**
	 * The feature id for the '<em><b>Permit Or Deny</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DENY_PERMISSION__PERMIT_OR_DENY = PERMISSION__PERMIT_OR_DENY;

	/**
	 * The number of structural features of the '<em>Deny Permission</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DENY_PERMISSION_FEATURE_COUNT = PERMISSION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Deny Permission</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DENY_PERMISSION_OPERATION_COUNT = PERMISSION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.SensorImpl <em>Sensor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.SensorImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getSensor()
	 * @generated
	 */
	int SENSOR = 26;

	/**
	 * The feature id for the '<em><b>Iotos</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR__IOTOS = EDGE_DEVICE__IOTOS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR__NAME = EDGE_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR__ID = EDGE_DEVICE__ID;

	/**
	 * The feature id for the '<em><b>Behavior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR__BEHAVIOR = EDGE_DEVICE__BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR__MESSAGE = EDGE_DEVICE__MESSAGE;

	/**
	 * The feature id for the '<em><b>Contains Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR__CONTAINS_PORTS = EDGE_DEVICE__CONTAINS_PORTS;

	/**
	 * The feature id for the '<em><b>Produce</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR__PRODUCE = EDGE_DEVICE__PRODUCE;

	/**
	 * The feature id for the '<em><b>Router</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR__ROUTER = EDGE_DEVICE__ROUTER;

	/**
	 * The number of structural features of the '<em>Sensor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_FEATURE_COUNT = EDGE_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Sensor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SENSOR_OPERATION_COUNT = EDGE_DEVICE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.ActuatorImpl <em>Actuator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.ActuatorImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getActuator()
	 * @generated
	 */
	int ACTUATOR = 27;

	/**
	 * The feature id for the '<em><b>Iotos</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR__IOTOS = EDGE_DEVICE__IOTOS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR__NAME = EDGE_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Id</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR__ID = EDGE_DEVICE__ID;

	/**
	 * The feature id for the '<em><b>Behavior</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR__BEHAVIOR = EDGE_DEVICE__BEHAVIOR;

	/**
	 * The feature id for the '<em><b>Message</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR__MESSAGE = EDGE_DEVICE__MESSAGE;

	/**
	 * The feature id for the '<em><b>Contains Ports</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR__CONTAINS_PORTS = EDGE_DEVICE__CONTAINS_PORTS;

	/**
	 * The feature id for the '<em><b>Produce</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR__PRODUCE = EDGE_DEVICE__PRODUCE;

	/**
	 * The feature id for the '<em><b>Router</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR__ROUTER = EDGE_DEVICE__ROUTER;

	/**
	 * The number of structural features of the '<em>Actuator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR_FEATURE_COUNT = EDGE_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Actuator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTUATOR_OPERATION_COUNT = EDGE_DEVICE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.IoTMetamodelImpl <em>Io TMetamodel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.IoTMetamodelImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getIoTMetamodel()
	 * @generated
	 */
	int IO_TMETAMODEL = 28;

	/**
	 * The feature id for the '<em><b>Iotplatform</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TMETAMODEL__IOTPLATFORM = 0;

	/**
	 * The feature id for the '<em><b>Network</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TMETAMODEL__NETWORK = 1;

	/**
	 * The feature id for the '<em><b>Accesscontrolpolicy</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TMETAMODEL__ACCESSCONTROLPOLICY = 2;

	/**
	 * The feature id for the '<em><b>Iotos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TMETAMODEL__IOTOS = 3;

	/**
	 * The feature id for the '<em><b>Protocolstack</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TMETAMODEL__PROTOCOLSTACK = 4;

	/**
	 * The feature id for the '<em><b>Channel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TMETAMODEL__CHANNEL = 5;

	/**
	 * The number of structural features of the '<em>Io TMetamodel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TMETAMODEL_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Io TMetamodel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IO_TMETAMODEL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.IDImpl <em>ID</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.IDImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getID()
	 * @generated
	 */
	int ID = 29;

	/**
	 * The feature id for the '<em><b>ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ID__ID = 0;

	/**
	 * The feature id for the '<em><b>New Attribute</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ID__NEW_ATTRIBUTE = 1;

	/**
	 * The number of structural features of the '<em>ID</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ID_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>ID</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ID_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.BehaviorImpl <em>Behavior</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.BehaviorImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getBehavior()
	 * @generated
	 */
	int BEHAVIOR = 30;

	/**
	 * The feature id for the '<em><b>Make Action</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR__MAKE_ACTION = 0;

	/**
	 * The feature id for the '<em><b>Event</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR__EVENT = 1;

	/**
	 * The number of structural features of the '<em>Behavior</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Behavior</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.ActionImpl <em>Action</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.ActionImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getAction()
	 * @generated
	 */
	int ACTION = 31;

	/**
	 * The feature id for the '<em><b>Permission</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION__PERMISSION = 0;

	/**
	 * The feature id for the '<em><b>Has Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION__HAS_EVENT = 1;

	/**
	 * The number of structural features of the '<em>Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTION_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.EventImpl <em>Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.EventImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getEvent()
	 * @generated
	 */
	int EVENT = 32;

	/**
	 * The feature id for the '<em><b>Trigger Action</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__TRIGGER_ACTION = 0;

	/**
	 * The number of structural features of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.ProgrammingModelImpl <em>Programming Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.ProgrammingModelImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getProgrammingModel()
	 * @generated
	 */
	int PROGRAMMING_MODEL = 33;

	/**
	 * The feature id for the '<em><b>Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROGRAMMING_MODEL__LANGUAGE = 0;

	/**
	 * The number of structural features of the '<em>Programming Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROGRAMMING_MODEL_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Programming Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROGRAMMING_MODEL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.SharedActionImpl <em>Shared Action</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.SharedActionImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getSharedAction()
	 * @generated
	 */
	int SHARED_ACTION = 34;

	/**
	 * The feature id for the '<em><b>Permission</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_ACTION__PERMISSION = ACTION__PERMISSION;

	/**
	 * The feature id for the '<em><b>Has Event</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_ACTION__HAS_EVENT = ACTION__HAS_EVENT;

	/**
	 * The number of structural features of the '<em>Shared Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_ACTION_FEATURE_COUNT = ACTION_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Shared Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHARED_ACTION_OPERATION_COUNT = ACTION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.AppPortImpl <em>App Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.AppPortImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getAppPort()
	 * @generated
	 */
	int APP_PORT = 35;

	/**
	 * The feature id for the '<em><b>Is Bound</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APP_PORT__IS_BOUND = 0;

	/**
	 * The number of structural features of the '<em>App Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APP_PORT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>App Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int APP_PORT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.DataImpl <em>Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.DataImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getData()
	 * @generated
	 */
	int DATA = 36;

	/**
	 * The feature id for the '<em><b>Is Encapsulated</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA__IS_ENCAPSULATED = 0;

	/**
	 * The number of structural features of the '<em>Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.ActorImpl <em>Actor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.ActorImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getActor()
	 * @generated
	 */
	int ACTOR = 37;

	/**
	 * The feature id for the '<em><b>Uses</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTOR__USES = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTOR__NAME = 1;

	/**
	 * The feature id for the '<em><b>Intent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTOR__INTENT = 2;

	/**
	 * The number of structural features of the '<em>Actor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTOR_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Actor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ACTOR_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link iotmodel.impl.MaliciousActorImpl <em>Malicious Actor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.impl.MaliciousActorImpl
	 * @see iotmodel.impl.IotmodelPackageImpl#getMaliciousActor()
	 * @generated
	 */
	int MALICIOUS_ACTOR = 38;

	/**
	 * The feature id for the '<em><b>Uses</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MALICIOUS_ACTOR__USES = ACTOR__USES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MALICIOUS_ACTOR__NAME = ACTOR__NAME;

	/**
	 * The feature id for the '<em><b>Intent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MALICIOUS_ACTOR__INTENT = ACTOR__INTENT;

	/**
	 * The number of structural features of the '<em>Malicious Actor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MALICIOUS_ACTOR_FEATURE_COUNT = ACTOR_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Malicious Actor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MALICIOUS_ACTOR_OPERATION_COUNT = ACTOR_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link iotmodel.OsList <em>Os List</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.OsList
	 * @see iotmodel.impl.IotmodelPackageImpl#getOsList()
	 * @generated
	 */
	int OS_LIST = 39;

	/**
	 * The meta object id for the '{@link iotmodel.PhysicalLinkLayer <em>Physical Link Layer</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.PhysicalLinkLayer
	 * @see iotmodel.impl.IotmodelPackageImpl#getPhysicalLinkLayer()
	 * @generated
	 */
	int PHYSICAL_LINK_LAYER = 40;

	/**
	 * The meta object id for the '{@link iotmodel.TransportLayer <em>Transport Layer</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.TransportLayer
	 * @see iotmodel.impl.IotmodelPackageImpl#getTransportLayer()
	 * @generated
	 */
	int TRANSPORT_LAYER = 41;

	/**
	 * The meta object id for the '{@link iotmodel.NetworkLayer <em>Network Layer</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.NetworkLayer
	 * @see iotmodel.impl.IotmodelPackageImpl#getNetworkLayer()
	 * @generated
	 */
	int NETWORK_LAYER = 42;

	/**
	 * The meta object id for the '{@link iotmodel.ApplicationLayer <em>Application Layer</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.ApplicationLayer
	 * @see iotmodel.impl.IotmodelPackageImpl#getApplicationLayer()
	 * @generated
	 */
	int APPLICATION_LAYER = 43;

	/**
	 * The meta object id for the '{@link iotmodel.IdList <em>Id List</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.IdList
	 * @see iotmodel.impl.IotmodelPackageImpl#getIdList()
	 * @generated
	 */
	int ID_LIST = 44;

	/**
	 * The meta object id for the '{@link iotmodel.LanguageList <em>Language List</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see iotmodel.LanguageList
	 * @see iotmodel.impl.IotmodelPackageImpl#getLanguageList()
	 * @generated
	 */
	int LANGUAGE_LIST = 45;


	/**
	 * Returns the meta object for class '{@link iotmodel.Gateway <em>Gateway</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Gateway</em>'.
	 * @see iotmodel.Gateway
	 * @generated
	 */
	EClass getGateway();

	/**
	 * Returns the meta object for class '{@link iotmodel.EdgeDevice <em>Edge Device</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Edge Device</em>'.
	 * @see iotmodel.EdgeDevice
	 * @generated
	 */
	EClass getEdgeDevice();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.EdgeDevice#isRouter <em>Router</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Router</em>'.
	 * @see iotmodel.EdgeDevice#isRouter()
	 * @see #getEdgeDevice()
	 * @generated
	 */
	EAttribute getEdgeDevice_Router();

	/**
	 * Returns the meta object for class '{@link iotmodel.AppChannel <em>App Channel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>App Channel</em>'.
	 * @see iotmodel.AppChannel
	 * @generated
	 */
	EClass getAppChannel();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.AppChannel#getBindTo <em>Bind To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Bind To</em>'.
	 * @see iotmodel.AppChannel#getBindTo()
	 * @see #getAppChannel()
	 * @generated
	 */
	EReference getAppChannel_BindTo();

	/**
	 * Returns the meta object for class '{@link iotmodel.Network <em>Network</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Network</em>'.
	 * @see iotmodel.Network
	 * @generated
	 */
	EClass getNetwork();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.Network#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see iotmodel.Network#getName()
	 * @see #getNetwork()
	 * @generated
	 */
	EAttribute getNetwork_Name();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.Network#getDomain <em>Domain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Domain</em>'.
	 * @see iotmodel.Network#getDomain()
	 * @see #getNetwork()
	 * @generated
	 */
	EAttribute getNetwork_Domain();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.Network#getEnforce <em>Enforce</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Enforce</em>'.
	 * @see iotmodel.Network#getEnforce()
	 * @see #getNetwork()
	 * @generated
	 */
	EReference getNetwork_Enforce();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Network#getThing <em>Thing</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Thing</em>'.
	 * @see iotmodel.Network#getThing()
	 * @see #getNetwork()
	 * @generated
	 */
	EReference getNetwork_Thing();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Network#getData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Data</em>'.
	 * @see iotmodel.Network#getData()
	 * @see #getNetwork()
	 * @generated
	 */
	EReference getNetwork_Data();

	/**
	 * Returns the meta object for class '{@link iotmodel.RequestResponse <em>Request Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Request Response</em>'.
	 * @see iotmodel.RequestResponse
	 * @generated
	 */
	EClass getRequestResponse();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.RequestResponse#getServer <em>Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Server</em>'.
	 * @see iotmodel.RequestResponse#getServer()
	 * @see #getRequestResponse()
	 * @generated
	 */
	EReference getRequestResponse_Server();

	/**
	 * Returns the meta object for class '{@link iotmodel.PublishSubscribe <em>Publish Subscribe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Publish Subscribe</em>'.
	 * @see iotmodel.PublishSubscribe
	 * @generated
	 */
	EClass getPublishSubscribe();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.PublishSubscribe#getPublishSubscribe <em>Publish Subscribe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Publish Subscribe</em>'.
	 * @see iotmodel.PublishSubscribe#getPublishSubscribe()
	 * @see #getPublishSubscribe()
	 * @generated
	 */
	EReference getPublishSubscribe_PublishSubscribe();

	/**
	 * Returns the meta object for class '{@link iotmodel.Thing <em>Thing</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Thing</em>'.
	 * @see iotmodel.Thing
	 * @generated
	 */
	EClass getThing();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Thing#getIotos <em>Iotos</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Iotos</em>'.
	 * @see iotmodel.Thing#getIotos()
	 * @see #getThing()
	 * @generated
	 */
	EReference getThing_Iotos();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.Thing#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see iotmodel.Thing#getName()
	 * @see #getThing()
	 * @generated
	 */
	EAttribute getThing_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Thing#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Id</em>'.
	 * @see iotmodel.Thing#getId()
	 * @see #getThing()
	 * @generated
	 */
	EReference getThing_Id();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Thing#getBehavior <em>Behavior</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Behavior</em>'.
	 * @see iotmodel.Thing#getBehavior()
	 * @see #getThing()
	 * @generated
	 */
	EReference getThing_Behavior();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Thing#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Message</em>'.
	 * @see iotmodel.Thing#getMessage()
	 * @see #getThing()
	 * @generated
	 */
	EReference getThing_Message();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Thing#getContainsPorts <em>Contains Ports</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Contains Ports</em>'.
	 * @see iotmodel.Thing#getContainsPorts()
	 * @see #getThing()
	 * @generated
	 */
	EReference getThing_ContainsPorts();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Thing#getProduce <em>Produce</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Produce</em>'.
	 * @see iotmodel.Thing#getProduce()
	 * @see #getThing()
	 * @generated
	 */
	EReference getThing_Produce();

	/**
	 * Returns the meta object for class '{@link iotmodel.AccessControlPolicy <em>Access Control Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Access Control Policy</em>'.
	 * @see iotmodel.AccessControlPolicy
	 * @generated
	 */
	EClass getAccessControlPolicy();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.AccessControlPolicy#getRule <em>Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Rule</em>'.
	 * @see iotmodel.AccessControlPolicy#getRule()
	 * @see #getAccessControlPolicy()
	 * @generated
	 */
	EReference getAccessControlPolicy_Rule();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.AccessControlPolicy#getIsEnforced <em>Is Enforced</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Is Enforced</em>'.
	 * @see iotmodel.AccessControlPolicy#getIsEnforced()
	 * @see #getAccessControlPolicy()
	 * @generated
	 */
	EReference getAccessControlPolicy_IsEnforced();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.AccessControlPolicy#getPolicyName <em>Policy Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Policy Name</em>'.
	 * @see iotmodel.AccessControlPolicy#getPolicyName()
	 * @see #getAccessControlPolicy()
	 * @generated
	 */
	EAttribute getAccessControlPolicy_PolicyName();

	/**
	 * Returns the meta object for class '{@link iotmodel.ProtocolStack <em>Protocol Stack</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Protocol Stack</em>'.
	 * @see iotmodel.ProtocolStack
	 * @generated
	 */
	EClass getProtocolStack();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.ProtocolStack#getPHYDATA <em>PHYDATA</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>PHYDATA</em>'.
	 * @see iotmodel.ProtocolStack#getPHYDATA()
	 * @see #getProtocolStack()
	 * @generated
	 */
	EAttribute getProtocolStack_PHYDATA();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.ProtocolStack#getNWK <em>NWK</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>NWK</em>'.
	 * @see iotmodel.ProtocolStack#getNWK()
	 * @see #getProtocolStack()
	 * @generated
	 */
	EAttribute getProtocolStack_NWK();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.ProtocolStack#getTransport <em>Transport</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Transport</em>'.
	 * @see iotmodel.ProtocolStack#getTransport()
	 * @see #getProtocolStack()
	 * @generated
	 */
	EAttribute getProtocolStack_Transport();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.ProtocolStack#getApplicationProtocol <em>Application Protocol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Application Protocol</em>'.
	 * @see iotmodel.ProtocolStack#getApplicationProtocol()
	 * @see #getProtocolStack()
	 * @generated
	 */
	EAttribute getProtocolStack_ApplicationProtocol();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.ProtocolStack#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see iotmodel.ProtocolStack#getName()
	 * @see #getProtocolStack()
	 * @generated
	 */
	EAttribute getProtocolStack_Name();

	/**
	 * Returns the meta object for class '{@link iotmodel.Rule <em>Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rule</em>'.
	 * @see iotmodel.Rule
	 * @generated
	 */
	EClass getRule();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Rule#getThing <em>Thing</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Thing</em>'.
	 * @see iotmodel.Rule#getThing()
	 * @see #getRule()
	 * @generated
	 */
	EReference getRule_Thing();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Rule#getPermission <em>Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Permission</em>'.
	 * @see iotmodel.Rule#getPermission()
	 * @see #getRule()
	 * @generated
	 */
	EReference getRule_Permission();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Rule#getConstraintexpression <em>Constraintexpression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Constraintexpression</em>'.
	 * @see iotmodel.Rule#getConstraintexpression()
	 * @see #getRule()
	 * @generated
	 */
	EReference getRule_Constraintexpression();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.Rule#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see iotmodel.Rule#getName()
	 * @see #getRule()
	 * @generated
	 */
	EAttribute getRule_Name();

	/**
	 * Returns the meta object for class '{@link iotmodel.IoTOs <em>Io TOs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Io TOs</em>'.
	 * @see iotmodel.IoTOs
	 * @generated
	 */
	EClass getIoTOs();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.IoTOs#getImplements <em>Implements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Implements</em>'.
	 * @see iotmodel.IoTOs#getImplements()
	 * @see #getIoTOs()
	 * @generated
	 */
	EReference getIoTOs_Implements();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.IoTOs#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see iotmodel.IoTOs#getName()
	 * @see #getIoTOs()
	 * @generated
	 */
	EAttribute getIoTOs_Name();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.IoTOs#getThing <em>Thing</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Thing</em>'.
	 * @see iotmodel.IoTOs#getThing()
	 * @see #getIoTOs()
	 * @generated
	 */
	EReference getIoTOs_Thing();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.IoTOs#getProgrammingmodel <em>Programmingmodel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Programmingmodel</em>'.
	 * @see iotmodel.IoTOs#getProgrammingmodel()
	 * @see #getIoTOs()
	 * @generated
	 */
	EReference getIoTOs_Programmingmodel();

	/**
	 * Returns the meta object for class '{@link iotmodel.IoTPlatform <em>Io TPlatform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Io TPlatform</em>'.
	 * @see iotmodel.IoTPlatform
	 * @generated
	 */
	EClass getIoTPlatform();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.IoTPlatform#getUseProtocol <em>Use Protocol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Use Protocol</em>'.
	 * @see iotmodel.IoTPlatform#getUseProtocol()
	 * @see #getIoTPlatform()
	 * @generated
	 */
	EReference getIoTPlatform_UseProtocol();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.IoTPlatform#getSentReceivedByPlatform <em>Sent Received By Platform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Sent Received By Platform</em>'.
	 * @see iotmodel.IoTPlatform#getSentReceivedByPlatform()
	 * @see #getIoTPlatform()
	 * @generated
	 */
	EReference getIoTPlatform_SentReceivedByPlatform();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.IoTPlatform#getCommunicateThrough <em>Communicate Through</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Communicate Through</em>'.
	 * @see iotmodel.IoTPlatform#getCommunicateThrough()
	 * @see #getIoTPlatform()
	 * @generated
	 */
	EReference getIoTPlatform_CommunicateThrough();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.IoTPlatform#getUserapplication <em>Userapplication</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Userapplication</em>'.
	 * @see iotmodel.IoTPlatform#getUserapplication()
	 * @see #getIoTPlatform()
	 * @generated
	 */
	EReference getIoTPlatform_Userapplication();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.IoTPlatform#getMessagebroker <em>Messagebroker</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Messagebroker</em>'.
	 * @see iotmodel.IoTPlatform#getMessagebroker()
	 * @see #getIoTPlatform()
	 * @generated
	 */
	EReference getIoTPlatform_Messagebroker();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.IoTPlatform#getWebserver <em>Webserver</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Webserver</em>'.
	 * @see iotmodel.IoTPlatform#getWebserver()
	 * @see #getIoTPlatform()
	 * @generated
	 */
	EReference getIoTPlatform_Webserver();

	/**
	 * Returns the meta object for class '{@link iotmodel.Message <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Message</em>'.
	 * @see iotmodel.Message
	 * @generated
	 */
	EClass getMessage();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Message#getSendReceiveMessage <em>Send Receive Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Send Receive Message</em>'.
	 * @see iotmodel.Message#getSendReceiveMessage()
	 * @see #getMessage()
	 * @generated
	 */
	EReference getMessage_SendReceiveMessage();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Message#getEncapsualte <em>Encapsualte</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Encapsualte</em>'.
	 * @see iotmodel.Message#getEncapsualte()
	 * @see #getMessage()
	 * @generated
	 */
	EReference getMessage_Encapsualte();

	/**
	 * Returns the meta object for class '{@link iotmodel.MessageFormat <em>Message Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Message Format</em>'.
	 * @see iotmodel.MessageFormat
	 * @generated
	 */
	EClass getMessageFormat();

	/**
	 * Returns the meta object for class '{@link iotmodel.MessageBroker <em>Message Broker</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Message Broker</em>'.
	 * @see iotmodel.MessageBroker
	 * @generated
	 */
	EClass getMessageBroker();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.MessageBroker#getUsedBy <em>Used By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Used By</em>'.
	 * @see iotmodel.MessageBroker#getUsedBy()
	 * @see #getMessageBroker()
	 * @generated
	 */
	EReference getMessageBroker_UsedBy();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.MessageBroker#getTopic <em>Topic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Topic</em>'.
	 * @see iotmodel.MessageBroker#getTopic()
	 * @see #getMessageBroker()
	 * @generated
	 */
	EReference getMessageBroker_Topic();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.MessageBroker#getIotplatform <em>Iotplatform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Iotplatform</em>'.
	 * @see iotmodel.MessageBroker#getIotplatform()
	 * @see #getMessageBroker()
	 * @generated
	 */
	EReference getMessageBroker_Iotplatform();

	/**
	 * Returns the meta object for class '{@link iotmodel.Topic <em>Topic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Topic</em>'.
	 * @see iotmodel.Topic
	 * @generated
	 */
	EClass getTopic();

	/**
	 * Returns the meta object for class '{@link iotmodel.UserApplication <em>User Application</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>User Application</em>'.
	 * @see iotmodel.UserApplication
	 * @generated
	 */
	EClass getUserApplication();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.UserApplication#getIotplatform <em>Iotplatform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Iotplatform</em>'.
	 * @see iotmodel.UserApplication#getIotplatform()
	 * @see #getUserApplication()
	 * @generated
	 */
	EReference getUserApplication_Iotplatform();

	/**
	 * Returns the meta object for class '{@link iotmodel.DesktopApp <em>Desktop App</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Desktop App</em>'.
	 * @see iotmodel.DesktopApp
	 * @generated
	 */
	EClass getDesktopApp();

	/**
	 * Returns the meta object for class '{@link iotmodel.MobileApp <em>Mobile App</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Mobile App</em>'.
	 * @see iotmodel.MobileApp
	 * @generated
	 */
	EClass getMobileApp();

	/**
	 * Returns the meta object for class '{@link iotmodel.WebServer <em>Web Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Web Server</em>'.
	 * @see iotmodel.WebServer
	 * @generated
	 */
	EClass getWebServer();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.WebServer#getRequestresponse <em>Requestresponse</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Requestresponse</em>'.
	 * @see iotmodel.WebServer#getRequestresponse()
	 * @see #getWebServer()
	 * @generated
	 */
	EReference getWebServer_Requestresponse();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.WebServer#getIotplatform <em>Iotplatform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Iotplatform</em>'.
	 * @see iotmodel.WebServer#getIotplatform()
	 * @see #getWebServer()
	 * @generated
	 */
	EReference getWebServer_Iotplatform();

	/**
	 * Returns the meta object for class '{@link iotmodel.DefaultPolicy <em>Default Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Default Policy</em>'.
	 * @see iotmodel.DefaultPolicy
	 * @generated
	 */
	EClass getDefaultPolicy();

	/**
	 * Returns the meta object for class '{@link iotmodel.PrivatePolicy <em>Private Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Private Policy</em>'.
	 * @see iotmodel.PrivatePolicy
	 * @generated
	 */
	EClass getPrivatePolicy();

	/**
	 * Returns the meta object for class '{@link iotmodel.Permission <em>Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Permission</em>'.
	 * @see iotmodel.Permission
	 * @generated
	 */
	EClass getPermission();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Permission#getPermitOrDeny <em>Permit Or Deny</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Permit Or Deny</em>'.
	 * @see iotmodel.Permission#getPermitOrDeny()
	 * @see #getPermission()
	 * @generated
	 */
	EReference getPermission_PermitOrDeny();

	/**
	 * Returns the meta object for class '{@link iotmodel.ConstraintExpression <em>Constraint Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constraint Expression</em>'.
	 * @see iotmodel.ConstraintExpression
	 * @generated
	 */
	EClass getConstraintExpression();

	/**
	 * Returns the meta object for class '{@link iotmodel.AllowPermission <em>Allow Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Allow Permission</em>'.
	 * @see iotmodel.AllowPermission
	 * @generated
	 */
	EClass getAllowPermission();

	/**
	 * Returns the meta object for class '{@link iotmodel.DenyPermission <em>Deny Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Deny Permission</em>'.
	 * @see iotmodel.DenyPermission
	 * @generated
	 */
	EClass getDenyPermission();

	/**
	 * Returns the meta object for class '{@link iotmodel.Sensor <em>Sensor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sensor</em>'.
	 * @see iotmodel.Sensor
	 * @generated
	 */
	EClass getSensor();

	/**
	 * Returns the meta object for class '{@link iotmodel.Actuator <em>Actuator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Actuator</em>'.
	 * @see iotmodel.Actuator
	 * @generated
	 */
	EClass getActuator();

	/**
	 * Returns the meta object for class '{@link iotmodel.IoTMetamodel <em>Io TMetamodel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Io TMetamodel</em>'.
	 * @see iotmodel.IoTMetamodel
	 * @generated
	 */
	EClass getIoTMetamodel();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.IoTMetamodel#getIotplatform <em>Iotplatform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Iotplatform</em>'.
	 * @see iotmodel.IoTMetamodel#getIotplatform()
	 * @see #getIoTMetamodel()
	 * @generated
	 */
	EReference getIoTMetamodel_Iotplatform();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.IoTMetamodel#getNetwork <em>Network</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Network</em>'.
	 * @see iotmodel.IoTMetamodel#getNetwork()
	 * @see #getIoTMetamodel()
	 * @generated
	 */
	EReference getIoTMetamodel_Network();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.IoTMetamodel#getAccesscontrolpolicy <em>Accesscontrolpolicy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Accesscontrolpolicy</em>'.
	 * @see iotmodel.IoTMetamodel#getAccesscontrolpolicy()
	 * @see #getIoTMetamodel()
	 * @generated
	 */
	EReference getIoTMetamodel_Accesscontrolpolicy();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.IoTMetamodel#getIotos <em>Iotos</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Iotos</em>'.
	 * @see iotmodel.IoTMetamodel#getIotos()
	 * @see #getIoTMetamodel()
	 * @generated
	 */
	EReference getIoTMetamodel_Iotos();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.IoTMetamodel#getProtocolstack <em>Protocolstack</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Protocolstack</em>'.
	 * @see iotmodel.IoTMetamodel#getProtocolstack()
	 * @see #getIoTMetamodel()
	 * @generated
	 */
	EReference getIoTMetamodel_Protocolstack();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.IoTMetamodel#getChannel <em>Channel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Channel</em>'.
	 * @see iotmodel.IoTMetamodel#getChannel()
	 * @see #getIoTMetamodel()
	 * @generated
	 */
	EReference getIoTMetamodel_Channel();

	/**
	 * Returns the meta object for class '{@link iotmodel.ID <em>ID</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>ID</em>'.
	 * @see iotmodel.ID
	 * @generated
	 */
	EClass getID();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.ID#getID <em>ID</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>ID</em>'.
	 * @see iotmodel.ID#getID()
	 * @see #getID()
	 * @generated
	 */
	EAttribute getID_ID();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.ID#getNewAttribute <em>New Attribute</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>New Attribute</em>'.
	 * @see iotmodel.ID#getNewAttribute()
	 * @see #getID()
	 * @generated
	 */
	EAttribute getID_NewAttribute();

	/**
	 * Returns the meta object for class '{@link iotmodel.Behavior <em>Behavior</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Behavior</em>'.
	 * @see iotmodel.Behavior
	 * @generated
	 */
	EClass getBehavior();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Behavior#getMakeAction <em>Make Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Make Action</em>'.
	 * @see iotmodel.Behavior#getMakeAction()
	 * @see #getBehavior()
	 * @generated
	 */
	EReference getBehavior_MakeAction();

	/**
	 * Returns the meta object for the containment reference list '{@link iotmodel.Behavior#getEvent <em>Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Event</em>'.
	 * @see iotmodel.Behavior#getEvent()
	 * @see #getBehavior()
	 * @generated
	 */
	EReference getBehavior_Event();

	/**
	 * Returns the meta object for class '{@link iotmodel.Action <em>Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Action</em>'.
	 * @see iotmodel.Action
	 * @generated
	 */
	EClass getAction();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Action#getPermission <em>Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Permission</em>'.
	 * @see iotmodel.Action#getPermission()
	 * @see #getAction()
	 * @generated
	 */
	EReference getAction_Permission();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Action#getHasEvent <em>Has Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Has Event</em>'.
	 * @see iotmodel.Action#getHasEvent()
	 * @see #getAction()
	 * @generated
	 */
	EReference getAction_HasEvent();

	/**
	 * Returns the meta object for class '{@link iotmodel.Event <em>Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event</em>'.
	 * @see iotmodel.Event
	 * @generated
	 */
	EClass getEvent();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Event#getTriggerAction <em>Trigger Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Trigger Action</em>'.
	 * @see iotmodel.Event#getTriggerAction()
	 * @see #getEvent()
	 * @generated
	 */
	EReference getEvent_TriggerAction();

	/**
	 * Returns the meta object for class '{@link iotmodel.ProgrammingModel <em>Programming Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Programming Model</em>'.
	 * @see iotmodel.ProgrammingModel
	 * @generated
	 */
	EClass getProgrammingModel();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.ProgrammingModel#getLanguage <em>Language</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Language</em>'.
	 * @see iotmodel.ProgrammingModel#getLanguage()
	 * @see #getProgrammingModel()
	 * @generated
	 */
	EAttribute getProgrammingModel_Language();

	/**
	 * Returns the meta object for class '{@link iotmodel.SharedAction <em>Shared Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Shared Action</em>'.
	 * @see iotmodel.SharedAction
	 * @generated
	 */
	EClass getSharedAction();

	/**
	 * Returns the meta object for class '{@link iotmodel.AppPort <em>App Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>App Port</em>'.
	 * @see iotmodel.AppPort
	 * @generated
	 */
	EClass getAppPort();

	/**
	 * Returns the meta object for the reference list '{@link iotmodel.AppPort#getIsBound <em>Is Bound</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Is Bound</em>'.
	 * @see iotmodel.AppPort#getIsBound()
	 * @see #getAppPort()
	 * @generated
	 */
	EReference getAppPort_IsBound();

	/**
	 * Returns the meta object for class '{@link iotmodel.Data <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data</em>'.
	 * @see iotmodel.Data
	 * @generated
	 */
	EClass getData();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Data#getIsEncapsulated <em>Is Encapsulated</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Is Encapsulated</em>'.
	 * @see iotmodel.Data#getIsEncapsulated()
	 * @see #getData()
	 * @generated
	 */
	EReference getData_IsEncapsulated();

	/**
	 * Returns the meta object for class '{@link iotmodel.Actor <em>Actor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Actor</em>'.
	 * @see iotmodel.Actor
	 * @generated
	 */
	EClass getActor();

	/**
	 * Returns the meta object for the reference '{@link iotmodel.Actor#getUses <em>Uses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Uses</em>'.
	 * @see iotmodel.Actor#getUses()
	 * @see #getActor()
	 * @generated
	 */
	EReference getActor_Uses();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.Actor#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see iotmodel.Actor#getName()
	 * @see #getActor()
	 * @generated
	 */
	EAttribute getActor_Name();

	/**
	 * Returns the meta object for the attribute '{@link iotmodel.Actor#getIntent <em>Intent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Intent</em>'.
	 * @see iotmodel.Actor#getIntent()
	 * @see #getActor()
	 * @generated
	 */
	EAttribute getActor_Intent();

	/**
	 * Returns the meta object for class '{@link iotmodel.MaliciousActor <em>Malicious Actor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Malicious Actor</em>'.
	 * @see iotmodel.MaliciousActor
	 * @generated
	 */
	EClass getMaliciousActor();

	/**
	 * Returns the meta object for enum '{@link iotmodel.OsList <em>Os List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Os List</em>'.
	 * @see iotmodel.OsList
	 * @generated
	 */
	EEnum getOsList();

	/**
	 * Returns the meta object for enum '{@link iotmodel.PhysicalLinkLayer <em>Physical Link Layer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Physical Link Layer</em>'.
	 * @see iotmodel.PhysicalLinkLayer
	 * @generated
	 */
	EEnum getPhysicalLinkLayer();

	/**
	 * Returns the meta object for enum '{@link iotmodel.TransportLayer <em>Transport Layer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Transport Layer</em>'.
	 * @see iotmodel.TransportLayer
	 * @generated
	 */
	EEnum getTransportLayer();

	/**
	 * Returns the meta object for enum '{@link iotmodel.NetworkLayer <em>Network Layer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Network Layer</em>'.
	 * @see iotmodel.NetworkLayer
	 * @generated
	 */
	EEnum getNetworkLayer();

	/**
	 * Returns the meta object for enum '{@link iotmodel.ApplicationLayer <em>Application Layer</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Application Layer</em>'.
	 * @see iotmodel.ApplicationLayer
	 * @generated
	 */
	EEnum getApplicationLayer();

	/**
	 * Returns the meta object for enum '{@link iotmodel.IdList <em>Id List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Id List</em>'.
	 * @see iotmodel.IdList
	 * @generated
	 */
	EEnum getIdList();

	/**
	 * Returns the meta object for enum '{@link iotmodel.LanguageList <em>Language List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Language List</em>'.
	 * @see iotmodel.LanguageList
	 * @generated
	 */
	EEnum getLanguageList();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	IotmodelFactory getIotmodelFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link iotmodel.impl.GatewayImpl <em>Gateway</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.GatewayImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getGateway()
		 * @generated
		 */
		EClass GATEWAY = eINSTANCE.getGateway();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.EdgeDeviceImpl <em>Edge Device</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.EdgeDeviceImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getEdgeDevice()
		 * @generated
		 */
		EClass EDGE_DEVICE = eINSTANCE.getEdgeDevice();

		/**
		 * The meta object literal for the '<em><b>Router</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EDGE_DEVICE__ROUTER = eINSTANCE.getEdgeDevice_Router();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.AppChannelImpl <em>App Channel</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.AppChannelImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getAppChannel()
		 * @generated
		 */
		EClass APP_CHANNEL = eINSTANCE.getAppChannel();

		/**
		 * The meta object literal for the '<em><b>Bind To</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference APP_CHANNEL__BIND_TO = eINSTANCE.getAppChannel_BindTo();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.NetworkImpl <em>Network</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.NetworkImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getNetwork()
		 * @generated
		 */
		EClass NETWORK = eINSTANCE.getNetwork();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NETWORK__NAME = eINSTANCE.getNetwork_Name();

		/**
		 * The meta object literal for the '<em><b>Domain</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NETWORK__DOMAIN = eINSTANCE.getNetwork_Domain();

		/**
		 * The meta object literal for the '<em><b>Enforce</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK__ENFORCE = eINSTANCE.getNetwork_Enforce();

		/**
		 * The meta object literal for the '<em><b>Thing</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK__THING = eINSTANCE.getNetwork_Thing();

		/**
		 * The meta object literal for the '<em><b>Data</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK__DATA = eINSTANCE.getNetwork_Data();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.RequestResponseImpl <em>Request Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.RequestResponseImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getRequestResponse()
		 * @generated
		 */
		EClass REQUEST_RESPONSE = eINSTANCE.getRequestResponse();

		/**
		 * The meta object literal for the '<em><b>Server</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REQUEST_RESPONSE__SERVER = eINSTANCE.getRequestResponse_Server();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.PublishSubscribeImpl <em>Publish Subscribe</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.PublishSubscribeImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getPublishSubscribe()
		 * @generated
		 */
		EClass PUBLISH_SUBSCRIBE = eINSTANCE.getPublishSubscribe();

		/**
		 * The meta object literal for the '<em><b>Publish Subscribe</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PUBLISH_SUBSCRIBE__PUBLISH_SUBSCRIBE = eINSTANCE.getPublishSubscribe_PublishSubscribe();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.ThingImpl <em>Thing</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.ThingImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getThing()
		 * @generated
		 */
		EClass THING = eINSTANCE.getThing();

		/**
		 * The meta object literal for the '<em><b>Iotos</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THING__IOTOS = eINSTANCE.getThing_Iotos();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute THING__NAME = eINSTANCE.getThing_Name();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THING__ID = eINSTANCE.getThing_Id();

		/**
		 * The meta object literal for the '<em><b>Behavior</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THING__BEHAVIOR = eINSTANCE.getThing_Behavior();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THING__MESSAGE = eINSTANCE.getThing_Message();

		/**
		 * The meta object literal for the '<em><b>Contains Ports</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THING__CONTAINS_PORTS = eINSTANCE.getThing_ContainsPorts();

		/**
		 * The meta object literal for the '<em><b>Produce</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THING__PRODUCE = eINSTANCE.getThing_Produce();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.AccessControlPolicyImpl <em>Access Control Policy</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.AccessControlPolicyImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getAccessControlPolicy()
		 * @generated
		 */
		EClass ACCESS_CONTROL_POLICY = eINSTANCE.getAccessControlPolicy();

		/**
		 * The meta object literal for the '<em><b>Rule</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACCESS_CONTROL_POLICY__RULE = eINSTANCE.getAccessControlPolicy_Rule();

		/**
		 * The meta object literal for the '<em><b>Is Enforced</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACCESS_CONTROL_POLICY__IS_ENFORCED = eINSTANCE.getAccessControlPolicy_IsEnforced();

		/**
		 * The meta object literal for the '<em><b>Policy Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ACCESS_CONTROL_POLICY__POLICY_NAME = eINSTANCE.getAccessControlPolicy_PolicyName();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.ProtocolStackImpl <em>Protocol Stack</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.ProtocolStackImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getProtocolStack()
		 * @generated
		 */
		EClass PROTOCOL_STACK = eINSTANCE.getProtocolStack();

		/**
		 * The meta object literal for the '<em><b>PHYDATA</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROTOCOL_STACK__PHYDATA = eINSTANCE.getProtocolStack_PHYDATA();

		/**
		 * The meta object literal for the '<em><b>NWK</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROTOCOL_STACK__NWK = eINSTANCE.getProtocolStack_NWK();

		/**
		 * The meta object literal for the '<em><b>Transport</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROTOCOL_STACK__TRANSPORT = eINSTANCE.getProtocolStack_Transport();

		/**
		 * The meta object literal for the '<em><b>Application Protocol</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROTOCOL_STACK__APPLICATION_PROTOCOL = eINSTANCE.getProtocolStack_ApplicationProtocol();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROTOCOL_STACK__NAME = eINSTANCE.getProtocolStack_Name();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.RuleImpl <em>Rule</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.RuleImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getRule()
		 * @generated
		 */
		EClass RULE = eINSTANCE.getRule();

		/**
		 * The meta object literal for the '<em><b>Thing</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RULE__THING = eINSTANCE.getRule_Thing();

		/**
		 * The meta object literal for the '<em><b>Permission</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RULE__PERMISSION = eINSTANCE.getRule_Permission();

		/**
		 * The meta object literal for the '<em><b>Constraintexpression</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RULE__CONSTRAINTEXPRESSION = eINSTANCE.getRule_Constraintexpression();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RULE__NAME = eINSTANCE.getRule_Name();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.IoTOsImpl <em>Io TOs</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.IoTOsImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getIoTOs()
		 * @generated
		 */
		EClass IO_TOS = eINSTANCE.getIoTOs();

		/**
		 * The meta object literal for the '<em><b>Implements</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TOS__IMPLEMENTS = eINSTANCE.getIoTOs_Implements();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute IO_TOS__NAME = eINSTANCE.getIoTOs_Name();

		/**
		 * The meta object literal for the '<em><b>Thing</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TOS__THING = eINSTANCE.getIoTOs_Thing();

		/**
		 * The meta object literal for the '<em><b>Programmingmodel</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TOS__PROGRAMMINGMODEL = eINSTANCE.getIoTOs_Programmingmodel();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.IoTPlatformImpl <em>Io TPlatform</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.IoTPlatformImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getIoTPlatform()
		 * @generated
		 */
		EClass IO_TPLATFORM = eINSTANCE.getIoTPlatform();

		/**
		 * The meta object literal for the '<em><b>Use Protocol</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TPLATFORM__USE_PROTOCOL = eINSTANCE.getIoTPlatform_UseProtocol();

		/**
		 * The meta object literal for the '<em><b>Sent Received By Platform</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM = eINSTANCE.getIoTPlatform_SentReceivedByPlatform();

		/**
		 * The meta object literal for the '<em><b>Communicate Through</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TPLATFORM__COMMUNICATE_THROUGH = eINSTANCE.getIoTPlatform_CommunicateThrough();

		/**
		 * The meta object literal for the '<em><b>Userapplication</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TPLATFORM__USERAPPLICATION = eINSTANCE.getIoTPlatform_Userapplication();

		/**
		 * The meta object literal for the '<em><b>Messagebroker</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TPLATFORM__MESSAGEBROKER = eINSTANCE.getIoTPlatform_Messagebroker();

		/**
		 * The meta object literal for the '<em><b>Webserver</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TPLATFORM__WEBSERVER = eINSTANCE.getIoTPlatform_Webserver();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.MessageImpl <em>Message</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.MessageImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getMessage()
		 * @generated
		 */
		EClass MESSAGE = eINSTANCE.getMessage();

		/**
		 * The meta object literal for the '<em><b>Send Receive Message</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE__SEND_RECEIVE_MESSAGE = eINSTANCE.getMessage_SendReceiveMessage();

		/**
		 * The meta object literal for the '<em><b>Encapsualte</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE__ENCAPSUALTE = eINSTANCE.getMessage_Encapsualte();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.MessageFormatImpl <em>Message Format</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.MessageFormatImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getMessageFormat()
		 * @generated
		 */
		EClass MESSAGE_FORMAT = eINSTANCE.getMessageFormat();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.MessageBrokerImpl <em>Message Broker</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.MessageBrokerImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getMessageBroker()
		 * @generated
		 */
		EClass MESSAGE_BROKER = eINSTANCE.getMessageBroker();

		/**
		 * The meta object literal for the '<em><b>Used By</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE_BROKER__USED_BY = eINSTANCE.getMessageBroker_UsedBy();

		/**
		 * The meta object literal for the '<em><b>Topic</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE_BROKER__TOPIC = eINSTANCE.getMessageBroker_Topic();

		/**
		 * The meta object literal for the '<em><b>Iotplatform</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE_BROKER__IOTPLATFORM = eINSTANCE.getMessageBroker_Iotplatform();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.TopicImpl <em>Topic</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.TopicImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getTopic()
		 * @generated
		 */
		EClass TOPIC = eINSTANCE.getTopic();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.UserApplicationImpl <em>User Application</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.UserApplicationImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getUserApplication()
		 * @generated
		 */
		EClass USER_APPLICATION = eINSTANCE.getUserApplication();

		/**
		 * The meta object literal for the '<em><b>Iotplatform</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference USER_APPLICATION__IOTPLATFORM = eINSTANCE.getUserApplication_Iotplatform();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.DesktopAppImpl <em>Desktop App</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.DesktopAppImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getDesktopApp()
		 * @generated
		 */
		EClass DESKTOP_APP = eINSTANCE.getDesktopApp();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.MobileAppImpl <em>Mobile App</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.MobileAppImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getMobileApp()
		 * @generated
		 */
		EClass MOBILE_APP = eINSTANCE.getMobileApp();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.WebServerImpl <em>Web Server</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.WebServerImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getWebServer()
		 * @generated
		 */
		EClass WEB_SERVER = eINSTANCE.getWebServer();

		/**
		 * The meta object literal for the '<em><b>Requestresponse</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WEB_SERVER__REQUESTRESPONSE = eINSTANCE.getWebServer_Requestresponse();

		/**
		 * The meta object literal for the '<em><b>Iotplatform</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference WEB_SERVER__IOTPLATFORM = eINSTANCE.getWebServer_Iotplatform();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.DefaultPolicyImpl <em>Default Policy</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.DefaultPolicyImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getDefaultPolicy()
		 * @generated
		 */
		EClass DEFAULT_POLICY = eINSTANCE.getDefaultPolicy();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.PrivatePolicyImpl <em>Private Policy</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.PrivatePolicyImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getPrivatePolicy()
		 * @generated
		 */
		EClass PRIVATE_POLICY = eINSTANCE.getPrivatePolicy();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.PermissionImpl <em>Permission</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.PermissionImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getPermission()
		 * @generated
		 */
		EClass PERMISSION = eINSTANCE.getPermission();

		/**
		 * The meta object literal for the '<em><b>Permit Or Deny</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PERMISSION__PERMIT_OR_DENY = eINSTANCE.getPermission_PermitOrDeny();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.ConstraintExpressionImpl <em>Constraint Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.ConstraintExpressionImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getConstraintExpression()
		 * @generated
		 */
		EClass CONSTRAINT_EXPRESSION = eINSTANCE.getConstraintExpression();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.AllowPermissionImpl <em>Allow Permission</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.AllowPermissionImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getAllowPermission()
		 * @generated
		 */
		EClass ALLOW_PERMISSION = eINSTANCE.getAllowPermission();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.DenyPermissionImpl <em>Deny Permission</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.DenyPermissionImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getDenyPermission()
		 * @generated
		 */
		EClass DENY_PERMISSION = eINSTANCE.getDenyPermission();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.SensorImpl <em>Sensor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.SensorImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getSensor()
		 * @generated
		 */
		EClass SENSOR = eINSTANCE.getSensor();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.ActuatorImpl <em>Actuator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.ActuatorImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getActuator()
		 * @generated
		 */
		EClass ACTUATOR = eINSTANCE.getActuator();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.IoTMetamodelImpl <em>Io TMetamodel</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.IoTMetamodelImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getIoTMetamodel()
		 * @generated
		 */
		EClass IO_TMETAMODEL = eINSTANCE.getIoTMetamodel();

		/**
		 * The meta object literal for the '<em><b>Iotplatform</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TMETAMODEL__IOTPLATFORM = eINSTANCE.getIoTMetamodel_Iotplatform();

		/**
		 * The meta object literal for the '<em><b>Network</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TMETAMODEL__NETWORK = eINSTANCE.getIoTMetamodel_Network();

		/**
		 * The meta object literal for the '<em><b>Accesscontrolpolicy</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TMETAMODEL__ACCESSCONTROLPOLICY = eINSTANCE.getIoTMetamodel_Accesscontrolpolicy();

		/**
		 * The meta object literal for the '<em><b>Iotos</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TMETAMODEL__IOTOS = eINSTANCE.getIoTMetamodel_Iotos();

		/**
		 * The meta object literal for the '<em><b>Protocolstack</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TMETAMODEL__PROTOCOLSTACK = eINSTANCE.getIoTMetamodel_Protocolstack();

		/**
		 * The meta object literal for the '<em><b>Channel</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference IO_TMETAMODEL__CHANNEL = eINSTANCE.getIoTMetamodel_Channel();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.IDImpl <em>ID</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.IDImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getID()
		 * @generated
		 */
		EClass ID = eINSTANCE.getID();

		/**
		 * The meta object literal for the '<em><b>ID</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ID__ID = eINSTANCE.getID_ID();

		/**
		 * The meta object literal for the '<em><b>New Attribute</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ID__NEW_ATTRIBUTE = eINSTANCE.getID_NewAttribute();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.BehaviorImpl <em>Behavior</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.BehaviorImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getBehavior()
		 * @generated
		 */
		EClass BEHAVIOR = eINSTANCE.getBehavior();

		/**
		 * The meta object literal for the '<em><b>Make Action</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BEHAVIOR__MAKE_ACTION = eINSTANCE.getBehavior_MakeAction();

		/**
		 * The meta object literal for the '<em><b>Event</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BEHAVIOR__EVENT = eINSTANCE.getBehavior_Event();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.ActionImpl <em>Action</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.ActionImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getAction()
		 * @generated
		 */
		EClass ACTION = eINSTANCE.getAction();

		/**
		 * The meta object literal for the '<em><b>Permission</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACTION__PERMISSION = eINSTANCE.getAction_Permission();

		/**
		 * The meta object literal for the '<em><b>Has Event</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACTION__HAS_EVENT = eINSTANCE.getAction_HasEvent();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.EventImpl <em>Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.EventImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getEvent()
		 * @generated
		 */
		EClass EVENT = eINSTANCE.getEvent();

		/**
		 * The meta object literal for the '<em><b>Trigger Action</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT__TRIGGER_ACTION = eINSTANCE.getEvent_TriggerAction();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.ProgrammingModelImpl <em>Programming Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.ProgrammingModelImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getProgrammingModel()
		 * @generated
		 */
		EClass PROGRAMMING_MODEL = eINSTANCE.getProgrammingModel();

		/**
		 * The meta object literal for the '<em><b>Language</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROGRAMMING_MODEL__LANGUAGE = eINSTANCE.getProgrammingModel_Language();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.SharedActionImpl <em>Shared Action</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.SharedActionImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getSharedAction()
		 * @generated
		 */
		EClass SHARED_ACTION = eINSTANCE.getSharedAction();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.AppPortImpl <em>App Port</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.AppPortImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getAppPort()
		 * @generated
		 */
		EClass APP_PORT = eINSTANCE.getAppPort();

		/**
		 * The meta object literal for the '<em><b>Is Bound</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference APP_PORT__IS_BOUND = eINSTANCE.getAppPort_IsBound();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.DataImpl <em>Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.DataImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getData()
		 * @generated
		 */
		EClass DATA = eINSTANCE.getData();

		/**
		 * The meta object literal for the '<em><b>Is Encapsulated</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DATA__IS_ENCAPSULATED = eINSTANCE.getData_IsEncapsulated();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.ActorImpl <em>Actor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.ActorImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getActor()
		 * @generated
		 */
		EClass ACTOR = eINSTANCE.getActor();

		/**
		 * The meta object literal for the '<em><b>Uses</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ACTOR__USES = eINSTANCE.getActor_Uses();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ACTOR__NAME = eINSTANCE.getActor_Name();

		/**
		 * The meta object literal for the '<em><b>Intent</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ACTOR__INTENT = eINSTANCE.getActor_Intent();

		/**
		 * The meta object literal for the '{@link iotmodel.impl.MaliciousActorImpl <em>Malicious Actor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.impl.MaliciousActorImpl
		 * @see iotmodel.impl.IotmodelPackageImpl#getMaliciousActor()
		 * @generated
		 */
		EClass MALICIOUS_ACTOR = eINSTANCE.getMaliciousActor();

		/**
		 * The meta object literal for the '{@link iotmodel.OsList <em>Os List</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.OsList
		 * @see iotmodel.impl.IotmodelPackageImpl#getOsList()
		 * @generated
		 */
		EEnum OS_LIST = eINSTANCE.getOsList();

		/**
		 * The meta object literal for the '{@link iotmodel.PhysicalLinkLayer <em>Physical Link Layer</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.PhysicalLinkLayer
		 * @see iotmodel.impl.IotmodelPackageImpl#getPhysicalLinkLayer()
		 * @generated
		 */
		EEnum PHYSICAL_LINK_LAYER = eINSTANCE.getPhysicalLinkLayer();

		/**
		 * The meta object literal for the '{@link iotmodel.TransportLayer <em>Transport Layer</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.TransportLayer
		 * @see iotmodel.impl.IotmodelPackageImpl#getTransportLayer()
		 * @generated
		 */
		EEnum TRANSPORT_LAYER = eINSTANCE.getTransportLayer();

		/**
		 * The meta object literal for the '{@link iotmodel.NetworkLayer <em>Network Layer</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.NetworkLayer
		 * @see iotmodel.impl.IotmodelPackageImpl#getNetworkLayer()
		 * @generated
		 */
		EEnum NETWORK_LAYER = eINSTANCE.getNetworkLayer();

		/**
		 * The meta object literal for the '{@link iotmodel.ApplicationLayer <em>Application Layer</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.ApplicationLayer
		 * @see iotmodel.impl.IotmodelPackageImpl#getApplicationLayer()
		 * @generated
		 */
		EEnum APPLICATION_LAYER = eINSTANCE.getApplicationLayer();

		/**
		 * The meta object literal for the '{@link iotmodel.IdList <em>Id List</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.IdList
		 * @see iotmodel.impl.IotmodelPackageImpl#getIdList()
		 * @generated
		 */
		EEnum ID_LIST = eINSTANCE.getIdList();

		/**
		 * The meta object literal for the '{@link iotmodel.LanguageList <em>Language List</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see iotmodel.LanguageList
		 * @see iotmodel.impl.IotmodelPackageImpl#getLanguageList()
		 * @generated
		 */
		EEnum LANGUAGE_LIST = eINSTANCE.getLanguageList();

	}

} //IotmodelPackage
