/**
 */
package iotmodel;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Network</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.Network#getName <em>Name</em>}</li>
 *   <li>{@link iotmodel.Network#getDomain <em>Domain</em>}</li>
 *   <li>{@link iotmodel.Network#getEnforce <em>Enforce</em>}</li>
 *   <li>{@link iotmodel.Network#getThing <em>Thing</em>}</li>
 *   <li>{@link iotmodel.Network#getData <em>Data</em>}</li>
 * </ul>
 *
 * @see iotmodel.IotmodelPackage#getNetwork()
 * @model
 * @generated
 */
public interface Network extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see iotmodel.IotmodelPackage#getNetwork_Name()
	 * @model unique="false"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link iotmodel.Network#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Domain</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Domain</em>' attribute.
	 * @see #setDomain(String)
	 * @see iotmodel.IotmodelPackage#getNetwork_Domain()
	 * @model unique="false"
	 * @generated
	 */
	String getDomain();

	/**
	 * Sets the value of the '{@link iotmodel.Network#getDomain <em>Domain</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Domain</em>' attribute.
	 * @see #getDomain()
	 * @generated
	 */
	void setDomain(String value);

	/**
	 * Returns the value of the '<em><b>Enforce</b></em>' reference list.
	 * The list contents are of type {@link iotmodel.AccessControlPolicy}.
	 * It is bidirectional and its opposite is '{@link iotmodel.AccessControlPolicy#getIsEnforced <em>Is Enforced</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Enforce</em>' reference list.
	 * @see iotmodel.IotmodelPackage#getNetwork_Enforce()
	 * @see iotmodel.AccessControlPolicy#getIsEnforced
	 * @model opposite="isEnforced"
	 * @generated
	 */
	EList<AccessControlPolicy> getEnforce();

	/**
	 * Returns the value of the '<em><b>Thing</b></em>' containment reference list.
	 * The list contents are of type {@link iotmodel.Thing}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Thing</em>' containment reference list.
	 * @see iotmodel.IotmodelPackage#getNetwork_Thing()
	 * @model containment="true"
	 * @generated
	 */
	EList<Thing> getThing();

	/**
	 * Returns the value of the '<em><b>Data</b></em>' containment reference list.
	 * The list contents are of type {@link iotmodel.Data}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Data</em>' containment reference list.
	 * @see iotmodel.IotmodelPackage#getNetwork_Data()
	 * @model containment="true"
	 * @generated
	 */
	EList<Data> getData();

} // Network
