/**
 */
package iotmodel.impl;

import iotmodel.AccessControlPolicy;
import iotmodel.Action;
import iotmodel.Actor;
import iotmodel.Actuator;
import iotmodel.AllowPermission;
import iotmodel.AppChannel;
import iotmodel.AppPort;
import iotmodel.ApplicationLayer;
import iotmodel.Behavior;
import iotmodel.ConstraintExpression;
import iotmodel.Data;
import iotmodel.DefaultPolicy;
import iotmodel.DenyPermission;
import iotmodel.DesktopApp;
import iotmodel.EdgeDevice;
import iotmodel.Event;
import iotmodel.Gateway;
import iotmodel.IdList;
import iotmodel.IoTMetamodel;
import iotmodel.IoTOs;
import iotmodel.IoTPlatform;
import iotmodel.IotmodelFactory;
import iotmodel.IotmodelPackage;
import iotmodel.LanguageList;
import iotmodel.MaliciousActor;
import iotmodel.Message;
import iotmodel.MessageBroker;
import iotmodel.MessageFormat;
import iotmodel.MobileApp;
import iotmodel.Network;
import iotmodel.NetworkLayer;
import iotmodel.OsList;
import iotmodel.Permission;
import iotmodel.PhysicalLinkLayer;
import iotmodel.PrivatePolicy;
import iotmodel.ProgrammingModel;
import iotmodel.ProtocolStack;
import iotmodel.PublishSubscribe;
import iotmodel.RequestResponse;
import iotmodel.Rule;
import iotmodel.Sensor;
import iotmodel.SharedAction;
import iotmodel.Thing;
import iotmodel.Topic;
import iotmodel.TransportLayer;
import iotmodel.UserApplication;
import iotmodel.WebServer;

import iotmodel.util.IotmodelValidator;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class IotmodelPackageImpl extends EPackageImpl implements IotmodelPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass gatewayEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass edgeDeviceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass appChannelEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass networkEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass requestResponseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass publishSubscribeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass thingEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass accessControlPolicyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass protocolStackEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ruleEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ioTOsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ioTPlatformEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass messageEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass messageFormatEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass messageBrokerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass topicEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass userApplicationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass desktopAppEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass mobileAppEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass webServerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass defaultPolicyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass privatePolicyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass permissionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass constraintExpressionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass allowPermissionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass denyPermissionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sensorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass actuatorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ioTMetamodelEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass idEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass behaviorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass actionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass eventEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass programmingModelEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sharedActionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass appPortEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass dataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass actorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass maliciousActorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum osListEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum physicalLinkLayerEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum transportLayerEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum networkLayerEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum applicationLayerEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum idListEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum languageListEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see iotmodel.IotmodelPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private IotmodelPackageImpl() {
		super(eNS_URI, IotmodelFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link IotmodelPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static IotmodelPackage init() {
		if (isInited) return (IotmodelPackage)EPackage.Registry.INSTANCE.getEPackage(IotmodelPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredIotmodelPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		IotmodelPackageImpl theIotmodelPackage = registeredIotmodelPackage instanceof IotmodelPackageImpl ? (IotmodelPackageImpl)registeredIotmodelPackage : new IotmodelPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theIotmodelPackage.createPackageContents();

		// Initialize created meta-data
		theIotmodelPackage.initializePackageContents();

		// Register package validator
		EValidator.Registry.INSTANCE.put
			(theIotmodelPackage,
			 new EValidator.Descriptor() {
				 public EValidator getEValidator() {
					 return IotmodelValidator.INSTANCE;
				 }
			 });

		// Mark meta-data to indicate it can't be changed
		theIotmodelPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(IotmodelPackage.eNS_URI, theIotmodelPackage);
		return theIotmodelPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getGateway() {
		return gatewayEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEdgeDevice() {
		return edgeDeviceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEdgeDevice_Router() {
		return (EAttribute)edgeDeviceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAppChannel() {
		return appChannelEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAppChannel_BindTo() {
		return (EReference)appChannelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNetwork() {
		return networkEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNetwork_Name() {
		return (EAttribute)networkEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNetwork_Domain() {
		return (EAttribute)networkEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetwork_Enforce() {
		return (EReference)networkEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetwork_Thing() {
		return (EReference)networkEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetwork_Data() {
		return (EReference)networkEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRequestResponse() {
		return requestResponseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRequestResponse_Server() {
		return (EReference)requestResponseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPublishSubscribe() {
		return publishSubscribeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPublishSubscribe_PublishSubscribe() {
		return (EReference)publishSubscribeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getThing() {
		return thingEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getThing_Iotos() {
		return (EReference)thingEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getThing_Name() {
		return (EAttribute)thingEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getThing_Id() {
		return (EReference)thingEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getThing_Behavior() {
		return (EReference)thingEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getThing_Message() {
		return (EReference)thingEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getThing_ContainsPorts() {
		return (EReference)thingEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getThing_Produce() {
		return (EReference)thingEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAccessControlPolicy() {
		return accessControlPolicyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAccessControlPolicy_Rule() {
		return (EReference)accessControlPolicyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAccessControlPolicy_IsEnforced() {
		return (EReference)accessControlPolicyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAccessControlPolicy_PolicyName() {
		return (EAttribute)accessControlPolicyEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProtocolStack() {
		return protocolStackEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProtocolStack_PHYDATA() {
		return (EAttribute)protocolStackEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProtocolStack_NWK() {
		return (EAttribute)protocolStackEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProtocolStack_Transport() {
		return (EAttribute)protocolStackEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProtocolStack_ApplicationProtocol() {
		return (EAttribute)protocolStackEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProtocolStack_Name() {
		return (EAttribute)protocolStackEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRule() {
		return ruleEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRule_Thing() {
		return (EReference)ruleEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRule_Permission() {
		return (EReference)ruleEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getRule_Constraintexpression() {
		return (EReference)ruleEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRule_Name() {
		return (EAttribute)ruleEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIoTOs() {
		return ioTOsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTOs_Implements() {
		return (EReference)ioTOsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getIoTOs_Name() {
		return (EAttribute)ioTOsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTOs_Thing() {
		return (EReference)ioTOsEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTOs_Programmingmodel() {
		return (EReference)ioTOsEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIoTPlatform() {
		return ioTPlatformEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTPlatform_UseProtocol() {
		return (EReference)ioTPlatformEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTPlatform_SentReceivedByPlatform() {
		return (EReference)ioTPlatformEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTPlatform_CommunicateThrough() {
		return (EReference)ioTPlatformEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTPlatform_Userapplication() {
		return (EReference)ioTPlatformEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTPlatform_Messagebroker() {
		return (EReference)ioTPlatformEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTPlatform_Webserver() {
		return (EReference)ioTPlatformEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMessage() {
		return messageEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMessage_SendReceiveMessage() {
		return (EReference)messageEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMessage_Encapsualte() {
		return (EReference)messageEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMessageFormat() {
		return messageFormatEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMessageBroker() {
		return messageBrokerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMessageBroker_UsedBy() {
		return (EReference)messageBrokerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMessageBroker_Topic() {
		return (EReference)messageBrokerEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMessageBroker_Iotplatform() {
		return (EReference)messageBrokerEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTopic() {
		return topicEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUserApplication() {
		return userApplicationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUserApplication_Iotplatform() {
		return (EReference)userApplicationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDesktopApp() {
		return desktopAppEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMobileApp() {
		return mobileAppEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getWebServer() {
		return webServerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getWebServer_Requestresponse() {
		return (EReference)webServerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getWebServer_Iotplatform() {
		return (EReference)webServerEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDefaultPolicy() {
		return defaultPolicyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPrivatePolicy() {
		return privatePolicyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPermission() {
		return permissionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPermission_PermitOrDeny() {
		return (EReference)permissionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getConstraintExpression() {
		return constraintExpressionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAllowPermission() {
		return allowPermissionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDenyPermission() {
		return denyPermissionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSensor() {
		return sensorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getActuator() {
		return actuatorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getIoTMetamodel() {
		return ioTMetamodelEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTMetamodel_Iotplatform() {
		return (EReference)ioTMetamodelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTMetamodel_Network() {
		return (EReference)ioTMetamodelEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTMetamodel_Accesscontrolpolicy() {
		return (EReference)ioTMetamodelEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTMetamodel_Iotos() {
		return (EReference)ioTMetamodelEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTMetamodel_Protocolstack() {
		return (EReference)ioTMetamodelEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getIoTMetamodel_Channel() {
		return (EReference)ioTMetamodelEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getID() {
		return idEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getID_ID() {
		return (EAttribute)idEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getID_NewAttribute() {
		return (EAttribute)idEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getBehavior() {
		return behaviorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBehavior_MakeAction() {
		return (EReference)behaviorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getBehavior_Event() {
		return (EReference)behaviorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAction() {
		return actionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAction_Permission() {
		return (EReference)actionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAction_HasEvent() {
		return (EReference)actionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEvent() {
		return eventEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEvent_TriggerAction() {
		return (EReference)eventEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProgrammingModel() {
		return programmingModelEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProgrammingModel_Language() {
		return (EAttribute)programmingModelEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSharedAction() {
		return sharedActionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAppPort() {
		return appPortEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAppPort_IsBound() {
		return (EReference)appPortEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getData() {
		return dataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getData_IsEncapsulated() {
		return (EReference)dataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getActor() {
		return actorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getActor_Uses() {
		return (EReference)actorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getActor_Name() {
		return (EAttribute)actorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getActor_Intent() {
		return (EAttribute)actorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMaliciousActor() {
		return maliciousActorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getOsList() {
		return osListEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getPhysicalLinkLayer() {
		return physicalLinkLayerEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getTransportLayer() {
		return transportLayerEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getNetworkLayer() {
		return networkLayerEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getApplicationLayer() {
		return applicationLayerEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getIdList() {
		return idListEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getLanguageList() {
		return languageListEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IotmodelFactory getIotmodelFactory() {
		return (IotmodelFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		gatewayEClass = createEClass(GATEWAY);

		edgeDeviceEClass = createEClass(EDGE_DEVICE);
		createEAttribute(edgeDeviceEClass, EDGE_DEVICE__ROUTER);

		appChannelEClass = createEClass(APP_CHANNEL);
		createEReference(appChannelEClass, APP_CHANNEL__BIND_TO);

		networkEClass = createEClass(NETWORK);
		createEAttribute(networkEClass, NETWORK__NAME);
		createEAttribute(networkEClass, NETWORK__DOMAIN);
		createEReference(networkEClass, NETWORK__ENFORCE);
		createEReference(networkEClass, NETWORK__THING);
		createEReference(networkEClass, NETWORK__DATA);

		requestResponseEClass = createEClass(REQUEST_RESPONSE);
		createEReference(requestResponseEClass, REQUEST_RESPONSE__SERVER);

		publishSubscribeEClass = createEClass(PUBLISH_SUBSCRIBE);
		createEReference(publishSubscribeEClass, PUBLISH_SUBSCRIBE__PUBLISH_SUBSCRIBE);

		thingEClass = createEClass(THING);
		createEReference(thingEClass, THING__IOTOS);
		createEAttribute(thingEClass, THING__NAME);
		createEReference(thingEClass, THING__ID);
		createEReference(thingEClass, THING__BEHAVIOR);
		createEReference(thingEClass, THING__MESSAGE);
		createEReference(thingEClass, THING__CONTAINS_PORTS);
		createEReference(thingEClass, THING__PRODUCE);

		accessControlPolicyEClass = createEClass(ACCESS_CONTROL_POLICY);
		createEReference(accessControlPolicyEClass, ACCESS_CONTROL_POLICY__RULE);
		createEReference(accessControlPolicyEClass, ACCESS_CONTROL_POLICY__IS_ENFORCED);
		createEAttribute(accessControlPolicyEClass, ACCESS_CONTROL_POLICY__POLICY_NAME);

		protocolStackEClass = createEClass(PROTOCOL_STACK);
		createEAttribute(protocolStackEClass, PROTOCOL_STACK__PHYDATA);
		createEAttribute(protocolStackEClass, PROTOCOL_STACK__NWK);
		createEAttribute(protocolStackEClass, PROTOCOL_STACK__TRANSPORT);
		createEAttribute(protocolStackEClass, PROTOCOL_STACK__APPLICATION_PROTOCOL);
		createEAttribute(protocolStackEClass, PROTOCOL_STACK__NAME);

		ruleEClass = createEClass(RULE);
		createEReference(ruleEClass, RULE__THING);
		createEReference(ruleEClass, RULE__PERMISSION);
		createEReference(ruleEClass, RULE__CONSTRAINTEXPRESSION);
		createEAttribute(ruleEClass, RULE__NAME);

		ioTOsEClass = createEClass(IO_TOS);
		createEReference(ioTOsEClass, IO_TOS__IMPLEMENTS);
		createEAttribute(ioTOsEClass, IO_TOS__NAME);
		createEReference(ioTOsEClass, IO_TOS__THING);
		createEReference(ioTOsEClass, IO_TOS__PROGRAMMINGMODEL);

		ioTPlatformEClass = createEClass(IO_TPLATFORM);
		createEReference(ioTPlatformEClass, IO_TPLATFORM__USE_PROTOCOL);
		createEReference(ioTPlatformEClass, IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM);
		createEReference(ioTPlatformEClass, IO_TPLATFORM__COMMUNICATE_THROUGH);
		createEReference(ioTPlatformEClass, IO_TPLATFORM__USERAPPLICATION);
		createEReference(ioTPlatformEClass, IO_TPLATFORM__MESSAGEBROKER);
		createEReference(ioTPlatformEClass, IO_TPLATFORM__WEBSERVER);

		messageEClass = createEClass(MESSAGE);
		createEReference(messageEClass, MESSAGE__SEND_RECEIVE_MESSAGE);
		createEReference(messageEClass, MESSAGE__ENCAPSUALTE);

		messageFormatEClass = createEClass(MESSAGE_FORMAT);

		messageBrokerEClass = createEClass(MESSAGE_BROKER);
		createEReference(messageBrokerEClass, MESSAGE_BROKER__USED_BY);
		createEReference(messageBrokerEClass, MESSAGE_BROKER__TOPIC);
		createEReference(messageBrokerEClass, MESSAGE_BROKER__IOTPLATFORM);

		topicEClass = createEClass(TOPIC);

		userApplicationEClass = createEClass(USER_APPLICATION);
		createEReference(userApplicationEClass, USER_APPLICATION__IOTPLATFORM);

		desktopAppEClass = createEClass(DESKTOP_APP);

		mobileAppEClass = createEClass(MOBILE_APP);

		webServerEClass = createEClass(WEB_SERVER);
		createEReference(webServerEClass, WEB_SERVER__REQUESTRESPONSE);
		createEReference(webServerEClass, WEB_SERVER__IOTPLATFORM);

		defaultPolicyEClass = createEClass(DEFAULT_POLICY);

		privatePolicyEClass = createEClass(PRIVATE_POLICY);

		permissionEClass = createEClass(PERMISSION);
		createEReference(permissionEClass, PERMISSION__PERMIT_OR_DENY);

		constraintExpressionEClass = createEClass(CONSTRAINT_EXPRESSION);

		allowPermissionEClass = createEClass(ALLOW_PERMISSION);

		denyPermissionEClass = createEClass(DENY_PERMISSION);

		sensorEClass = createEClass(SENSOR);

		actuatorEClass = createEClass(ACTUATOR);

		ioTMetamodelEClass = createEClass(IO_TMETAMODEL);
		createEReference(ioTMetamodelEClass, IO_TMETAMODEL__IOTPLATFORM);
		createEReference(ioTMetamodelEClass, IO_TMETAMODEL__NETWORK);
		createEReference(ioTMetamodelEClass, IO_TMETAMODEL__ACCESSCONTROLPOLICY);
		createEReference(ioTMetamodelEClass, IO_TMETAMODEL__IOTOS);
		createEReference(ioTMetamodelEClass, IO_TMETAMODEL__PROTOCOLSTACK);
		createEReference(ioTMetamodelEClass, IO_TMETAMODEL__CHANNEL);

		idEClass = createEClass(ID);
		createEAttribute(idEClass, ID__ID);
		createEAttribute(idEClass, ID__NEW_ATTRIBUTE);

		behaviorEClass = createEClass(BEHAVIOR);
		createEReference(behaviorEClass, BEHAVIOR__MAKE_ACTION);
		createEReference(behaviorEClass, BEHAVIOR__EVENT);

		actionEClass = createEClass(ACTION);
		createEReference(actionEClass, ACTION__PERMISSION);
		createEReference(actionEClass, ACTION__HAS_EVENT);

		eventEClass = createEClass(EVENT);
		createEReference(eventEClass, EVENT__TRIGGER_ACTION);

		programmingModelEClass = createEClass(PROGRAMMING_MODEL);
		createEAttribute(programmingModelEClass, PROGRAMMING_MODEL__LANGUAGE);

		sharedActionEClass = createEClass(SHARED_ACTION);

		appPortEClass = createEClass(APP_PORT);
		createEReference(appPortEClass, APP_PORT__IS_BOUND);

		dataEClass = createEClass(DATA);
		createEReference(dataEClass, DATA__IS_ENCAPSULATED);

		actorEClass = createEClass(ACTOR);
		createEReference(actorEClass, ACTOR__USES);
		createEAttribute(actorEClass, ACTOR__NAME);
		createEAttribute(actorEClass, ACTOR__INTENT);

		maliciousActorEClass = createEClass(MALICIOUS_ACTOR);

		// Create enums
		osListEEnum = createEEnum(OS_LIST);
		physicalLinkLayerEEnum = createEEnum(PHYSICAL_LINK_LAYER);
		transportLayerEEnum = createEEnum(TRANSPORT_LAYER);
		networkLayerEEnum = createEEnum(NETWORK_LAYER);
		applicationLayerEEnum = createEEnum(APPLICATION_LAYER);
		idListEEnum = createEEnum(ID_LIST);
		languageListEEnum = createEEnum(LANGUAGE_LIST);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		gatewayEClass.getESuperTypes().add(this.getThing());
		edgeDeviceEClass.getESuperTypes().add(this.getThing());
		requestResponseEClass.getESuperTypes().add(this.getAppChannel());
		publishSubscribeEClass.getESuperTypes().add(this.getAppChannel());
		messageFormatEClass.getESuperTypes().add(this.getMessage());
		desktopAppEClass.getESuperTypes().add(this.getUserApplication());
		mobileAppEClass.getESuperTypes().add(this.getUserApplication());
		defaultPolicyEClass.getESuperTypes().add(this.getAccessControlPolicy());
		privatePolicyEClass.getESuperTypes().add(this.getAccessControlPolicy());
		allowPermissionEClass.getESuperTypes().add(this.getPermission());
		denyPermissionEClass.getESuperTypes().add(this.getPermission());
		sensorEClass.getESuperTypes().add(this.getEdgeDevice());
		actuatorEClass.getESuperTypes().add(this.getEdgeDevice());
		sharedActionEClass.getESuperTypes().add(this.getAction());
		maliciousActorEClass.getESuperTypes().add(this.getActor());

		// Initialize classes, features, and operations; add parameters
		initEClass(gatewayEClass, Gateway.class, "Gateway", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(edgeDeviceEClass, EdgeDevice.class, "EdgeDevice", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getEdgeDevice_Router(), theEcorePackage.getEBoolean(), "router", null, 1, 1, EdgeDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(appChannelEClass, AppChannel.class, "AppChannel", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAppChannel_BindTo(), this.getAppPort(), this.getAppPort_IsBound(), "bindTo", null, 0, -1, AppChannel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(networkEClass, Network.class, "Network", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNetwork_Name(), theEcorePackage.getEString(), "name", null, 0, 1, Network.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getNetwork_Domain(), theEcorePackage.getEString(), "domain", null, 0, 1, Network.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNetwork_Enforce(), this.getAccessControlPolicy(), this.getAccessControlPolicy_IsEnforced(), "enforce", null, 0, -1, Network.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNetwork_Thing(), this.getThing(), null, "thing", null, 0, -1, Network.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getNetwork_Data(), this.getData(), null, "data", null, 0, -1, Network.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(requestResponseEClass, RequestResponse.class, "RequestResponse", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRequestResponse_Server(), this.getWebServer(), this.getWebServer_Requestresponse(), "server", null, 0, 1, RequestResponse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(publishSubscribeEClass, PublishSubscribe.class, "PublishSubscribe", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPublishSubscribe_PublishSubscribe(), this.getMessageBroker(), this.getMessageBroker_UsedBy(), "publishSubscribe", null, 0, 1, PublishSubscribe.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(thingEClass, Thing.class, "Thing", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getThing_Iotos(), this.getIoTOs(), this.getIoTOs_Thing(), "iotos", null, 0, 1, Thing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getThing_Name(), theEcorePackage.getEString(), "name", null, 0, 1, Thing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getThing_Id(), this.getID(), null, "id", null, 0, -1, Thing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getThing_Behavior(), this.getBehavior(), null, "behavior", null, 0, -1, Thing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getThing_Message(), this.getMessage(), null, "message", null, 0, -1, Thing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getThing_ContainsPorts(), this.getAppPort(), null, "containsPorts", null, 0, -1, Thing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getThing_Produce(), this.getData(), null, "produce", null, 0, 1, Thing.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(accessControlPolicyEClass, AccessControlPolicy.class, "AccessControlPolicy", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAccessControlPolicy_Rule(), this.getRule(), null, "rule", null, 0, -1, AccessControlPolicy.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAccessControlPolicy_IsEnforced(), this.getNetwork(), this.getNetwork_Enforce(), "isEnforced", null, 0, -1, AccessControlPolicy.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAccessControlPolicy_PolicyName(), theEcorePackage.getEString(), "policyName", null, 0, 1, AccessControlPolicy.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(protocolStackEClass, ProtocolStack.class, "ProtocolStack", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProtocolStack_PHYDATA(), this.getPhysicalLinkLayer(), "PHYDATA", null, 0, 1, ProtocolStack.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProtocolStack_NWK(), this.getNetworkLayer(), "NWK", null, 0, 1, ProtocolStack.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProtocolStack_Transport(), this.getTransportLayer(), "Transport", null, 0, 1, ProtocolStack.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProtocolStack_ApplicationProtocol(), this.getApplicationLayer(), "ApplicationProtocol", null, 0, 1, ProtocolStack.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProtocolStack_Name(), theEcorePackage.getEString(), "name", null, 0, 1, ProtocolStack.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ruleEClass, Rule.class, "Rule", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getRule_Thing(), this.getThing(), null, "thing", null, 0, -1, Rule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRule_Permission(), this.getPermission(), null, "permission", null, 0, -1, Rule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getRule_Constraintexpression(), this.getConstraintExpression(), null, "constraintexpression", null, 0, -1, Rule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRule_Name(), theEcorePackage.getEString(), "name", null, 0, 1, Rule.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ioTOsEClass, IoTOs.class, "IoTOs", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIoTOs_Implements(), this.getProtocolStack(), null, "implements", null, 0, -1, IoTOs.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getIoTOs_Name(), this.getOsList(), "name", null, 0, 1, IoTOs.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTOs_Thing(), this.getThing(), this.getThing_Iotos(), "thing", null, 0, -1, IoTOs.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTOs_Programmingmodel(), this.getProgrammingModel(), null, "programmingmodel", null, 0, -1, IoTOs.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ioTPlatformEClass, IoTPlatform.class, "IoTPlatform", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIoTPlatform_UseProtocol(), this.getProtocolStack(), null, "useProtocol", null, 0, 1, IoTPlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTPlatform_SentReceivedByPlatform(), this.getMessage(), this.getMessage_SendReceiveMessage(), "sentReceivedByPlatform", null, 0, 1, IoTPlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTPlatform_CommunicateThrough(), this.getAppChannel(), null, "communicateThrough", null, 0, 1, IoTPlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTPlatform_Userapplication(), this.getUserApplication(), this.getUserApplication_Iotplatform(), "userapplication", null, 0, -1, IoTPlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTPlatform_Messagebroker(), this.getMessageBroker(), this.getMessageBroker_Iotplatform(), "messagebroker", null, 0, 1, IoTPlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTPlatform_Webserver(), this.getWebServer(), this.getWebServer_Iotplatform(), "webserver", null, 0, 1, IoTPlatform.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(messageEClass, Message.class, "Message", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMessage_SendReceiveMessage(), this.getIoTPlatform(), this.getIoTPlatform_SentReceivedByPlatform(), "sendReceiveMessage", null, 0, 1, Message.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMessage_Encapsualte(), this.getData(), this.getData_IsEncapsulated(), "encapsualte", null, 0, 1, Message.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(messageFormatEClass, MessageFormat.class, "MessageFormat", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(messageBrokerEClass, MessageBroker.class, "MessageBroker", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getMessageBroker_UsedBy(), this.getPublishSubscribe(), this.getPublishSubscribe_PublishSubscribe(), "usedBy", null, 0, -1, MessageBroker.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMessageBroker_Topic(), this.getTopic(), null, "topic", null, 0, -1, MessageBroker.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getMessageBroker_Iotplatform(), this.getIoTPlatform(), this.getIoTPlatform_Messagebroker(), "iotplatform", null, 0, 1, MessageBroker.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(topicEClass, Topic.class, "Topic", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(userApplicationEClass, UserApplication.class, "UserApplication", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getUserApplication_Iotplatform(), this.getIoTPlatform(), this.getIoTPlatform_Userapplication(), "iotplatform", null, 0, -1, UserApplication.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(desktopAppEClass, DesktopApp.class, "DesktopApp", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(mobileAppEClass, MobileApp.class, "MobileApp", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(webServerEClass, WebServer.class, "WebServer", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getWebServer_Requestresponse(), this.getRequestResponse(), this.getRequestResponse_Server(), "requestresponse", null, 0, 1, WebServer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getWebServer_Iotplatform(), this.getIoTPlatform(), this.getIoTPlatform_Webserver(), "iotplatform", null, 0, 1, WebServer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(defaultPolicyEClass, DefaultPolicy.class, "DefaultPolicy", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(privatePolicyEClass, PrivatePolicy.class, "PrivatePolicy", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(permissionEClass, Permission.class, "Permission", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPermission_PermitOrDeny(), this.getAction(), this.getAction_Permission(), "permitOrDeny", null, 0, 1, Permission.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(constraintExpressionEClass, ConstraintExpression.class, "ConstraintExpression", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(allowPermissionEClass, AllowPermission.class, "AllowPermission", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(denyPermissionEClass, DenyPermission.class, "DenyPermission", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(sensorEClass, Sensor.class, "Sensor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(actuatorEClass, Actuator.class, "Actuator", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(ioTMetamodelEClass, IoTMetamodel.class, "IoTMetamodel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getIoTMetamodel_Iotplatform(), this.getIoTPlatform(), null, "iotplatform", null, 0, -1, IoTMetamodel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTMetamodel_Network(), this.getNetwork(), null, "network", null, 0, -1, IoTMetamodel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTMetamodel_Accesscontrolpolicy(), this.getAccessControlPolicy(), null, "accesscontrolpolicy", null, 0, -1, IoTMetamodel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTMetamodel_Iotos(), this.getIoTOs(), null, "iotos", null, 0, -1, IoTMetamodel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTMetamodel_Protocolstack(), this.getProtocolStack(), null, "protocolstack", null, 0, -1, IoTMetamodel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getIoTMetamodel_Channel(), this.getAppChannel(), null, "channel", null, 0, -1, IoTMetamodel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(idEClass, iotmodel.ID.class, "ID", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getID_ID(), theEcorePackage.getEString(), "ID", null, 0, 1, iotmodel.ID.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getID_NewAttribute(), theEcorePackage.getEString(), "newAttribute", null, 0, 1, iotmodel.ID.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(behaviorEClass, Behavior.class, "Behavior", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getBehavior_MakeAction(), this.getAction(), null, "makeAction", null, 0, -1, Behavior.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getBehavior_Event(), this.getEvent(), null, "event", null, 0, -1, Behavior.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(actionEClass, Action.class, "Action", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAction_Permission(), this.getPermission(), this.getPermission_PermitOrDeny(), "permission", null, 0, 1, Action.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAction_HasEvent(), this.getEvent(), this.getEvent_TriggerAction(), "hasEvent", null, 0, 1, Action.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(eventEClass, Event.class, "Event", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getEvent_TriggerAction(), this.getAction(), this.getAction_HasEvent(), "triggerAction", null, 0, 1, Event.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(programmingModelEClass, ProgrammingModel.class, "ProgrammingModel", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProgrammingModel_Language(), this.getLanguageList(), "language", null, 0, 1, ProgrammingModel.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(sharedActionEClass, SharedAction.class, "SharedAction", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(appPortEClass, AppPort.class, "AppPort", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAppPort_IsBound(), this.getAppChannel(), this.getAppChannel_BindTo(), "isBound", null, 0, -1, AppPort.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(dataEClass, Data.class, "Data", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getData_IsEncapsulated(), this.getMessage(), this.getMessage_Encapsualte(), "isEncapsulated", null, 0, 1, Data.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(actorEClass, Actor.class, "Actor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getActor_Uses(), this.getThing(), null, "uses", null, 0, 1, Actor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getActor_Name(), theEcorePackage.getEString(), "name", null, 0, 1, Actor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getActor_Intent(), theEcorePackage.getEString(), "intent", null, 0, 1, Actor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(maliciousActorEClass, MaliciousActor.class, "MaliciousActor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Initialize enums and add enum literals
		initEEnum(osListEEnum, OsList.class, "OsList");
		addEEnumLiteral(osListEEnum, OsList.CONTIKI);
		addEEnumLiteral(osListEEnum, OsList.TINY_OS);
		addEEnumLiteral(osListEEnum, OsList.RIOT);
		addEEnumLiteral(osListEEnum, OsList.RASPBERRY_PI);
		addEEnumLiteral(osListEEnum, OsList.FREE_RTOS);
		addEEnumLiteral(osListEEnum, OsList.LITE_OS);
		addEEnumLiteral(osListEEnum, OsList.MANTIS);
		addEEnumLiteral(osListEEnum, OsList.ARDUINO);

		initEEnum(physicalLinkLayerEEnum, PhysicalLinkLayer.class, "PhysicalLinkLayer");
		addEEnumLiteral(physicalLinkLayerEEnum, PhysicalLinkLayer.IEEE_805_15_4);
		addEEnumLiteral(physicalLinkLayerEEnum, PhysicalLinkLayer.ETHERNET);
		addEEnumLiteral(physicalLinkLayerEEnum, PhysicalLinkLayer.WIRELESS_LAN);
		addEEnumLiteral(physicalLinkLayerEEnum, PhysicalLinkLayer.SMS_PHYSICAL);
		addEEnumLiteral(physicalLinkLayerEEnum, PhysicalLinkLayer.BLUETOOTH);

		initEEnum(transportLayerEEnum, TransportLayer.class, "TransportLayer");
		addEEnumLiteral(transportLayerEEnum, TransportLayer.TCP);
		addEEnumLiteral(transportLayerEEnum, TransportLayer.UDP);
		addEEnumLiteral(transportLayerEEnum, TransportLayer.ZIGBEE);
		addEEnumLiteral(transportLayerEEnum, TransportLayer.DTLS);
		addEEnumLiteral(transportLayerEEnum, TransportLayer.SMS);

		initEEnum(networkLayerEEnum, NetworkLayer.class, "NetworkLayer");
		addEEnumLiteral(networkLayerEEnum, NetworkLayer.IPV6);
		addEEnumLiteral(networkLayerEEnum, NetworkLayer.IPV4);
		addEEnumLiteral(networkLayerEEnum, NetworkLayer.ZIGBEE);
		addEEnumLiteral(networkLayerEEnum, NetworkLayer.IPSEC);
		addEEnumLiteral(networkLayerEEnum, NetworkLayer.LOW_PAN_TO_IPV6);
		addEEnumLiteral(networkLayerEEnum, NetworkLayer.SMS_NETWORK);

		initEEnum(applicationLayerEEnum, ApplicationLayer.class, "ApplicationLayer");
		addEEnumLiteral(applicationLayerEEnum, ApplicationLayer.MQTT);
		addEEnumLiteral(applicationLayerEEnum, ApplicationLayer.HTTP);
		addEEnumLiteral(applicationLayerEEnum, ApplicationLayer.AMQP);
		addEEnumLiteral(applicationLayerEEnum, ApplicationLayer.CO_AP);
		addEEnumLiteral(applicationLayerEEnum, ApplicationLayer.WEBSOCKET);
		addEEnumLiteral(applicationLayerEEnum, ApplicationLayer.ZIGBEE);

		initEEnum(idListEEnum, IdList.class, "IdList");
		addEEnumLiteral(idListEEnum, IdList.EPC);
		addEEnumLiteral(idListEEnum, IdList.UCODE);
		addEEnumLiteral(idListEEnum, IdList.ID_AT_URI);
		addEEnumLiteral(idListEEnum, IdList.IMEI);
		addEEnumLiteral(idListEEnum, IdList.OID);
		addEEnumLiteral(idListEEnum, IdList.URI);
		addEEnumLiteral(idListEEnum, IdList.DOI);
		addEEnumLiteral(idListEEnum, IdList.ISBN);
		addEEnumLiteral(idListEEnum, IdList.IP_ADRESS);

		initEEnum(languageListEEnum, LanguageList.class, "LanguageList");
		addEEnumLiteral(languageListEEnum, LanguageList.CPOSIX);
		addEEnumLiteral(languageListEEnum, LanguageList.NES_C);
		addEEnumLiteral(languageListEEnum, LanguageList.CPLUS_PLUS);
		addEEnumLiteral(languageListEEnum, LanguageList.JAVA);
		addEEnumLiteral(languageListEEnum, LanguageList.JAVASCRIPT);
		addEEnumLiteral(languageListEEnum, LanguageList.GO);
		addEEnumLiteral(languageListEEnum, LanguageList.PYTHON);
		addEEnumLiteral(languageListEEnum, LanguageList.ASSEMBLER);
		addEEnumLiteral(languageListEEnum, LanguageList.NODEJS);
		addEEnumLiteral(languageListEEnum, LanguageList.CARDUINO);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/Ecore
		createEcoreAnnotations();
		// http://www.eclipse.org/emf/2011/Xcore
		createXcoreAnnotations();
		// http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot
		createPivotAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/Ecore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createEcoreAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/Ecore";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "invocationDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot",
			   "settingDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot",
			   "validationDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot"
		   });
		addAnnotation
		  (protocolStackEClass,
		   source,
		   new String[] {
			   "constraints", "CheckNameSize"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2011/Xcore</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createXcoreAnnotations() {
		String source = "http://www.eclipse.org/emf/2011/Xcore";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "Pivot", "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createPivotAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot";
		addAnnotation
		  (protocolStackEClass,
		   source,
		   new String[] {
			   "CheckNameSize", "self.name.size()>=5"
		   });
	}

} //IotmodelPackageImpl
