/**
 */
package iotmodel.impl;

import iotmodel.ApplicationLayer;
import iotmodel.IotmodelPackage;
import iotmodel.NetworkLayer;
import iotmodel.PhysicalLinkLayer;
import iotmodel.ProtocolStack;
import iotmodel.TransportLayer;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Protocol Stack</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.impl.ProtocolStackImpl#getPHYDATA <em>PHYDATA</em>}</li>
 *   <li>{@link iotmodel.impl.ProtocolStackImpl#getNWK <em>NWK</em>}</li>
 *   <li>{@link iotmodel.impl.ProtocolStackImpl#getTransport <em>Transport</em>}</li>
 *   <li>{@link iotmodel.impl.ProtocolStackImpl#getApplicationProtocol <em>Application Protocol</em>}</li>
 *   <li>{@link iotmodel.impl.ProtocolStackImpl#getName <em>Name</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProtocolStackImpl extends MinimalEObjectImpl.Container implements ProtocolStack {
	/**
	 * The default value of the '{@link #getPHYDATA() <em>PHYDATA</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPHYDATA()
	 * @generated
	 * @ordered
	 */
	protected static final PhysicalLinkLayer PHYDATA_EDEFAULT = PhysicalLinkLayer.IEEE_805_15_4;

	/**
	 * The cached value of the '{@link #getPHYDATA() <em>PHYDATA</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPHYDATA()
	 * @generated
	 * @ordered
	 */
	protected PhysicalLinkLayer phydata = PHYDATA_EDEFAULT;

	/**
	 * The default value of the '{@link #getNWK() <em>NWK</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNWK()
	 * @generated
	 * @ordered
	 */
	protected static final NetworkLayer NWK_EDEFAULT = NetworkLayer.IPV6;

	/**
	 * The cached value of the '{@link #getNWK() <em>NWK</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNWK()
	 * @generated
	 * @ordered
	 */
	protected NetworkLayer nwk = NWK_EDEFAULT;

	/**
	 * The default value of the '{@link #getTransport() <em>Transport</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransport()
	 * @generated
	 * @ordered
	 */
	protected static final TransportLayer TRANSPORT_EDEFAULT = TransportLayer.TCP;

	/**
	 * The cached value of the '{@link #getTransport() <em>Transport</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransport()
	 * @generated
	 * @ordered
	 */
	protected TransportLayer transport = TRANSPORT_EDEFAULT;

	/**
	 * The default value of the '{@link #getApplicationProtocol() <em>Application Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getApplicationProtocol()
	 * @generated
	 * @ordered
	 */
	protected static final ApplicationLayer APPLICATION_PROTOCOL_EDEFAULT = ApplicationLayer.MQTT;

	/**
	 * The cached value of the '{@link #getApplicationProtocol() <em>Application Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getApplicationProtocol()
	 * @generated
	 * @ordered
	 */
	protected ApplicationLayer applicationProtocol = APPLICATION_PROTOCOL_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProtocolStackImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IotmodelPackage.Literals.PROTOCOL_STACK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PhysicalLinkLayer getPHYDATA() {
		return phydata;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPHYDATA(PhysicalLinkLayer newPHYDATA) {
		PhysicalLinkLayer oldPHYDATA = phydata;
		phydata = newPHYDATA == null ? PHYDATA_EDEFAULT : newPHYDATA;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.PROTOCOL_STACK__PHYDATA, oldPHYDATA, phydata));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NetworkLayer getNWK() {
		return nwk;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNWK(NetworkLayer newNWK) {
		NetworkLayer oldNWK = nwk;
		nwk = newNWK == null ? NWK_EDEFAULT : newNWK;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.PROTOCOL_STACK__NWK, oldNWK, nwk));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TransportLayer getTransport() {
		return transport;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTransport(TransportLayer newTransport) {
		TransportLayer oldTransport = transport;
		transport = newTransport == null ? TRANSPORT_EDEFAULT : newTransport;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.PROTOCOL_STACK__TRANSPORT, oldTransport, transport));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ApplicationLayer getApplicationProtocol() {
		return applicationProtocol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setApplicationProtocol(ApplicationLayer newApplicationProtocol) {
		ApplicationLayer oldApplicationProtocol = applicationProtocol;
		applicationProtocol = newApplicationProtocol == null ? APPLICATION_PROTOCOL_EDEFAULT : newApplicationProtocol;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.PROTOCOL_STACK__APPLICATION_PROTOCOL, oldApplicationProtocol, applicationProtocol));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.PROTOCOL_STACK__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IotmodelPackage.PROTOCOL_STACK__PHYDATA:
				return getPHYDATA();
			case IotmodelPackage.PROTOCOL_STACK__NWK:
				return getNWK();
			case IotmodelPackage.PROTOCOL_STACK__TRANSPORT:
				return getTransport();
			case IotmodelPackage.PROTOCOL_STACK__APPLICATION_PROTOCOL:
				return getApplicationProtocol();
			case IotmodelPackage.PROTOCOL_STACK__NAME:
				return getName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IotmodelPackage.PROTOCOL_STACK__PHYDATA:
				setPHYDATA((PhysicalLinkLayer)newValue);
				return;
			case IotmodelPackage.PROTOCOL_STACK__NWK:
				setNWK((NetworkLayer)newValue);
				return;
			case IotmodelPackage.PROTOCOL_STACK__TRANSPORT:
				setTransport((TransportLayer)newValue);
				return;
			case IotmodelPackage.PROTOCOL_STACK__APPLICATION_PROTOCOL:
				setApplicationProtocol((ApplicationLayer)newValue);
				return;
			case IotmodelPackage.PROTOCOL_STACK__NAME:
				setName((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IotmodelPackage.PROTOCOL_STACK__PHYDATA:
				setPHYDATA(PHYDATA_EDEFAULT);
				return;
			case IotmodelPackage.PROTOCOL_STACK__NWK:
				setNWK(NWK_EDEFAULT);
				return;
			case IotmodelPackage.PROTOCOL_STACK__TRANSPORT:
				setTransport(TRANSPORT_EDEFAULT);
				return;
			case IotmodelPackage.PROTOCOL_STACK__APPLICATION_PROTOCOL:
				setApplicationProtocol(APPLICATION_PROTOCOL_EDEFAULT);
				return;
			case IotmodelPackage.PROTOCOL_STACK__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IotmodelPackage.PROTOCOL_STACK__PHYDATA:
				return phydata != PHYDATA_EDEFAULT;
			case IotmodelPackage.PROTOCOL_STACK__NWK:
				return nwk != NWK_EDEFAULT;
			case IotmodelPackage.PROTOCOL_STACK__TRANSPORT:
				return transport != TRANSPORT_EDEFAULT;
			case IotmodelPackage.PROTOCOL_STACK__APPLICATION_PROTOCOL:
				return applicationProtocol != APPLICATION_PROTOCOL_EDEFAULT;
			case IotmodelPackage.PROTOCOL_STACK__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (PHYDATA: ");
		result.append(phydata);
		result.append(", NWK: ");
		result.append(nwk);
		result.append(", Transport: ");
		result.append(transport);
		result.append(", ApplicationProtocol: ");
		result.append(applicationProtocol);
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //ProtocolStackImpl
