/**
 */
package iotmodel.util;

import iotmodel.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see iotmodel.IotmodelPackage
 * @generated
 */
public class IotmodelAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static IotmodelPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IotmodelAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = IotmodelPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IotmodelSwitch<Adapter> modelSwitch =
		new IotmodelSwitch<Adapter>() {
			@Override
			public Adapter caseGateway(Gateway object) {
				return createGatewayAdapter();
			}
			@Override
			public Adapter caseEdgeDevice(EdgeDevice object) {
				return createEdgeDeviceAdapter();
			}
			@Override
			public Adapter caseAppChannel(AppChannel object) {
				return createAppChannelAdapter();
			}
			@Override
			public Adapter caseNetwork(Network object) {
				return createNetworkAdapter();
			}
			@Override
			public Adapter caseRequestResponse(RequestResponse object) {
				return createRequestResponseAdapter();
			}
			@Override
			public Adapter casePublishSubscribe(PublishSubscribe object) {
				return createPublishSubscribeAdapter();
			}
			@Override
			public Adapter caseThing(Thing object) {
				return createThingAdapter();
			}
			@Override
			public Adapter caseAccessControlPolicy(AccessControlPolicy object) {
				return createAccessControlPolicyAdapter();
			}
			@Override
			public Adapter caseProtocolStack(ProtocolStack object) {
				return createProtocolStackAdapter();
			}
			@Override
			public Adapter caseRule(Rule object) {
				return createRuleAdapter();
			}
			@Override
			public Adapter caseIoTOs(IoTOs object) {
				return createIoTOsAdapter();
			}
			@Override
			public Adapter caseIoTPlatform(IoTPlatform object) {
				return createIoTPlatformAdapter();
			}
			@Override
			public Adapter caseMessage(Message object) {
				return createMessageAdapter();
			}
			@Override
			public Adapter caseMessageFormat(MessageFormat object) {
				return createMessageFormatAdapter();
			}
			@Override
			public Adapter caseMessageBroker(MessageBroker object) {
				return createMessageBrokerAdapter();
			}
			@Override
			public Adapter caseTopic(Topic object) {
				return createTopicAdapter();
			}
			@Override
			public Adapter caseUserApplication(UserApplication object) {
				return createUserApplicationAdapter();
			}
			@Override
			public Adapter caseDesktopApp(DesktopApp object) {
				return createDesktopAppAdapter();
			}
			@Override
			public Adapter caseMobileApp(MobileApp object) {
				return createMobileAppAdapter();
			}
			@Override
			public Adapter caseWebServer(WebServer object) {
				return createWebServerAdapter();
			}
			@Override
			public Adapter caseDefaultPolicy(DefaultPolicy object) {
				return createDefaultPolicyAdapter();
			}
			@Override
			public Adapter casePrivatePolicy(PrivatePolicy object) {
				return createPrivatePolicyAdapter();
			}
			@Override
			public Adapter casePermission(Permission object) {
				return createPermissionAdapter();
			}
			@Override
			public Adapter caseConstraintExpression(ConstraintExpression object) {
				return createConstraintExpressionAdapter();
			}
			@Override
			public Adapter caseAllowPermission(AllowPermission object) {
				return createAllowPermissionAdapter();
			}
			@Override
			public Adapter caseDenyPermission(DenyPermission object) {
				return createDenyPermissionAdapter();
			}
			@Override
			public Adapter caseSensor(Sensor object) {
				return createSensorAdapter();
			}
			@Override
			public Adapter caseActuator(Actuator object) {
				return createActuatorAdapter();
			}
			@Override
			public Adapter caseIoTMetamodel(IoTMetamodel object) {
				return createIoTMetamodelAdapter();
			}
			@Override
			public Adapter caseID(ID object) {
				return createIDAdapter();
			}
			@Override
			public Adapter caseBehavior(Behavior object) {
				return createBehaviorAdapter();
			}
			@Override
			public Adapter caseAction(Action object) {
				return createActionAdapter();
			}
			@Override
			public Adapter caseEvent(Event object) {
				return createEventAdapter();
			}
			@Override
			public Adapter caseProgrammingModel(ProgrammingModel object) {
				return createProgrammingModelAdapter();
			}
			@Override
			public Adapter caseSharedAction(SharedAction object) {
				return createSharedActionAdapter();
			}
			@Override
			public Adapter caseAppPort(AppPort object) {
				return createAppPortAdapter();
			}
			@Override
			public Adapter caseData(Data object) {
				return createDataAdapter();
			}
			@Override
			public Adapter caseActor(Actor object) {
				return createActorAdapter();
			}
			@Override
			public Adapter caseMaliciousActor(MaliciousActor object) {
				return createMaliciousActorAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Gateway <em>Gateway</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Gateway
	 * @generated
	 */
	public Adapter createGatewayAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.EdgeDevice <em>Edge Device</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.EdgeDevice
	 * @generated
	 */
	public Adapter createEdgeDeviceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.AppChannel <em>App Channel</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.AppChannel
	 * @generated
	 */
	public Adapter createAppChannelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Network <em>Network</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Network
	 * @generated
	 */
	public Adapter createNetworkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.RequestResponse <em>Request Response</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.RequestResponse
	 * @generated
	 */
	public Adapter createRequestResponseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.PublishSubscribe <em>Publish Subscribe</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.PublishSubscribe
	 * @generated
	 */
	public Adapter createPublishSubscribeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Thing <em>Thing</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Thing
	 * @generated
	 */
	public Adapter createThingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.AccessControlPolicy <em>Access Control Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.AccessControlPolicy
	 * @generated
	 */
	public Adapter createAccessControlPolicyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.ProtocolStack <em>Protocol Stack</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.ProtocolStack
	 * @generated
	 */
	public Adapter createProtocolStackAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Rule <em>Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Rule
	 * @generated
	 */
	public Adapter createRuleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.IoTOs <em>Io TOs</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.IoTOs
	 * @generated
	 */
	public Adapter createIoTOsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.IoTPlatform <em>Io TPlatform</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.IoTPlatform
	 * @generated
	 */
	public Adapter createIoTPlatformAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Message <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Message
	 * @generated
	 */
	public Adapter createMessageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.MessageFormat <em>Message Format</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.MessageFormat
	 * @generated
	 */
	public Adapter createMessageFormatAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.MessageBroker <em>Message Broker</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.MessageBroker
	 * @generated
	 */
	public Adapter createMessageBrokerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Topic <em>Topic</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Topic
	 * @generated
	 */
	public Adapter createTopicAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.UserApplication <em>User Application</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.UserApplication
	 * @generated
	 */
	public Adapter createUserApplicationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.DesktopApp <em>Desktop App</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.DesktopApp
	 * @generated
	 */
	public Adapter createDesktopAppAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.MobileApp <em>Mobile App</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.MobileApp
	 * @generated
	 */
	public Adapter createMobileAppAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.WebServer <em>Web Server</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.WebServer
	 * @generated
	 */
	public Adapter createWebServerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.DefaultPolicy <em>Default Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.DefaultPolicy
	 * @generated
	 */
	public Adapter createDefaultPolicyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.PrivatePolicy <em>Private Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.PrivatePolicy
	 * @generated
	 */
	public Adapter createPrivatePolicyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Permission <em>Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Permission
	 * @generated
	 */
	public Adapter createPermissionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.ConstraintExpression <em>Constraint Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.ConstraintExpression
	 * @generated
	 */
	public Adapter createConstraintExpressionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.AllowPermission <em>Allow Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.AllowPermission
	 * @generated
	 */
	public Adapter createAllowPermissionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.DenyPermission <em>Deny Permission</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.DenyPermission
	 * @generated
	 */
	public Adapter createDenyPermissionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Sensor <em>Sensor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Sensor
	 * @generated
	 */
	public Adapter createSensorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Actuator <em>Actuator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Actuator
	 * @generated
	 */
	public Adapter createActuatorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.IoTMetamodel <em>Io TMetamodel</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.IoTMetamodel
	 * @generated
	 */
	public Adapter createIoTMetamodelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.ID <em>ID</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.ID
	 * @generated
	 */
	public Adapter createIDAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Behavior <em>Behavior</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Behavior
	 * @generated
	 */
	public Adapter createBehaviorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Action <em>Action</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Action
	 * @generated
	 */
	public Adapter createActionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Event <em>Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Event
	 * @generated
	 */
	public Adapter createEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.ProgrammingModel <em>Programming Model</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.ProgrammingModel
	 * @generated
	 */
	public Adapter createProgrammingModelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.SharedAction <em>Shared Action</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.SharedAction
	 * @generated
	 */
	public Adapter createSharedActionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.AppPort <em>App Port</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.AppPort
	 * @generated
	 */
	public Adapter createAppPortAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Data <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Data
	 * @generated
	 */
	public Adapter createDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.Actor <em>Actor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.Actor
	 * @generated
	 */
	public Adapter createActorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link iotmodel.MaliciousActor <em>Malicious Actor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see iotmodel.MaliciousActor
	 * @generated
	 */
	public Adapter createMaliciousActorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //IotmodelAdapterFactory
