/*
 * Decompiled with CFR 0.152.
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PhysicalLinkLayer implements Enumerator
{
    IEEE_805_15_4(0, "IEEE_805_15_4", "IEEE_805_15_4"),
    ETHERNET(1, "Ethernet", "Ethernet"),
    WIRELESS_LAN(2, "WirelessLAN", "WirelessLAN"),
    SMS_PHYSICAL(3, "SMS_Physical", "SMS_Physical"),
    BLUETOOTH(4, "Bluetooth", "Bluetooth");

    public static final int IEEE_805_15_4_VALUE = 0;
    public static final int ETHERNET_VALUE = 1;
    public static final int WIRELESS_LAN_VALUE = 2;
    public static final int SMS_PHYSICAL_VALUE = 3;
    public static final int BLUETOOTH_VALUE = 4;
    private static final PhysicalLinkLayer[] VALUES_ARRAY;
    public static final List<PhysicalLinkLayer> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static PhysicalLinkLayer get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PhysicalLinkLayer result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static PhysicalLinkLayer getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            PhysicalLinkLayer result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static PhysicalLinkLayer get(int value) {
        switch (value) {
            case 0: {
                return IEEE_805_15_4;
            }
            case 1: {
                return ETHERNET;
            }
            case 2: {
                return WIRELESS_LAN;
            }
            case 3: {
                return SMS_PHYSICAL;
            }
            case 4: {
                return BLUETOOTH;
            }
        }
        return null;
    }

    private PhysicalLinkLayer(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new PhysicalLinkLayer[]{IEEE_805_15_4, ETHERNET, WIRELESS_LAN, SMS_PHYSICAL, BLUETOOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

