/**
 */
package iotmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Physical Link Layer</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see iotmodel.IotmodelPackage#getPhysicalLinkLayer()
 * @model
 * @generated
 */
public enum PhysicalLinkLayer implements Enumerator {
	/**
	 * The '<em><b>IEEE 805 15 4</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IEEE_805_15_4_VALUE
	 * @generated
	 * @ordered
	 */
	IEEE_805_15_4(0, "IEEE_805_15_4", "IEEE_805_15_4"),

	/**
	 * The '<em><b>Ethernet</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ETHERNET_VALUE
	 * @generated
	 * @ordered
	 */
	ETHERNET(1, "Ethernet", "Ethernet"),

	/**
	 * The '<em><b>Wireless LAN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WIRELESS_LAN_VALUE
	 * @generated
	 * @ordered
	 */
	WIRELESS_LAN(2, "WirelessLAN", "WirelessLAN"),

	/**
	 * The '<em><b>SMS Physical</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SMS_PHYSICAL_VALUE
	 * @generated
	 * @ordered
	 */
	SMS_PHYSICAL(3, "SMS_Physical", "SMS_Physical"),

	/**
	 * The '<em><b>Bluetooth</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BLUETOOTH_VALUE
	 * @generated
	 * @ordered
	 */
	BLUETOOTH(4, "Bluetooth", "Bluetooth");

	/**
	 * The '<em><b>IEEE 805 15 4</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IEEE_805_15_4
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int IEEE_805_15_4_VALUE = 0;

	/**
	 * The '<em><b>Ethernet</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ETHERNET
	 * @model name="Ethernet"
	 * @generated
	 * @ordered
	 */
	public static final int ETHERNET_VALUE = 1;

	/**
	 * The '<em><b>Wireless LAN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WIRELESS_LAN
	 * @model name="WirelessLAN"
	 * @generated
	 * @ordered
	 */
	public static final int WIRELESS_LAN_VALUE = 2;

	/**
	 * The '<em><b>SMS Physical</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SMS_PHYSICAL
	 * @model name="SMS_Physical"
	 * @generated
	 * @ordered
	 */
	public static final int SMS_PHYSICAL_VALUE = 3;

	/**
	 * The '<em><b>Bluetooth</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BLUETOOTH
	 * @model name="Bluetooth"
	 * @generated
	 * @ordered
	 */
	public static final int BLUETOOTH_VALUE = 4;

	/**
	 * An array of all the '<em><b>Physical Link Layer</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final PhysicalLinkLayer[] VALUES_ARRAY =
		new PhysicalLinkLayer[] {
			IEEE_805_15_4,
			ETHERNET,
			WIRELESS_LAN,
			SMS_PHYSICAL,
			BLUETOOTH,
		};

	/**
	 * A public read-only list of all the '<em><b>Physical Link Layer</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<PhysicalLinkLayer> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Physical Link Layer</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PhysicalLinkLayer get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PhysicalLinkLayer result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Physical Link Layer</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PhysicalLinkLayer getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PhysicalLinkLayer result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Physical Link Layer</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static PhysicalLinkLayer get(int value) {
		switch (value) {
			case IEEE_805_15_4_VALUE: return IEEE_805_15_4;
			case ETHERNET_VALUE: return ETHERNET;
			case WIRELESS_LAN_VALUE: return WIRELESS_LAN;
			case SMS_PHYSICAL_VALUE: return SMS_PHYSICAL;
			case BLUETOOTH_VALUE: return BLUETOOTH;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private PhysicalLinkLayer(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //PhysicalLinkLayer
