/**
 */
package iotmodel.impl;

import iotmodel.AppChannel;
import iotmodel.IoTPlatform;
import iotmodel.IotmodelPackage;
import iotmodel.Message;
import iotmodel.MessageBroker;
import iotmodel.ProtocolStack;
import iotmodel.UserApplication;
import iotmodel.WebServer;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Io TPlatform</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.impl.IoTPlatformImpl#getUseProtocol <em>Use Protocol</em>}</li>
 *   <li>{@link iotmodel.impl.IoTPlatformImpl#getSentReceivedByPlatform <em>Sent Received By Platform</em>}</li>
 *   <li>{@link iotmodel.impl.IoTPlatformImpl#getCommunicateThrough <em>Communicate Through</em>}</li>
 *   <li>{@link iotmodel.impl.IoTPlatformImpl#getUserapplication <em>Userapplication</em>}</li>
 *   <li>{@link iotmodel.impl.IoTPlatformImpl#getMessagebroker <em>Messagebroker</em>}</li>
 *   <li>{@link iotmodel.impl.IoTPlatformImpl#getWebserver <em>Webserver</em>}</li>
 * </ul>
 *
 * @generated
 */
public class IoTPlatformImpl extends MinimalEObjectImpl.Container implements IoTPlatform {
	/**
	 * The cached value of the '{@link #getUseProtocol() <em>Use Protocol</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUseProtocol()
	 * @generated
	 * @ordered
	 */
	protected ProtocolStack useProtocol;

	/**
	 * The cached value of the '{@link #getSentReceivedByPlatform() <em>Sent Received By Platform</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSentReceivedByPlatform()
	 * @generated
	 * @ordered
	 */
	protected Message sentReceivedByPlatform;

	/**
	 * The cached value of the '{@link #getCommunicateThrough() <em>Communicate Through</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommunicateThrough()
	 * @generated
	 * @ordered
	 */
	protected AppChannel communicateThrough;

	/**
	 * The cached value of the '{@link #getUserapplication() <em>Userapplication</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserapplication()
	 * @generated
	 * @ordered
	 */
	protected EList<UserApplication> userapplication;

	/**
	 * The cached value of the '{@link #getMessagebroker() <em>Messagebroker</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessagebroker()
	 * @generated
	 * @ordered
	 */
	protected MessageBroker messagebroker;

	/**
	 * The cached value of the '{@link #getWebserver() <em>Webserver</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWebserver()
	 * @generated
	 * @ordered
	 */
	protected WebServer webserver;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IoTPlatformImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IotmodelPackage.Literals.IO_TPLATFORM;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProtocolStack getUseProtocol() {
		if (useProtocol != null && useProtocol.eIsProxy()) {
			InternalEObject oldUseProtocol = (InternalEObject)useProtocol;
			useProtocol = (ProtocolStack)eResolveProxy(oldUseProtocol);
			if (useProtocol != oldUseProtocol) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IotmodelPackage.IO_TPLATFORM__USE_PROTOCOL, oldUseProtocol, useProtocol));
			}
		}
		return useProtocol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProtocolStack basicGetUseProtocol() {
		return useProtocol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUseProtocol(ProtocolStack newUseProtocol) {
		ProtocolStack oldUseProtocol = useProtocol;
		useProtocol = newUseProtocol;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.IO_TPLATFORM__USE_PROTOCOL, oldUseProtocol, useProtocol));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Message getSentReceivedByPlatform() {
		if (sentReceivedByPlatform != null && sentReceivedByPlatform.eIsProxy()) {
			InternalEObject oldSentReceivedByPlatform = (InternalEObject)sentReceivedByPlatform;
			sentReceivedByPlatform = (Message)eResolveProxy(oldSentReceivedByPlatform);
			if (sentReceivedByPlatform != oldSentReceivedByPlatform) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM, oldSentReceivedByPlatform, sentReceivedByPlatform));
			}
		}
		return sentReceivedByPlatform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Message basicGetSentReceivedByPlatform() {
		return sentReceivedByPlatform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSentReceivedByPlatform(Message newSentReceivedByPlatform, NotificationChain msgs) {
		Message oldSentReceivedByPlatform = sentReceivedByPlatform;
		sentReceivedByPlatform = newSentReceivedByPlatform;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM, oldSentReceivedByPlatform, newSentReceivedByPlatform);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSentReceivedByPlatform(Message newSentReceivedByPlatform) {
		if (newSentReceivedByPlatform != sentReceivedByPlatform) {
			NotificationChain msgs = null;
			if (sentReceivedByPlatform != null)
				msgs = ((InternalEObject)sentReceivedByPlatform).eInverseRemove(this, IotmodelPackage.MESSAGE__SEND_RECEIVE_MESSAGE, Message.class, msgs);
			if (newSentReceivedByPlatform != null)
				msgs = ((InternalEObject)newSentReceivedByPlatform).eInverseAdd(this, IotmodelPackage.MESSAGE__SEND_RECEIVE_MESSAGE, Message.class, msgs);
			msgs = basicSetSentReceivedByPlatform(newSentReceivedByPlatform, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM, newSentReceivedByPlatform, newSentReceivedByPlatform));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AppChannel getCommunicateThrough() {
		if (communicateThrough != null && communicateThrough.eIsProxy()) {
			InternalEObject oldCommunicateThrough = (InternalEObject)communicateThrough;
			communicateThrough = (AppChannel)eResolveProxy(oldCommunicateThrough);
			if (communicateThrough != oldCommunicateThrough) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IotmodelPackage.IO_TPLATFORM__COMMUNICATE_THROUGH, oldCommunicateThrough, communicateThrough));
			}
		}
		return communicateThrough;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AppChannel basicGetCommunicateThrough() {
		return communicateThrough;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCommunicateThrough(AppChannel newCommunicateThrough) {
		AppChannel oldCommunicateThrough = communicateThrough;
		communicateThrough = newCommunicateThrough;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.IO_TPLATFORM__COMMUNICATE_THROUGH, oldCommunicateThrough, communicateThrough));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<UserApplication> getUserapplication() {
		if (userapplication == null) {
			userapplication = new EObjectWithInverseResolvingEList.ManyInverse<UserApplication>(UserApplication.class, this, IotmodelPackage.IO_TPLATFORM__USERAPPLICATION, IotmodelPackage.USER_APPLICATION__IOTPLATFORM);
		}
		return userapplication;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessageBroker getMessagebroker() {
		if (messagebroker != null && messagebroker.eIsProxy()) {
			InternalEObject oldMessagebroker = (InternalEObject)messagebroker;
			messagebroker = (MessageBroker)eResolveProxy(oldMessagebroker);
			if (messagebroker != oldMessagebroker) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER, oldMessagebroker, messagebroker));
			}
		}
		return messagebroker;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MessageBroker basicGetMessagebroker() {
		return messagebroker;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMessagebroker(MessageBroker newMessagebroker, NotificationChain msgs) {
		MessageBroker oldMessagebroker = messagebroker;
		messagebroker = newMessagebroker;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER, oldMessagebroker, newMessagebroker);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMessagebroker(MessageBroker newMessagebroker) {
		if (newMessagebroker != messagebroker) {
			NotificationChain msgs = null;
			if (messagebroker != null)
				msgs = ((InternalEObject)messagebroker).eInverseRemove(this, IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM, MessageBroker.class, msgs);
			if (newMessagebroker != null)
				msgs = ((InternalEObject)newMessagebroker).eInverseAdd(this, IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM, MessageBroker.class, msgs);
			msgs = basicSetMessagebroker(newMessagebroker, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER, newMessagebroker, newMessagebroker));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WebServer getWebserver() {
		if (webserver != null && webserver.eIsProxy()) {
			InternalEObject oldWebserver = (InternalEObject)webserver;
			webserver = (WebServer)eResolveProxy(oldWebserver);
			if (webserver != oldWebserver) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, IotmodelPackage.IO_TPLATFORM__WEBSERVER, oldWebserver, webserver));
			}
		}
		return webserver;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WebServer basicGetWebserver() {
		return webserver;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetWebserver(WebServer newWebserver, NotificationChain msgs) {
		WebServer oldWebserver = webserver;
		webserver = newWebserver;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, IotmodelPackage.IO_TPLATFORM__WEBSERVER, oldWebserver, newWebserver);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWebserver(WebServer newWebserver) {
		if (newWebserver != webserver) {
			NotificationChain msgs = null;
			if (webserver != null)
				msgs = ((InternalEObject)webserver).eInverseRemove(this, IotmodelPackage.WEB_SERVER__IOTPLATFORM, WebServer.class, msgs);
			if (newWebserver != null)
				msgs = ((InternalEObject)newWebserver).eInverseAdd(this, IotmodelPackage.WEB_SERVER__IOTPLATFORM, WebServer.class, msgs);
			msgs = basicSetWebserver(newWebserver, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.IO_TPLATFORM__WEBSERVER, newWebserver, newWebserver));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM:
				if (sentReceivedByPlatform != null)
					msgs = ((InternalEObject)sentReceivedByPlatform).eInverseRemove(this, IotmodelPackage.MESSAGE__SEND_RECEIVE_MESSAGE, Message.class, msgs);
				return basicSetSentReceivedByPlatform((Message)otherEnd, msgs);
			case IotmodelPackage.IO_TPLATFORM__USERAPPLICATION:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getUserapplication()).basicAdd(otherEnd, msgs);
			case IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER:
				if (messagebroker != null)
					msgs = ((InternalEObject)messagebroker).eInverseRemove(this, IotmodelPackage.MESSAGE_BROKER__IOTPLATFORM, MessageBroker.class, msgs);
				return basicSetMessagebroker((MessageBroker)otherEnd, msgs);
			case IotmodelPackage.IO_TPLATFORM__WEBSERVER:
				if (webserver != null)
					msgs = ((InternalEObject)webserver).eInverseRemove(this, IotmodelPackage.WEB_SERVER__IOTPLATFORM, WebServer.class, msgs);
				return basicSetWebserver((WebServer)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM:
				return basicSetSentReceivedByPlatform(null, msgs);
			case IotmodelPackage.IO_TPLATFORM__USERAPPLICATION:
				return ((InternalEList<?>)getUserapplication()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER:
				return basicSetMessagebroker(null, msgs);
			case IotmodelPackage.IO_TPLATFORM__WEBSERVER:
				return basicSetWebserver(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IotmodelPackage.IO_TPLATFORM__USE_PROTOCOL:
				if (resolve) return getUseProtocol();
				return basicGetUseProtocol();
			case IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM:
				if (resolve) return getSentReceivedByPlatform();
				return basicGetSentReceivedByPlatform();
			case IotmodelPackage.IO_TPLATFORM__COMMUNICATE_THROUGH:
				if (resolve) return getCommunicateThrough();
				return basicGetCommunicateThrough();
			case IotmodelPackage.IO_TPLATFORM__USERAPPLICATION:
				return getUserapplication();
			case IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER:
				if (resolve) return getMessagebroker();
				return basicGetMessagebroker();
			case IotmodelPackage.IO_TPLATFORM__WEBSERVER:
				if (resolve) return getWebserver();
				return basicGetWebserver();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IotmodelPackage.IO_TPLATFORM__USE_PROTOCOL:
				setUseProtocol((ProtocolStack)newValue);
				return;
			case IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM:
				setSentReceivedByPlatform((Message)newValue);
				return;
			case IotmodelPackage.IO_TPLATFORM__COMMUNICATE_THROUGH:
				setCommunicateThrough((AppChannel)newValue);
				return;
			case IotmodelPackage.IO_TPLATFORM__USERAPPLICATION:
				getUserapplication().clear();
				getUserapplication().addAll((Collection<? extends UserApplication>)newValue);
				return;
			case IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER:
				setMessagebroker((MessageBroker)newValue);
				return;
			case IotmodelPackage.IO_TPLATFORM__WEBSERVER:
				setWebserver((WebServer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IotmodelPackage.IO_TPLATFORM__USE_PROTOCOL:
				setUseProtocol((ProtocolStack)null);
				return;
			case IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM:
				setSentReceivedByPlatform((Message)null);
				return;
			case IotmodelPackage.IO_TPLATFORM__COMMUNICATE_THROUGH:
				setCommunicateThrough((AppChannel)null);
				return;
			case IotmodelPackage.IO_TPLATFORM__USERAPPLICATION:
				getUserapplication().clear();
				return;
			case IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER:
				setMessagebroker((MessageBroker)null);
				return;
			case IotmodelPackage.IO_TPLATFORM__WEBSERVER:
				setWebserver((WebServer)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IotmodelPackage.IO_TPLATFORM__USE_PROTOCOL:
				return useProtocol != null;
			case IotmodelPackage.IO_TPLATFORM__SENT_RECEIVED_BY_PLATFORM:
				return sentReceivedByPlatform != null;
			case IotmodelPackage.IO_TPLATFORM__COMMUNICATE_THROUGH:
				return communicateThrough != null;
			case IotmodelPackage.IO_TPLATFORM__USERAPPLICATION:
				return userapplication != null && !userapplication.isEmpty();
			case IotmodelPackage.IO_TPLATFORM__MESSAGEBROKER:
				return messagebroker != null;
			case IotmodelPackage.IO_TPLATFORM__WEBSERVER:
				return webserver != null;
		}
		return super.eIsSet(featureID);
	}

} //IoTPlatformImpl
