/**
 */
package iotmodel.impl;

import iotmodel.AccessControlPolicy;
import iotmodel.Data;
import iotmodel.IotmodelPackage;
import iotmodel.Network;
import iotmodel.Thing;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Network</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link iotmodel.impl.NetworkImpl#getName <em>Name</em>}</li>
 *   <li>{@link iotmodel.impl.NetworkImpl#getDomain <em>Domain</em>}</li>
 *   <li>{@link iotmodel.impl.NetworkImpl#getEnforce <em>Enforce</em>}</li>
 *   <li>{@link iotmodel.impl.NetworkImpl#getThing <em>Thing</em>}</li>
 *   <li>{@link iotmodel.impl.NetworkImpl#getData <em>Data</em>}</li>
 * </ul>
 *
 * @generated
 */
public class NetworkImpl extends MinimalEObjectImpl.Container implements Network {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDomain() <em>Domain</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDomain()
	 * @generated
	 * @ordered
	 */
	protected static final String DOMAIN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDomain() <em>Domain</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDomain()
	 * @generated
	 * @ordered
	 */
	protected String domain = DOMAIN_EDEFAULT;

	/**
	 * The cached value of the '{@link #getEnforce() <em>Enforce</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnforce()
	 * @generated
	 * @ordered
	 */
	protected EList<AccessControlPolicy> enforce;

	/**
	 * The cached value of the '{@link #getThing() <em>Thing</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThing()
	 * @generated
	 * @ordered
	 */
	protected EList<Thing> thing;

	/**
	 * The cached value of the '{@link #getData() <em>Data</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getData()
	 * @generated
	 * @ordered
	 */
	protected EList<Data> data;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IotmodelPackage.Literals.NETWORK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.NETWORK__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDomain() {
		return domain;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDomain(String newDomain) {
		String oldDomain = domain;
		domain = newDomain;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IotmodelPackage.NETWORK__DOMAIN, oldDomain, domain));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AccessControlPolicy> getEnforce() {
		if (enforce == null) {
			enforce = new EObjectWithInverseResolvingEList.ManyInverse<AccessControlPolicy>(AccessControlPolicy.class, this, IotmodelPackage.NETWORK__ENFORCE, IotmodelPackage.ACCESS_CONTROL_POLICY__IS_ENFORCED);
		}
		return enforce;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Thing> getThing() {
		if (thing == null) {
			thing = new EObjectContainmentEList<Thing>(Thing.class, this, IotmodelPackage.NETWORK__THING);
		}
		return thing;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Data> getData() {
		if (data == null) {
			data = new EObjectContainmentEList<Data>(Data.class, this, IotmodelPackage.NETWORK__DATA);
		}
		return data;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.NETWORK__ENFORCE:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getEnforce()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case IotmodelPackage.NETWORK__ENFORCE:
				return ((InternalEList<?>)getEnforce()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.NETWORK__THING:
				return ((InternalEList<?>)getThing()).basicRemove(otherEnd, msgs);
			case IotmodelPackage.NETWORK__DATA:
				return ((InternalEList<?>)getData()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IotmodelPackage.NETWORK__NAME:
				return getName();
			case IotmodelPackage.NETWORK__DOMAIN:
				return getDomain();
			case IotmodelPackage.NETWORK__ENFORCE:
				return getEnforce();
			case IotmodelPackage.NETWORK__THING:
				return getThing();
			case IotmodelPackage.NETWORK__DATA:
				return getData();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IotmodelPackage.NETWORK__NAME:
				setName((String)newValue);
				return;
			case IotmodelPackage.NETWORK__DOMAIN:
				setDomain((String)newValue);
				return;
			case IotmodelPackage.NETWORK__ENFORCE:
				getEnforce().clear();
				getEnforce().addAll((Collection<? extends AccessControlPolicy>)newValue);
				return;
			case IotmodelPackage.NETWORK__THING:
				getThing().clear();
				getThing().addAll((Collection<? extends Thing>)newValue);
				return;
			case IotmodelPackage.NETWORK__DATA:
				getData().clear();
				getData().addAll((Collection<? extends Data>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IotmodelPackage.NETWORK__NAME:
				setName(NAME_EDEFAULT);
				return;
			case IotmodelPackage.NETWORK__DOMAIN:
				setDomain(DOMAIN_EDEFAULT);
				return;
			case IotmodelPackage.NETWORK__ENFORCE:
				getEnforce().clear();
				return;
			case IotmodelPackage.NETWORK__THING:
				getThing().clear();
				return;
			case IotmodelPackage.NETWORK__DATA:
				getData().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IotmodelPackage.NETWORK__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case IotmodelPackage.NETWORK__DOMAIN:
				return DOMAIN_EDEFAULT == null ? domain != null : !DOMAIN_EDEFAULT.equals(domain);
			case IotmodelPackage.NETWORK__ENFORCE:
				return enforce != null && !enforce.isEmpty();
			case IotmodelPackage.NETWORK__THING:
				return thing != null && !thing.isEmpty();
			case IotmodelPackage.NETWORK__DATA:
				return data != null && !data.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", domain: ");
		result.append(domain);
		result.append(')');
		return result.toString();
	}

} //NetworkImpl
