/**
 */
package iotmodel.util;

import iotmodel.*;

import java.util.Map;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see iotmodel.IotmodelPackage
 * @generated
 */
public class IotmodelValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final IotmodelValidator INSTANCE = new IotmodelValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "iotmodel";

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IotmodelValidator() {
		super();
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return IotmodelPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case IotmodelPackage.GATEWAY:
				return validateGateway((Gateway)value, diagnostics, context);
			case IotmodelPackage.EDGE_DEVICE:
				return validateEdgeDevice((EdgeDevice)value, diagnostics, context);
			case IotmodelPackage.APP_CHANNEL:
				return validateAppChannel((AppChannel)value, diagnostics, context);
			case IotmodelPackage.NETWORK:
				return validateNetwork((Network)value, diagnostics, context);
			case IotmodelPackage.REQUEST_RESPONSE:
				return validateRequestResponse((RequestResponse)value, diagnostics, context);
			case IotmodelPackage.PUBLISH_SUBSCRIBE:
				return validatePublishSubscribe((PublishSubscribe)value, diagnostics, context);
			case IotmodelPackage.THING:
				return validateThing((Thing)value, diagnostics, context);
			case IotmodelPackage.ACCESS_CONTROL_POLICY:
				return validateAccessControlPolicy((AccessControlPolicy)value, diagnostics, context);
			case IotmodelPackage.PROTOCOL_STACK:
				return validateProtocolStack((ProtocolStack)value, diagnostics, context);
			case IotmodelPackage.RULE:
				return validateRule((Rule)value, diagnostics, context);
			case IotmodelPackage.IO_TOS:
				return validateIoTOs((IoTOs)value, diagnostics, context);
			case IotmodelPackage.IO_TPLATFORM:
				return validateIoTPlatform((IoTPlatform)value, diagnostics, context);
			case IotmodelPackage.MESSAGE:
				return validateMessage((Message)value, diagnostics, context);
			case IotmodelPackage.MESSAGE_FORMAT:
				return validateMessageFormat((MessageFormat)value, diagnostics, context);
			case IotmodelPackage.MESSAGE_BROKER:
				return validateMessageBroker((MessageBroker)value, diagnostics, context);
			case IotmodelPackage.TOPIC:
				return validateTopic((Topic)value, diagnostics, context);
			case IotmodelPackage.USER_APPLICATION:
				return validateUserApplication((UserApplication)value, diagnostics, context);
			case IotmodelPackage.DESKTOP_APP:
				return validateDesktopApp((DesktopApp)value, diagnostics, context);
			case IotmodelPackage.MOBILE_APP:
				return validateMobileApp((MobileApp)value, diagnostics, context);
			case IotmodelPackage.WEB_SERVER:
				return validateWebServer((WebServer)value, diagnostics, context);
			case IotmodelPackage.DEFAULT_POLICY:
				return validateDefaultPolicy((DefaultPolicy)value, diagnostics, context);
			case IotmodelPackage.PRIVATE_POLICY:
				return validatePrivatePolicy((PrivatePolicy)value, diagnostics, context);
			case IotmodelPackage.PERMISSION:
				return validatePermission((Permission)value, diagnostics, context);
			case IotmodelPackage.CONSTRAINT_EXPRESSION:
				return validateConstraintExpression((ConstraintExpression)value, diagnostics, context);
			case IotmodelPackage.ALLOW_PERMISSION:
				return validateAllowPermission((AllowPermission)value, diagnostics, context);
			case IotmodelPackage.DENY_PERMISSION:
				return validateDenyPermission((DenyPermission)value, diagnostics, context);
			case IotmodelPackage.SENSOR:
				return validateSensor((Sensor)value, diagnostics, context);
			case IotmodelPackage.ACTUATOR:
				return validateActuator((Actuator)value, diagnostics, context);
			case IotmodelPackage.IO_TMETAMODEL:
				return validateIoTMetamodel((IoTMetamodel)value, diagnostics, context);
			case IotmodelPackage.ID:
				return validateID((ID)value, diagnostics, context);
			case IotmodelPackage.BEHAVIOR:
				return validateBehavior((Behavior)value, diagnostics, context);
			case IotmodelPackage.ACTION:
				return validateAction((Action)value, diagnostics, context);
			case IotmodelPackage.EVENT:
				return validateEvent((Event)value, diagnostics, context);
			case IotmodelPackage.PROGRAMMING_MODEL:
				return validateProgrammingModel((ProgrammingModel)value, diagnostics, context);
			case IotmodelPackage.SHARED_ACTION:
				return validateSharedAction((SharedAction)value, diagnostics, context);
			case IotmodelPackage.APP_PORT:
				return validateAppPort((AppPort)value, diagnostics, context);
			case IotmodelPackage.DATA:
				return validateData((Data)value, diagnostics, context);
			case IotmodelPackage.ACTOR:
				return validateActor((Actor)value, diagnostics, context);
			case IotmodelPackage.MALICIOUS_ACTOR:
				return validateMaliciousActor((MaliciousActor)value, diagnostics, context);
			case IotmodelPackage.OS_LIST:
				return validateOsList((OsList)value, diagnostics, context);
			case IotmodelPackage.PHYSICAL_LINK_LAYER:
				return validatePhysicalLinkLayer((PhysicalLinkLayer)value, diagnostics, context);
			case IotmodelPackage.TRANSPORT_LAYER:
				return validateTransportLayer((TransportLayer)value, diagnostics, context);
			case IotmodelPackage.NETWORK_LAYER:
				return validateNetworkLayer((NetworkLayer)value, diagnostics, context);
			case IotmodelPackage.APPLICATION_LAYER:
				return validateApplicationLayer((ApplicationLayer)value, diagnostics, context);
			case IotmodelPackage.ID_LIST:
				return validateIdList((IdList)value, diagnostics, context);
			case IotmodelPackage.LANGUAGE_LIST:
				return validateLanguageList((LanguageList)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateGateway(Gateway gateway, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(gateway, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEdgeDevice(EdgeDevice edgeDevice, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(edgeDevice, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAppChannel(AppChannel appChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(appChannel, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateNetwork(Network network, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(network, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateRequestResponse(RequestResponse requestResponse, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(requestResponse, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePublishSubscribe(PublishSubscribe publishSubscribe, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(publishSubscribe, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateThing(Thing thing, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(thing, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAccessControlPolicy(AccessControlPolicy accessControlPolicy, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(accessControlPolicy, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProtocolStack(ProtocolStack protocolStack, DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (!validate_NoCircularContainment(protocolStack, diagnostics, context)) return false;
		boolean result = validate_EveryMultiplicityConforms(protocolStack, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(protocolStack, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(protocolStack, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryBidirectionalReferenceIsPaired(protocolStack, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(protocolStack, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(protocolStack, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(protocolStack, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(protocolStack, diagnostics, context);
		if (result || diagnostics != null) result &= validateProtocolStack_CheckNameSize(protocolStack, diagnostics, context);
		return result;
	}

	/**
	 * The cached validation expression for the CheckNameSize constraint of '<em>Protocol Stack</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final String PROTOCOL_STACK__CHECK_NAME_SIZE__EEXPRESSION = "self.name.size()>=5";

	/**
	 * Validates the CheckNameSize constraint of '<em>Protocol Stack</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProtocolStack_CheckNameSize(ProtocolStack protocolStack, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return
			validate
				(IotmodelPackage.Literals.PROTOCOL_STACK,
				 protocolStack,
				 diagnostics,
				 context,
				 "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot",
				 "CheckNameSize",
				 PROTOCOL_STACK__CHECK_NAME_SIZE__EEXPRESSION,
				 Diagnostic.ERROR,
				 DIAGNOSTIC_SOURCE,
				 0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateRule(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(rule, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateIoTOs(IoTOs ioTOs, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(ioTOs, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateIoTPlatform(IoTPlatform ioTPlatform, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(ioTPlatform, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMessage(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(message, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMessageFormat(MessageFormat messageFormat, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(messageFormat, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMessageBroker(MessageBroker messageBroker, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(messageBroker, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTopic(Topic topic, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(topic, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateUserApplication(UserApplication userApplication, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(userApplication, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDesktopApp(DesktopApp desktopApp, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(desktopApp, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMobileApp(MobileApp mobileApp, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(mobileApp, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateWebServer(WebServer webServer, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(webServer, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDefaultPolicy(DefaultPolicy defaultPolicy, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(defaultPolicy, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePrivatePolicy(PrivatePolicy privatePolicy, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(privatePolicy, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePermission(Permission permission, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(permission, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateConstraintExpression(ConstraintExpression constraintExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(constraintExpression, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAllowPermission(AllowPermission allowPermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(allowPermission, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateDenyPermission(DenyPermission denyPermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(denyPermission, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSensor(Sensor sensor, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(sensor, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateActuator(Actuator actuator, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(actuator, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateIoTMetamodel(IoTMetamodel ioTMetamodel, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(ioTMetamodel, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateID(ID id, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(id, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBehavior(Behavior behavior, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(behavior, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAction(Action action, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(action, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEvent(Event event, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(event, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateProgrammingModel(ProgrammingModel programmingModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(programmingModel, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSharedAction(SharedAction sharedAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(sharedAction, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateAppPort(AppPort appPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(appPort, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateData(Data data, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(data, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateActor(Actor actor, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(actor, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMaliciousActor(MaliciousActor maliciousActor, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return validate_EveryDefaultConstraint(maliciousActor, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOsList(OsList osList, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePhysicalLinkLayer(PhysicalLinkLayer physicalLinkLayer, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateTransportLayer(TransportLayer transportLayer, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateNetworkLayer(NetworkLayer networkLayer, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateApplicationLayer(ApplicationLayer applicationLayer, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateIdList(IdList idList, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLanguageList(LanguageList languageList, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return true;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //IotmodelValidator
