/**
 * 
 * Copyright (c) 2009 Hatha Systems.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.gmt.modisco.omg.kdm.code.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.gmt.modisco.omg.kdm.action.EntryFlow;

import org.eclipse.gmt.modisco.omg.kdm.code.AbstractCodeElement;
import org.eclipse.gmt.modisco.omg.kdm.code.AbstractCodeRelationship;
import org.eclipse.gmt.modisco.omg.kdm.code.CodePackage;
import org.eclipse.gmt.modisco.omg.kdm.code.CommentUnit;
import org.eclipse.gmt.modisco.omg.kdm.code.PreprocessorDirective;

import org.eclipse.gmt.modisco.omg.kdm.core.AggregatedRelationship;
import org.eclipse.gmt.modisco.omg.kdm.core.KDMEntity;
import org.eclipse.gmt.modisco.omg.kdm.core.KDMRelationship;

import org.eclipse.gmt.modisco.omg.kdm.kdm.Annotation;
import org.eclipse.gmt.modisco.omg.kdm.kdm.Attribute;
import org.eclipse.gmt.modisco.omg.kdm.kdm.ExtendedValue;
import org.eclipse.gmt.modisco.omg.kdm.kdm.KDMModel;
import org.eclipse.gmt.modisco.omg.kdm.kdm.Stereotype;

import org.eclipse.gmt.modisco.omg.kdm.source.SourceRef;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Preprocessor Directive</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getAttribute <em>Attribute</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getAnnotation <em>Annotation</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getStereotype <em>Stereotype</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getTaggedValue <em>Tagged Value</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getSource <em>Source</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getComment <em>Comment</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getEntryFlow <em>Entry Flow</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getCodeRelation <em>Code Relation</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.code.impl.PreprocessorDirectiveImpl#getCodeElement <em>Code Element</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PreprocessorDirectiveImpl extends MinimalEObjectImpl.Container implements PreprocessorDirective {
	/**
	 * The cached value of the '{@link #getAttribute() <em>Attribute</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttribute()
	 * @generated
	 * @ordered
	 */
	protected EList<Attribute> attribute;

	/**
	 * The cached value of the '{@link #getAnnotation() <em>Annotation</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotation()
	 * @generated
	 * @ordered
	 */
	protected EList<Annotation> annotation;

	/**
	 * The cached value of the '{@link #getStereotype() <em>Stereotype</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStereotype()
	 * @generated
	 * @ordered
	 */
	protected EList<Stereotype> stereotype;

	/**
	 * The cached value of the '{@link #getTaggedValue() <em>Tagged Value</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTaggedValue()
	 * @generated
	 * @ordered
	 */
	protected EList<ExtendedValue> taggedValue;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSource() <em>Source</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSource()
	 * @generated
	 * @ordered
	 */
	protected EList<SourceRef> source;

	/**
	 * The cached value of the '{@link #getComment() <em>Comment</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected EList<CommentUnit> comment;

	/**
	 * The cached value of the '{@link #getEntryFlow() <em>Entry Flow</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEntryFlow()
	 * @generated
	 * @ordered
	 */
	protected EList<EntryFlow> entryFlow;

	/**
	 * The cached value of the '{@link #getCodeRelation() <em>Code Relation</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCodeRelation()
	 * @generated
	 * @ordered
	 */
	protected EList<AbstractCodeRelationship> codeRelation;

	/**
	 * The cached value of the '{@link #getCodeElement() <em>Code Element</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCodeElement()
	 * @generated
	 * @ordered
	 */
	protected EList<AbstractCodeElement> codeElement;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PreprocessorDirectiveImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CodePackage.Literals.PREPROCESSOR_DIRECTIVE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Attribute> getAttribute() {
		if (attribute == null) {
			attribute = new EObjectContainmentEList<Attribute>(Attribute.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__ATTRIBUTE);
		}
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Annotation> getAnnotation() {
		if (annotation == null) {
			annotation = new EObjectContainmentEList<Annotation>(Annotation.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__ANNOTATION);
		}
		return annotation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Stereotype> getStereotype() {
		if (stereotype == null) {
			stereotype = new EObjectResolvingEList<Stereotype>(Stereotype.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__STEREOTYPE);
		}
		return stereotype;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ExtendedValue> getTaggedValue() {
		if (taggedValue == null) {
			taggedValue = new EObjectContainmentEList<ExtendedValue>(ExtendedValue.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__TAGGED_VALUE);
		}
		return taggedValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CodePackage.PREPROCESSOR_DIRECTIVE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<SourceRef> getSource() {
		if (source == null) {
			source = new EObjectContainmentEList<SourceRef>(SourceRef.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__SOURCE);
		}
		return source;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CommentUnit> getComment() {
		if (comment == null) {
			comment = new EObjectContainmentEList<CommentUnit>(CommentUnit.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__COMMENT);
		}
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EntryFlow> getEntryFlow() {
		if (entryFlow == null) {
			entryFlow = new EObjectContainmentEList<EntryFlow>(EntryFlow.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__ENTRY_FLOW);
		}
		return entryFlow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AbstractCodeRelationship> getCodeRelation() {
		if (codeRelation == null) {
			codeRelation = new EObjectContainmentEList<AbstractCodeRelationship>(AbstractCodeRelationship.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__CODE_RELATION);
		}
		return codeRelation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AbstractCodeElement> getCodeElement() {
		if (codeElement == null) {
			codeElement = new EObjectContainmentEList<AbstractCodeElement>(AbstractCodeElement.class, this, CodePackage.PREPROCESSOR_DIRECTIVE__CODE_ELEMENT);
		}
		return codeElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createAggregation(KDMEntity otherEntity) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void deleteAggregation(AggregatedRelationship aggregation) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMRelationship> getInbound() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMRelationship> getOutbound() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMRelationship> getOwnedRelation() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AggregatedRelationship> getInAggregated() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AggregatedRelationship> getOutAggregated() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMEntity getOwner() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMEntity> getOwnedElement() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMEntity> getGroup() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMEntity> getGroupedElement() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMModel getModel() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case CodePackage.PREPROCESSOR_DIRECTIVE__ATTRIBUTE:
				return ((InternalEList<?>)getAttribute()).basicRemove(otherEnd, msgs);
			case CodePackage.PREPROCESSOR_DIRECTIVE__ANNOTATION:
				return ((InternalEList<?>)getAnnotation()).basicRemove(otherEnd, msgs);
			case CodePackage.PREPROCESSOR_DIRECTIVE__TAGGED_VALUE:
				return ((InternalEList<?>)getTaggedValue()).basicRemove(otherEnd, msgs);
			case CodePackage.PREPROCESSOR_DIRECTIVE__SOURCE:
				return ((InternalEList<?>)getSource()).basicRemove(otherEnd, msgs);
			case CodePackage.PREPROCESSOR_DIRECTIVE__COMMENT:
				return ((InternalEList<?>)getComment()).basicRemove(otherEnd, msgs);
			case CodePackage.PREPROCESSOR_DIRECTIVE__ENTRY_FLOW:
				return ((InternalEList<?>)getEntryFlow()).basicRemove(otherEnd, msgs);
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_RELATION:
				return ((InternalEList<?>)getCodeRelation()).basicRemove(otherEnd, msgs);
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_ELEMENT:
				return ((InternalEList<?>)getCodeElement()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CodePackage.PREPROCESSOR_DIRECTIVE__ATTRIBUTE:
				return getAttribute();
			case CodePackage.PREPROCESSOR_DIRECTIVE__ANNOTATION:
				return getAnnotation();
			case CodePackage.PREPROCESSOR_DIRECTIVE__STEREOTYPE:
				return getStereotype();
			case CodePackage.PREPROCESSOR_DIRECTIVE__TAGGED_VALUE:
				return getTaggedValue();
			case CodePackage.PREPROCESSOR_DIRECTIVE__NAME:
				return getName();
			case CodePackage.PREPROCESSOR_DIRECTIVE__SOURCE:
				return getSource();
			case CodePackage.PREPROCESSOR_DIRECTIVE__COMMENT:
				return getComment();
			case CodePackage.PREPROCESSOR_DIRECTIVE__ENTRY_FLOW:
				return getEntryFlow();
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_RELATION:
				return getCodeRelation();
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_ELEMENT:
				return getCodeElement();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CodePackage.PREPROCESSOR_DIRECTIVE__ATTRIBUTE:
				getAttribute().clear();
				getAttribute().addAll((Collection<? extends Attribute>)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__ANNOTATION:
				getAnnotation().clear();
				getAnnotation().addAll((Collection<? extends Annotation>)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__STEREOTYPE:
				getStereotype().clear();
				getStereotype().addAll((Collection<? extends Stereotype>)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__TAGGED_VALUE:
				getTaggedValue().clear();
				getTaggedValue().addAll((Collection<? extends ExtendedValue>)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__NAME:
				setName((String)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__SOURCE:
				getSource().clear();
				getSource().addAll((Collection<? extends SourceRef>)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__COMMENT:
				getComment().clear();
				getComment().addAll((Collection<? extends CommentUnit>)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__ENTRY_FLOW:
				getEntryFlow().clear();
				getEntryFlow().addAll((Collection<? extends EntryFlow>)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_RELATION:
				getCodeRelation().clear();
				getCodeRelation().addAll((Collection<? extends AbstractCodeRelationship>)newValue);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_ELEMENT:
				getCodeElement().clear();
				getCodeElement().addAll((Collection<? extends AbstractCodeElement>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CodePackage.PREPROCESSOR_DIRECTIVE__ATTRIBUTE:
				getAttribute().clear();
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__ANNOTATION:
				getAnnotation().clear();
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__STEREOTYPE:
				getStereotype().clear();
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__TAGGED_VALUE:
				getTaggedValue().clear();
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__SOURCE:
				getSource().clear();
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__COMMENT:
				getComment().clear();
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__ENTRY_FLOW:
				getEntryFlow().clear();
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_RELATION:
				getCodeRelation().clear();
				return;
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_ELEMENT:
				getCodeElement().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CodePackage.PREPROCESSOR_DIRECTIVE__ATTRIBUTE:
				return attribute != null && !attribute.isEmpty();
			case CodePackage.PREPROCESSOR_DIRECTIVE__ANNOTATION:
				return annotation != null && !annotation.isEmpty();
			case CodePackage.PREPROCESSOR_DIRECTIVE__STEREOTYPE:
				return stereotype != null && !stereotype.isEmpty();
			case CodePackage.PREPROCESSOR_DIRECTIVE__TAGGED_VALUE:
				return taggedValue != null && !taggedValue.isEmpty();
			case CodePackage.PREPROCESSOR_DIRECTIVE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case CodePackage.PREPROCESSOR_DIRECTIVE__SOURCE:
				return source != null && !source.isEmpty();
			case CodePackage.PREPROCESSOR_DIRECTIVE__COMMENT:
				return comment != null && !comment.isEmpty();
			case CodePackage.PREPROCESSOR_DIRECTIVE__ENTRY_FLOW:
				return entryFlow != null && !entryFlow.isEmpty();
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_RELATION:
				return codeRelation != null && !codeRelation.isEmpty();
			case CodePackage.PREPROCESSOR_DIRECTIVE__CODE_ELEMENT:
				return codeElement != null && !codeElement.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case CodePackage.PREPROCESSOR_DIRECTIVE___CREATE_AGGREGATION__KDMENTITY:
				createAggregation((KDMEntity)arguments.get(0));
				return null;
			case CodePackage.PREPROCESSOR_DIRECTIVE___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP:
				deleteAggregation((AggregatedRelationship)arguments.get(0));
				return null;
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_INBOUND:
				return getInbound();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_OUTBOUND:
				return getOutbound();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_OWNED_RELATION:
				return getOwnedRelation();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_IN_AGGREGATED:
				return getInAggregated();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_OUT_AGGREGATED:
				return getOutAggregated();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_OWNER:
				return getOwner();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_OWNED_ELEMENT:
				return getOwnedElement();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_GROUP:
				return getGroup();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_GROUPED_ELEMENT:
				return getGroupedElement();
			case CodePackage.PREPROCESSOR_DIRECTIVE___GET_MODEL:
				return getModel();
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: "); //$NON-NLS-1$
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //PreprocessorDirectiveImpl
