/**
 * 
 * Copyright (c) 2009 Hatha Systems.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.gmt.modisco.omg.kdm.event;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.gmt.modisco.omg.kdm.action.ActionPackage;

import org.eclipse.gmt.modisco.omg.kdm.core.CorePackage;

import org.eclipse.gmt.modisco.omg.kdm.kdm.KdmPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventFactory
 * @model kind="package"
 * @generated
 */
public interface EventPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "event"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://schema.omg.org/spec/KDM/1.2/event"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "event"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EventPackage eINSTANCE = org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventModelImpl <em>Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventModelImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventModel()
	 * @generated
	 */
	int EVENT_MODEL = 0;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__ATTRIBUTE = KdmPackage.KDM_MODEL__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__ANNOTATION = KdmPackage.KDM_MODEL__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__STEREOTYPE = KdmPackage.KDM_MODEL__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__TAGGED_VALUE = KdmPackage.KDM_MODEL__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Audit</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__AUDIT = KdmPackage.KDM_MODEL__AUDIT;

	/**
	 * The feature id for the '<em><b>Extension Family</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__EXTENSION_FAMILY = KdmPackage.KDM_MODEL__EXTENSION_FAMILY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__NAME = KdmPackage.KDM_MODEL__NAME;

	/**
	 * The feature id for the '<em><b>Event Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL__EVENT_ELEMENT = KdmPackage.KDM_MODEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL_FEATURE_COUNT = KdmPackage.KDM_MODEL_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_MODEL_OPERATION_COUNT = KdmPackage.KDM_MODEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement <em>Abstract Event Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getAbstractEventElement()
	 * @generated
	 */
	int ABSTRACT_EVENT_ELEMENT = 1;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__ATTRIBUTE = CorePackage.KDM_ENTITY__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__ANNOTATION = CorePackage.KDM_ENTITY__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__STEREOTYPE = CorePackage.KDM_ENTITY__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__TAGGED_VALUE = CorePackage.KDM_ENTITY__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__NAME = CorePackage.KDM_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__SOURCE = CorePackage.KDM_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__EVENT_RELATION = CorePackage.KDM_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__ABSTRACTION = CorePackage.KDM_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT__IMPLEMENTATION = CorePackage.KDM_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Abstract Event Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT = CorePackage.KDM_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___CREATE_AGGREGATION__KDMENTITY = CorePackage.KDM_ENTITY___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = CorePackage.KDM_ENTITY___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_INBOUND = CorePackage.KDM_ENTITY___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_OUTBOUND = CorePackage.KDM_ENTITY___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_OWNED_RELATION = CorePackage.KDM_ENTITY___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_IN_AGGREGATED = CorePackage.KDM_ENTITY___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_OUT_AGGREGATED = CorePackage.KDM_ENTITY___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_OWNER = CorePackage.KDM_ENTITY___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_OWNED_ELEMENT = CorePackage.KDM_ENTITY___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_GROUP = CorePackage.KDM_ENTITY___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_GROUPED_ELEMENT = CorePackage.KDM_ENTITY___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT___GET_MODEL = CorePackage.KDM_ENTITY___GET_MODEL;

	/**
	 * The number of operations of the '<em>Abstract Event Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_ELEMENT_OPERATION_COUNT = CorePackage.KDM_ENTITY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventImpl <em>Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEvent()
	 * @generated
	 */
	int EVENT = 2;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__ATTRIBUTE = ABSTRACT_EVENT_ELEMENT__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__ANNOTATION = ABSTRACT_EVENT_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__STEREOTYPE = ABSTRACT_EVENT_ELEMENT__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__TAGGED_VALUE = ABSTRACT_EVENT_ELEMENT__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__NAME = ABSTRACT_EVENT_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__SOURCE = ABSTRACT_EVENT_ELEMENT__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__EVENT_RELATION = ABSTRACT_EVENT_ELEMENT__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__ABSTRACTION = ABSTRACT_EVENT_ELEMENT__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__IMPLEMENTATION = ABSTRACT_EVENT_ELEMENT__IMPLEMENTATION;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__KIND = ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_FEATURE_COUNT = ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___CREATE_AGGREGATION__KDMENTITY = ABSTRACT_EVENT_ELEMENT___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = ABSTRACT_EVENT_ELEMENT___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_INBOUND = ABSTRACT_EVENT_ELEMENT___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_OUTBOUND = ABSTRACT_EVENT_ELEMENT___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_OWNED_RELATION = ABSTRACT_EVENT_ELEMENT___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_IN_AGGREGATED = ABSTRACT_EVENT_ELEMENT___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_OUT_AGGREGATED = ABSTRACT_EVENT_ELEMENT___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_OWNER = ABSTRACT_EVENT_ELEMENT___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_OWNED_ELEMENT = ABSTRACT_EVENT_ELEMENT___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_GROUP = ABSTRACT_EVENT_ELEMENT___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_GROUPED_ELEMENT = ABSTRACT_EVENT_ELEMENT___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT___GET_MODEL = ABSTRACT_EVENT_ELEMENT___GET_MODEL;

	/**
	 * The number of operations of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_OPERATION_COUNT = ABSTRACT_EVENT_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventRelationship <em>Abstract Event Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventRelationship
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getAbstractEventRelationship()
	 * @generated
	 */
	int ABSTRACT_EVENT_RELATIONSHIP = 3;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_RELATIONSHIP__ATTRIBUTE = CorePackage.KDM_RELATIONSHIP__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_RELATIONSHIP__ANNOTATION = CorePackage.KDM_RELATIONSHIP__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_RELATIONSHIP__STEREOTYPE = CorePackage.KDM_RELATIONSHIP__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_RELATIONSHIP__TAGGED_VALUE = CorePackage.KDM_RELATIONSHIP__TAGGED_VALUE;

	/**
	 * The number of structural features of the '<em>Abstract Event Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT = CorePackage.KDM_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Get To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_RELATIONSHIP___GET_TO = CorePackage.KDM_RELATIONSHIP___GET_TO;

	/**
	 * The operation id for the '<em>Get From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_RELATIONSHIP___GET_FROM = CorePackage.KDM_RELATIONSHIP___GET_FROM;

	/**
	 * The number of operations of the '<em>Abstract Event Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_EVENT_RELATIONSHIP_OPERATION_COUNT = CorePackage.KDM_RELATIONSHIP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventRelationshipImpl <em>Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventRelationshipImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventRelationship()
	 * @generated
	 */
	int EVENT_RELATIONSHIP = 4;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP__ATTRIBUTE = ABSTRACT_EVENT_RELATIONSHIP__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP__ANNOTATION = ABSTRACT_EVENT_RELATIONSHIP__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP__STEREOTYPE = ABSTRACT_EVENT_RELATIONSHIP__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP__TAGGED_VALUE = ABSTRACT_EVENT_RELATIONSHIP__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP__TO = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP__FROM = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP_FEATURE_COUNT = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP___GET_TO = ABSTRACT_EVENT_RELATIONSHIP___GET_TO;

	/**
	 * The operation id for the '<em>Get From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP___GET_FROM = ABSTRACT_EVENT_RELATIONSHIP___GET_FROM;

	/**
	 * The number of operations of the '<em>Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RELATIONSHIP_OPERATION_COUNT = ABSTRACT_EVENT_RELATIONSHIP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventResourceImpl <em>Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventResourceImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventResource()
	 * @generated
	 */
	int EVENT_RESOURCE = 5;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__ATTRIBUTE = ABSTRACT_EVENT_ELEMENT__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__ANNOTATION = ABSTRACT_EVENT_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__STEREOTYPE = ABSTRACT_EVENT_ELEMENT__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__TAGGED_VALUE = ABSTRACT_EVENT_ELEMENT__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__NAME = ABSTRACT_EVENT_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__SOURCE = ABSTRACT_EVENT_ELEMENT__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__EVENT_RELATION = ABSTRACT_EVENT_ELEMENT__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__ABSTRACTION = ABSTRACT_EVENT_ELEMENT__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__IMPLEMENTATION = ABSTRACT_EVENT_ELEMENT__IMPLEMENTATION;

	/**
	 * The feature id for the '<em><b>Event Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE__EVENT_ELEMENT = ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE_FEATURE_COUNT = ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___CREATE_AGGREGATION__KDMENTITY = ABSTRACT_EVENT_ELEMENT___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = ABSTRACT_EVENT_ELEMENT___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_INBOUND = ABSTRACT_EVENT_ELEMENT___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_OUTBOUND = ABSTRACT_EVENT_ELEMENT___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_OWNED_RELATION = ABSTRACT_EVENT_ELEMENT___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_IN_AGGREGATED = ABSTRACT_EVENT_ELEMENT___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_OUT_AGGREGATED = ABSTRACT_EVENT_ELEMENT___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_OWNER = ABSTRACT_EVENT_ELEMENT___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_OWNED_ELEMENT = ABSTRACT_EVENT_ELEMENT___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_GROUP = ABSTRACT_EVENT_ELEMENT___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_GROUPED_ELEMENT = ABSTRACT_EVENT_ELEMENT___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE___GET_MODEL = ABSTRACT_EVENT_ELEMENT___GET_MODEL;

	/**
	 * The number of operations of the '<em>Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_RESOURCE_OPERATION_COUNT = ABSTRACT_EVENT_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.StateImpl <em>State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.StateImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getState()
	 * @generated
	 */
	int STATE = 6;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__ATTRIBUTE = EVENT_RESOURCE__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__ANNOTATION = EVENT_RESOURCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__STEREOTYPE = EVENT_RESOURCE__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__TAGGED_VALUE = EVENT_RESOURCE__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__NAME = EVENT_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__SOURCE = EVENT_RESOURCE__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__EVENT_RELATION = EVENT_RESOURCE__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__ABSTRACTION = EVENT_RESOURCE__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__IMPLEMENTATION = EVENT_RESOURCE__IMPLEMENTATION;

	/**
	 * The feature id for the '<em><b>Event Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__EVENT_ELEMENT = EVENT_RESOURCE__EVENT_ELEMENT;

	/**
	 * The number of structural features of the '<em>State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_FEATURE_COUNT = EVENT_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___CREATE_AGGREGATION__KDMENTITY = EVENT_RESOURCE___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = EVENT_RESOURCE___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_INBOUND = EVENT_RESOURCE___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_OUTBOUND = EVENT_RESOURCE___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_OWNED_RELATION = EVENT_RESOURCE___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_IN_AGGREGATED = EVENT_RESOURCE___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_OUT_AGGREGATED = EVENT_RESOURCE___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_OWNER = EVENT_RESOURCE___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_OWNED_ELEMENT = EVENT_RESOURCE___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_GROUP = EVENT_RESOURCE___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_GROUPED_ELEMENT = EVENT_RESOURCE___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE___GET_MODEL = EVENT_RESOURCE___GET_MODEL;

	/**
	 * The number of operations of the '<em>State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_OPERATION_COUNT = EVENT_RESOURCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.TransitionImpl <em>Transition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.TransitionImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getTransition()
	 * @generated
	 */
	int TRANSITION = 7;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__ATTRIBUTE = EVENT_RESOURCE__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__ANNOTATION = EVENT_RESOURCE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__STEREOTYPE = EVENT_RESOURCE__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__TAGGED_VALUE = EVENT_RESOURCE__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__NAME = EVENT_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__SOURCE = EVENT_RESOURCE__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__EVENT_RELATION = EVENT_RESOURCE__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__ABSTRACTION = EVENT_RESOURCE__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__IMPLEMENTATION = EVENT_RESOURCE__IMPLEMENTATION;

	/**
	 * The feature id for the '<em><b>Event Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__EVENT_ELEMENT = EVENT_RESOURCE__EVENT_ELEMENT;

	/**
	 * The number of structural features of the '<em>Transition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION_FEATURE_COUNT = EVENT_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___CREATE_AGGREGATION__KDMENTITY = EVENT_RESOURCE___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = EVENT_RESOURCE___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_INBOUND = EVENT_RESOURCE___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_OUTBOUND = EVENT_RESOURCE___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_OWNED_RELATION = EVENT_RESOURCE___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_IN_AGGREGATED = EVENT_RESOURCE___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_OUT_AGGREGATED = EVENT_RESOURCE___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_OWNER = EVENT_RESOURCE___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_OWNED_ELEMENT = EVENT_RESOURCE___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_GROUP = EVENT_RESOURCE___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_GROUPED_ELEMENT = EVENT_RESOURCE___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION___GET_MODEL = EVENT_RESOURCE___GET_MODEL;

	/**
	 * The number of operations of the '<em>Transition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION_OPERATION_COUNT = EVENT_RESOURCE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.OnEntryImpl <em>On Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.OnEntryImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getOnEntry()
	 * @generated
	 */
	int ON_ENTRY = 8;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__ATTRIBUTE = TRANSITION__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__ANNOTATION = TRANSITION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__STEREOTYPE = TRANSITION__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__TAGGED_VALUE = TRANSITION__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__NAME = TRANSITION__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__SOURCE = TRANSITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__EVENT_RELATION = TRANSITION__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__ABSTRACTION = TRANSITION__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__IMPLEMENTATION = TRANSITION__IMPLEMENTATION;

	/**
	 * The feature id for the '<em><b>Event Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY__EVENT_ELEMENT = TRANSITION__EVENT_ELEMENT;

	/**
	 * The number of structural features of the '<em>On Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY_FEATURE_COUNT = TRANSITION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___CREATE_AGGREGATION__KDMENTITY = TRANSITION___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = TRANSITION___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_INBOUND = TRANSITION___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_OUTBOUND = TRANSITION___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_OWNED_RELATION = TRANSITION___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_IN_AGGREGATED = TRANSITION___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_OUT_AGGREGATED = TRANSITION___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_OWNER = TRANSITION___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_OWNED_ELEMENT = TRANSITION___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_GROUP = TRANSITION___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_GROUPED_ELEMENT = TRANSITION___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY___GET_MODEL = TRANSITION___GET_MODEL;

	/**
	 * The number of operations of the '<em>On Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_ENTRY_OPERATION_COUNT = TRANSITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.OnExitImpl <em>On Exit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.OnExitImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getOnExit()
	 * @generated
	 */
	int ON_EXIT = 9;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__ATTRIBUTE = TRANSITION__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__ANNOTATION = TRANSITION__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__STEREOTYPE = TRANSITION__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__TAGGED_VALUE = TRANSITION__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__NAME = TRANSITION__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__SOURCE = TRANSITION__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__EVENT_RELATION = TRANSITION__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__ABSTRACTION = TRANSITION__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__IMPLEMENTATION = TRANSITION__IMPLEMENTATION;

	/**
	 * The feature id for the '<em><b>Event Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT__EVENT_ELEMENT = TRANSITION__EVENT_ELEMENT;

	/**
	 * The number of structural features of the '<em>On Exit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT_FEATURE_COUNT = TRANSITION_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___CREATE_AGGREGATION__KDMENTITY = TRANSITION___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = TRANSITION___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_INBOUND = TRANSITION___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_OUTBOUND = TRANSITION___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_OWNED_RELATION = TRANSITION___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_IN_AGGREGATED = TRANSITION___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_OUT_AGGREGATED = TRANSITION___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_OWNER = TRANSITION___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_OWNED_ELEMENT = TRANSITION___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_GROUP = TRANSITION___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_GROUPED_ELEMENT = TRANSITION___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT___GET_MODEL = TRANSITION___GET_MODEL;

	/**
	 * The number of operations of the '<em>On Exit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ON_EXIT_OPERATION_COUNT = TRANSITION_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventActionImpl <em>Action</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventActionImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventAction()
	 * @generated
	 */
	int EVENT_ACTION = 10;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__ATTRIBUTE = ABSTRACT_EVENT_ELEMENT__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__ANNOTATION = ABSTRACT_EVENT_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__STEREOTYPE = ABSTRACT_EVENT_ELEMENT__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__TAGGED_VALUE = ABSTRACT_EVENT_ELEMENT__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__NAME = ABSTRACT_EVENT_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__SOURCE = ABSTRACT_EVENT_ELEMENT__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__EVENT_RELATION = ABSTRACT_EVENT_ELEMENT__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__ABSTRACTION = ABSTRACT_EVENT_ELEMENT__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__IMPLEMENTATION = ABSTRACT_EVENT_ELEMENT__IMPLEMENTATION;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__KIND = ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Event Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION__EVENT_ELEMENT = ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION_FEATURE_COUNT = ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___CREATE_AGGREGATION__KDMENTITY = ABSTRACT_EVENT_ELEMENT___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = ABSTRACT_EVENT_ELEMENT___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_INBOUND = ABSTRACT_EVENT_ELEMENT___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_OUTBOUND = ABSTRACT_EVENT_ELEMENT___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_OWNED_RELATION = ABSTRACT_EVENT_ELEMENT___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_IN_AGGREGATED = ABSTRACT_EVENT_ELEMENT___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_OUT_AGGREGATED = ABSTRACT_EVENT_ELEMENT___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_OWNER = ABSTRACT_EVENT_ELEMENT___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_OWNED_ELEMENT = ABSTRACT_EVENT_ELEMENT___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_GROUP = ABSTRACT_EVENT_ELEMENT___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_GROUPED_ELEMENT = ABSTRACT_EVENT_ELEMENT___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION___GET_MODEL = ABSTRACT_EVENT_ELEMENT___GET_MODEL;

	/**
	 * The number of operations of the '<em>Action</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ACTION_OPERATION_COUNT = ABSTRACT_EVENT_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.ReadsStateImpl <em>Reads State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.ReadsStateImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getReadsState()
	 * @generated
	 */
	int READS_STATE = 11;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE__ATTRIBUTE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE__ANNOTATION = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE__STEREOTYPE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE__TAGGED_VALUE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE__TO = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE__FROM = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Reads State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE_FEATURE_COUNT = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE___GET_TO = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP___GET_TO;

	/**
	 * The operation id for the '<em>Get From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE___GET_FROM = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP___GET_FROM;

	/**
	 * The number of operations of the '<em>Reads State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int READS_STATE_OPERATION_COUNT = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.ProducesEventImpl <em>Produces Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.ProducesEventImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getProducesEvent()
	 * @generated
	 */
	int PRODUCES_EVENT = 12;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT__ATTRIBUTE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT__ANNOTATION = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT__STEREOTYPE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT__TAGGED_VALUE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT__TO = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT__FROM = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Produces Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT_FEATURE_COUNT = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT___GET_TO = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP___GET_TO;

	/**
	 * The operation id for the '<em>Get From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT___GET_FROM = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP___GET_FROM;

	/**
	 * The number of operations of the '<em>Produces Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRODUCES_EVENT_OPERATION_COUNT = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.ConsumesEventImpl <em>Consumes Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.ConsumesEventImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getConsumesEvent()
	 * @generated
	 */
	int CONSUMES_EVENT = 13;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT__ATTRIBUTE = ABSTRACT_EVENT_RELATIONSHIP__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT__ANNOTATION = ABSTRACT_EVENT_RELATIONSHIP__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT__STEREOTYPE = ABSTRACT_EVENT_RELATIONSHIP__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT__TAGGED_VALUE = ABSTRACT_EVENT_RELATIONSHIP__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT__TO = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT__FROM = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Consumes Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT_FEATURE_COUNT = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT___GET_TO = ABSTRACT_EVENT_RELATIONSHIP___GET_TO;

	/**
	 * The operation id for the '<em>Get From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT___GET_FROM = ABSTRACT_EVENT_RELATIONSHIP___GET_FROM;

	/**
	 * The number of operations of the '<em>Consumes Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSUMES_EVENT_OPERATION_COUNT = ABSTRACT_EVENT_RELATIONSHIP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.NextStateImpl <em>Next State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.NextStateImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getNextState()
	 * @generated
	 */
	int NEXT_STATE = 14;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE__ATTRIBUTE = ABSTRACT_EVENT_RELATIONSHIP__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE__ANNOTATION = ABSTRACT_EVENT_RELATIONSHIP__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE__STEREOTYPE = ABSTRACT_EVENT_RELATIONSHIP__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE__TAGGED_VALUE = ABSTRACT_EVENT_RELATIONSHIP__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE__TO = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE__FROM = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Next State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE_FEATURE_COUNT = ABSTRACT_EVENT_RELATIONSHIP_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE___GET_TO = ABSTRACT_EVENT_RELATIONSHIP___GET_TO;

	/**
	 * The operation id for the '<em>Get From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE___GET_FROM = ABSTRACT_EVENT_RELATIONSHIP___GET_FROM;

	/**
	 * The number of operations of the '<em>Next State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NEXT_STATE_OPERATION_COUNT = ABSTRACT_EVENT_RELATIONSHIP_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.InitialStateImpl <em>Initial State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.InitialStateImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getInitialState()
	 * @generated
	 */
	int INITIAL_STATE = 15;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__ATTRIBUTE = STATE__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__ANNOTATION = STATE__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__STEREOTYPE = STATE__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__TAGGED_VALUE = STATE__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__NAME = STATE__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__SOURCE = STATE__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__EVENT_RELATION = STATE__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__ABSTRACTION = STATE__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__IMPLEMENTATION = STATE__IMPLEMENTATION;

	/**
	 * The feature id for the '<em><b>Event Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE__EVENT_ELEMENT = STATE__EVENT_ELEMENT;

	/**
	 * The number of structural features of the '<em>Initial State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE_FEATURE_COUNT = STATE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___CREATE_AGGREGATION__KDMENTITY = STATE___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = STATE___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_INBOUND = STATE___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_OUTBOUND = STATE___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_OWNED_RELATION = STATE___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_IN_AGGREGATED = STATE___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_OUT_AGGREGATED = STATE___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_OWNER = STATE___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_OWNED_ELEMENT = STATE___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_GROUP = STATE___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_GROUPED_ELEMENT = STATE___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE___GET_MODEL = STATE___GET_MODEL;

	/**
	 * The number of operations of the '<em>Initial State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INITIAL_STATE_OPERATION_COUNT = STATE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventElementImpl <em>Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventElementImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventElement()
	 * @generated
	 */
	int EVENT_ELEMENT = 16;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__ATTRIBUTE = ABSTRACT_EVENT_ELEMENT__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__ANNOTATION = ABSTRACT_EVENT_ELEMENT__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__STEREOTYPE = ABSTRACT_EVENT_ELEMENT__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__TAGGED_VALUE = ABSTRACT_EVENT_ELEMENT__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__NAME = ABSTRACT_EVENT_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__SOURCE = ABSTRACT_EVENT_ELEMENT__SOURCE;

	/**
	 * The feature id for the '<em><b>Event Relation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__EVENT_RELATION = ABSTRACT_EVENT_ELEMENT__EVENT_RELATION;

	/**
	 * The feature id for the '<em><b>Abstraction</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__ABSTRACTION = ABSTRACT_EVENT_ELEMENT__ABSTRACTION;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT__IMPLEMENTATION = ABSTRACT_EVENT_ELEMENT__IMPLEMENTATION;

	/**
	 * The number of structural features of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT_FEATURE_COUNT = ABSTRACT_EVENT_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Create Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___CREATE_AGGREGATION__KDMENTITY = ABSTRACT_EVENT_ELEMENT___CREATE_AGGREGATION__KDMENTITY;

	/**
	 * The operation id for the '<em>Delete Aggregation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP = ABSTRACT_EVENT_ELEMENT___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP;

	/**
	 * The operation id for the '<em>Get Inbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_INBOUND = ABSTRACT_EVENT_ELEMENT___GET_INBOUND;

	/**
	 * The operation id for the '<em>Get Outbound</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_OUTBOUND = ABSTRACT_EVENT_ELEMENT___GET_OUTBOUND;

	/**
	 * The operation id for the '<em>Get Owned Relation</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_OWNED_RELATION = ABSTRACT_EVENT_ELEMENT___GET_OWNED_RELATION;

	/**
	 * The operation id for the '<em>Get In Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_IN_AGGREGATED = ABSTRACT_EVENT_ELEMENT___GET_IN_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Out Aggregated</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_OUT_AGGREGATED = ABSTRACT_EVENT_ELEMENT___GET_OUT_AGGREGATED;

	/**
	 * The operation id for the '<em>Get Owner</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_OWNER = ABSTRACT_EVENT_ELEMENT___GET_OWNER;

	/**
	 * The operation id for the '<em>Get Owned Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_OWNED_ELEMENT = ABSTRACT_EVENT_ELEMENT___GET_OWNED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_GROUP = ABSTRACT_EVENT_ELEMENT___GET_GROUP;

	/**
	 * The operation id for the '<em>Get Grouped Element</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_GROUPED_ELEMENT = ABSTRACT_EVENT_ELEMENT___GET_GROUPED_ELEMENT;

	/**
	 * The operation id for the '<em>Get Model</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT___GET_MODEL = ABSTRACT_EVENT_ELEMENT___GET_MODEL;

	/**
	 * The number of operations of the '<em>Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_ELEMENT_OPERATION_COUNT = ABSTRACT_EVENT_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.HasStateImpl <em>Has State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.HasStateImpl
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getHasState()
	 * @generated
	 */
	int HAS_STATE = 17;

	/**
	 * The feature id for the '<em><b>Attribute</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE__ATTRIBUTE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__ATTRIBUTE;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE__ANNOTATION = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__ANNOTATION;

	/**
	 * The feature id for the '<em><b>Stereotype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE__STEREOTYPE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__STEREOTYPE;

	/**
	 * The feature id for the '<em><b>Tagged Value</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE__TAGGED_VALUE = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP__TAGGED_VALUE;

	/**
	 * The feature id for the '<em><b>To</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE__TO = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE__FROM = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Has State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE_FEATURE_COUNT = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Get To</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE___GET_TO = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP___GET_TO;

	/**
	 * The operation id for the '<em>Get From</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE___GET_FROM = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP___GET_FROM;

	/**
	 * The number of operations of the '<em>Has State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HAS_STATE_OPERATION_COUNT = ActionPackage.ABSTRACT_ACTION_RELATIONSHIP_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventModel
	 * @generated
	 */
	EClass getEventModel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventModel#getEventElement <em>Event Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Event Element</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventModel#getEventElement()
	 * @see #getEventModel()
	 * @generated
	 */
	EReference getEventModel_EventElement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement <em>Abstract Event Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Event Element</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement
	 * @generated
	 */
	EClass getAbstractEventElement();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Source</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement#getSource()
	 * @see #getAbstractEventElement()
	 * @generated
	 */
	EReference getAbstractEventElement_Source();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement#getEventRelation <em>Event Relation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Event Relation</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement#getEventRelation()
	 * @see #getAbstractEventElement()
	 * @generated
	 */
	EReference getAbstractEventElement_EventRelation();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement#getAbstraction <em>Abstraction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Abstraction</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement#getAbstraction()
	 * @see #getAbstractEventElement()
	 * @generated
	 */
	EReference getAbstractEventElement_Abstraction();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement#getImplementation <em>Implementation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Implementation</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement#getImplementation()
	 * @see #getAbstractEventElement()
	 * @generated
	 */
	EReference getAbstractEventElement_Implementation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.Event <em>Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.Event
	 * @generated
	 */
	EClass getEvent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.omg.kdm.event.Event#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.Event#getKind()
	 * @see #getEvent()
	 * @generated
	 */
	EAttribute getEvent_Kind();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventRelationship <em>Abstract Event Relationship</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Event Relationship</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventRelationship
	 * @generated
	 */
	EClass getAbstractEventRelationship();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventRelationship <em>Relationship</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Relationship</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventRelationship
	 * @generated
	 */
	EClass getEventRelationship();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventRelationship#getTo <em>To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>To</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventRelationship#getTo()
	 * @see #getEventRelationship()
	 * @generated
	 */
	EReference getEventRelationship_To();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventRelationship#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventRelationship#getFrom()
	 * @see #getEventRelationship()
	 * @generated
	 */
	EReference getEventRelationship_From();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventResource <em>Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Resource</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventResource
	 * @generated
	 */
	EClass getEventResource();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventResource#getEventElement <em>Event Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Event Element</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventResource#getEventElement()
	 * @see #getEventResource()
	 * @generated
	 */
	EReference getEventResource_EventElement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.State <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.State
	 * @generated
	 */
	EClass getState();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.Transition <em>Transition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transition</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.Transition
	 * @generated
	 */
	EClass getTransition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.OnEntry <em>On Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>On Entry</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.OnEntry
	 * @generated
	 */
	EClass getOnEntry();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.OnExit <em>On Exit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>On Exit</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.OnExit
	 * @generated
	 */
	EClass getOnExit();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventAction <em>Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Action</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventAction
	 * @generated
	 */
	EClass getEventAction();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventAction#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventAction#getKind()
	 * @see #getEventAction()
	 * @generated
	 */
	EAttribute getEventAction_Kind();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventAction#getEventElement <em>Event Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Event Element</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventAction#getEventElement()
	 * @see #getEventAction()
	 * @generated
	 */
	EReference getEventAction_EventElement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.ReadsState <em>Reads State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reads State</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ReadsState
	 * @generated
	 */
	EClass getReadsState();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.ReadsState#getTo <em>To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>To</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ReadsState#getTo()
	 * @see #getReadsState()
	 * @generated
	 */
	EReference getReadsState_To();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.ReadsState#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ReadsState#getFrom()
	 * @see #getReadsState()
	 * @generated
	 */
	EReference getReadsState_From();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.ProducesEvent <em>Produces Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Produces Event</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ProducesEvent
	 * @generated
	 */
	EClass getProducesEvent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.ProducesEvent#getTo <em>To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>To</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ProducesEvent#getTo()
	 * @see #getProducesEvent()
	 * @generated
	 */
	EReference getProducesEvent_To();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.ProducesEvent#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ProducesEvent#getFrom()
	 * @see #getProducesEvent()
	 * @generated
	 */
	EReference getProducesEvent_From();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.ConsumesEvent <em>Consumes Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Consumes Event</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ConsumesEvent
	 * @generated
	 */
	EClass getConsumesEvent();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.ConsumesEvent#getTo <em>To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>To</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ConsumesEvent#getTo()
	 * @see #getConsumesEvent()
	 * @generated
	 */
	EReference getConsumesEvent_To();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.ConsumesEvent#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.ConsumesEvent#getFrom()
	 * @see #getConsumesEvent()
	 * @generated
	 */
	EReference getConsumesEvent_From();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.NextState <em>Next State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Next State</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.NextState
	 * @generated
	 */
	EClass getNextState();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.NextState#getTo <em>To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>To</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.NextState#getTo()
	 * @see #getNextState()
	 * @generated
	 */
	EReference getNextState_To();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.NextState#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.NextState#getFrom()
	 * @see #getNextState()
	 * @generated
	 */
	EReference getNextState_From();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.InitialState <em>Initial State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Initial State</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.InitialState
	 * @generated
	 */
	EClass getInitialState();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.EventElement <em>Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Element</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.EventElement
	 * @generated
	 */
	EClass getEventElement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.omg.kdm.event.HasState <em>Has State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Has State</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.HasState
	 * @generated
	 */
	EClass getHasState();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.HasState#getTo <em>To</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>To</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.HasState#getTo()
	 * @see #getHasState()
	 * @generated
	 */
	EReference getHasState_To();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.gmt.modisco.omg.kdm.event.HasState#getFrom <em>From</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>From</em>'.
	 * @see org.eclipse.gmt.modisco.omg.kdm.event.HasState#getFrom()
	 * @see #getHasState()
	 * @generated
	 */
	EReference getHasState_From();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	EventFactory getEventFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventModelImpl <em>Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventModelImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventModel()
		 * @generated
		 */
		EClass EVENT_MODEL = eINSTANCE.getEventModel();

		/**
		 * The meta object literal for the '<em><b>Event Element</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_MODEL__EVENT_ELEMENT = eINSTANCE.getEventModel_EventElement();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement <em>Abstract Event Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventElement
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getAbstractEventElement()
		 * @generated
		 */
		EClass ABSTRACT_EVENT_ELEMENT = eINSTANCE.getAbstractEventElement();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_EVENT_ELEMENT__SOURCE = eINSTANCE.getAbstractEventElement_Source();

		/**
		 * The meta object literal for the '<em><b>Event Relation</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_EVENT_ELEMENT__EVENT_RELATION = eINSTANCE.getAbstractEventElement_EventRelation();

		/**
		 * The meta object literal for the '<em><b>Abstraction</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_EVENT_ELEMENT__ABSTRACTION = eINSTANCE.getAbstractEventElement_Abstraction();

		/**
		 * The meta object literal for the '<em><b>Implementation</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ABSTRACT_EVENT_ELEMENT__IMPLEMENTATION = eINSTANCE.getAbstractEventElement_Implementation();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventImpl <em>Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEvent()
		 * @generated
		 */
		EClass EVENT = eINSTANCE.getEvent();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EVENT__KIND = eINSTANCE.getEvent_Kind();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventRelationship <em>Abstract Event Relationship</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.AbstractEventRelationship
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getAbstractEventRelationship()
		 * @generated
		 */
		EClass ABSTRACT_EVENT_RELATIONSHIP = eINSTANCE.getAbstractEventRelationship();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventRelationshipImpl <em>Relationship</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventRelationshipImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventRelationship()
		 * @generated
		 */
		EClass EVENT_RELATIONSHIP = eINSTANCE.getEventRelationship();

		/**
		 * The meta object literal for the '<em><b>To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_RELATIONSHIP__TO = eINSTANCE.getEventRelationship_To();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_RELATIONSHIP__FROM = eINSTANCE.getEventRelationship_From();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventResourceImpl <em>Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventResourceImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventResource()
		 * @generated
		 */
		EClass EVENT_RESOURCE = eINSTANCE.getEventResource();

		/**
		 * The meta object literal for the '<em><b>Event Element</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_RESOURCE__EVENT_ELEMENT = eINSTANCE.getEventResource_EventElement();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.StateImpl <em>State</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.StateImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getState()
		 * @generated
		 */
		EClass STATE = eINSTANCE.getState();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.TransitionImpl <em>Transition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.TransitionImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getTransition()
		 * @generated
		 */
		EClass TRANSITION = eINSTANCE.getTransition();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.OnEntryImpl <em>On Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.OnEntryImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getOnEntry()
		 * @generated
		 */
		EClass ON_ENTRY = eINSTANCE.getOnEntry();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.OnExitImpl <em>On Exit</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.OnExitImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getOnExit()
		 * @generated
		 */
		EClass ON_EXIT = eINSTANCE.getOnExit();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventActionImpl <em>Action</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventActionImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventAction()
		 * @generated
		 */
		EClass EVENT_ACTION = eINSTANCE.getEventAction();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EVENT_ACTION__KIND = eINSTANCE.getEventAction_Kind();

		/**
		 * The meta object literal for the '<em><b>Event Element</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_ACTION__EVENT_ELEMENT = eINSTANCE.getEventAction_EventElement();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.ReadsStateImpl <em>Reads State</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.ReadsStateImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getReadsState()
		 * @generated
		 */
		EClass READS_STATE = eINSTANCE.getReadsState();

		/**
		 * The meta object literal for the '<em><b>To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference READS_STATE__TO = eINSTANCE.getReadsState_To();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference READS_STATE__FROM = eINSTANCE.getReadsState_From();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.ProducesEventImpl <em>Produces Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.ProducesEventImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getProducesEvent()
		 * @generated
		 */
		EClass PRODUCES_EVENT = eINSTANCE.getProducesEvent();

		/**
		 * The meta object literal for the '<em><b>To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRODUCES_EVENT__TO = eINSTANCE.getProducesEvent_To();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRODUCES_EVENT__FROM = eINSTANCE.getProducesEvent_From();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.ConsumesEventImpl <em>Consumes Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.ConsumesEventImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getConsumesEvent()
		 * @generated
		 */
		EClass CONSUMES_EVENT = eINSTANCE.getConsumesEvent();

		/**
		 * The meta object literal for the '<em><b>To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONSUMES_EVENT__TO = eINSTANCE.getConsumesEvent_To();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONSUMES_EVENT__FROM = eINSTANCE.getConsumesEvent_From();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.NextStateImpl <em>Next State</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.NextStateImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getNextState()
		 * @generated
		 */
		EClass NEXT_STATE = eINSTANCE.getNextState();

		/**
		 * The meta object literal for the '<em><b>To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NEXT_STATE__TO = eINSTANCE.getNextState_To();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NEXT_STATE__FROM = eINSTANCE.getNextState_From();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.InitialStateImpl <em>Initial State</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.InitialStateImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getInitialState()
		 * @generated
		 */
		EClass INITIAL_STATE = eINSTANCE.getInitialState();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.EventElementImpl <em>Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventElementImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getEventElement()
		 * @generated
		 */
		EClass EVENT_ELEMENT = eINSTANCE.getEventElement();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.omg.kdm.event.impl.HasStateImpl <em>Has State</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.HasStateImpl
		 * @see org.eclipse.gmt.modisco.omg.kdm.event.impl.EventPackageImpl#getHasState()
		 * @generated
		 */
		EClass HAS_STATE = eINSTANCE.getHasState();

		/**
		 * The meta object literal for the '<em><b>To</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HAS_STATE__TO = eINSTANCE.getHasState_To();

		/**
		 * The meta object literal for the '<em><b>From</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HAS_STATE__FROM = eINSTANCE.getHasState_From();

	}

} //EventPackage
