/**
 * 
 * Copyright (c) 2009 Hatha Systems.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.gmt.modisco.omg.kdm.kdm;

import org.eclipse.emf.common.util.EList;

import org.eclipse.gmt.modisco.omg.kdm.core.ModelElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>KDM Framework</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.kdm.KDMFramework#getAudit <em>Audit</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.kdm.KDMFramework#getExtensionFamily <em>Extension Family</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.kdm.KDMFramework#getName <em>Name</em>}</li>
 * </ul>
 *
 * @see org.eclipse.gmt.modisco.omg.kdm.kdm.KdmPackage#getKDMFramework()
 * @model interface="true" abstract="true"
 * @generated
 */
public interface KDMFramework extends ModelElement {
	/**
	 * Returns the value of the '<em><b>Audit</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.gmt.modisco.omg.kdm.kdm.Audit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Audit</em>' containment reference list.
	 * @see org.eclipse.gmt.modisco.omg.kdm.kdm.KdmPackage#getKDMFramework_Audit()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<Audit> getAudit();

	/**
	 * Returns the value of the '<em><b>Extension Family</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.gmt.modisco.omg.kdm.kdm.ExtensionFamily}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Extension Family</em>' containment reference list.
	 * @see org.eclipse.gmt.modisco.omg.kdm.kdm.KdmPackage#getKDMFramework_ExtensionFamily()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<ExtensionFamily> getExtensionFamily();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.gmt.modisco.omg.kdm.kdm.KdmPackage#getKDMFramework_Name()
	 * @model unique="false" dataType="org.eclipse.gmt.modisco.omg.kdm.core.String"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.omg.kdm.kdm.KDMFramework#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

} // KDMFramework
