/**
 * 
 * Copyright (c) 2009 Hatha Systems.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.gmt.modisco.omg.kdm.source;

import org.eclipse.emf.common.util.EList;

import org.eclipse.gmt.modisco.omg.kdm.core.Element;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Ref</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRef#getRegion <em>Region</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRef#getLanguage <em>Language</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRef#getSnippet <em>Snippet</em>}</li>
 * </ul>
 *
 * @see org.eclipse.gmt.modisco.omg.kdm.source.SourcePackage#getSourceRef()
 * @model
 * @generated
 */
public interface SourceRef extends Element {
	/**
	 * Returns the value of the '<em><b>Region</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRegion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Region</em>' containment reference list.
	 * @see org.eclipse.gmt.modisco.omg.kdm.source.SourcePackage#getSourceRef_Region()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<SourceRegion> getRegion();

	/**
	 * Returns the value of the '<em><b>Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Language</em>' attribute.
	 * @see #setLanguage(String)
	 * @see org.eclipse.gmt.modisco.omg.kdm.source.SourcePackage#getSourceRef_Language()
	 * @model unique="false" dataType="org.eclipse.gmt.modisco.omg.kdm.core.String"
	 * @generated
	 */
	String getLanguage();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRef#getLanguage <em>Language</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Language</em>' attribute.
	 * @see #getLanguage()
	 * @generated
	 */
	void setLanguage(String value);

	/**
	 * Returns the value of the '<em><b>Snippet</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Snippet</em>' attribute.
	 * @see #setSnippet(String)
	 * @see org.eclipse.gmt.modisco.omg.kdm.source.SourcePackage#getSourceRef_Snippet()
	 * @model unique="false" dataType="org.eclipse.gmt.modisco.omg.kdm.core.String"
	 * @generated
	 */
	String getSnippet();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.omg.kdm.source.SourceRef#getSnippet <em>Snippet</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Snippet</em>' attribute.
	 * @see #getSnippet()
	 * @generated
	 */
	void setSnippet(String value);

} // SourceRef
