/**
 * 
 * Copyright (c) 2009 Hatha Systems.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nikolai Mansourov (Hatha Systems) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - minor evolutions for version 1.1
 */
package org.eclipse.gmt.modisco.omg.kdm.source.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.gmt.modisco.omg.kdm.core.AggregatedRelationship;
import org.eclipse.gmt.modisco.omg.kdm.core.KDMEntity;
import org.eclipse.gmt.modisco.omg.kdm.core.KDMRelationship;

import org.eclipse.gmt.modisco.omg.kdm.kdm.Annotation;
import org.eclipse.gmt.modisco.omg.kdm.kdm.Attribute;
import org.eclipse.gmt.modisco.omg.kdm.kdm.ExtendedValue;
import org.eclipse.gmt.modisco.omg.kdm.kdm.KDMModel;
import org.eclipse.gmt.modisco.omg.kdm.kdm.Stereotype;

import org.eclipse.gmt.modisco.omg.kdm.source.AbstractInventoryElement;
import org.eclipse.gmt.modisco.omg.kdm.source.AbstractInventoryRelationship;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryContainer;
import org.eclipse.gmt.modisco.omg.kdm.source.SourcePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Inventory Container</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.impl.InventoryContainerImpl#getAttribute <em>Attribute</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.impl.InventoryContainerImpl#getAnnotation <em>Annotation</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.impl.InventoryContainerImpl#getStereotype <em>Stereotype</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.impl.InventoryContainerImpl#getTaggedValue <em>Tagged Value</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.impl.InventoryContainerImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.impl.InventoryContainerImpl#getInventoryRelation <em>Inventory Relation</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.omg.kdm.source.impl.InventoryContainerImpl#getInventoryElement <em>Inventory Element</em>}</li>
 * </ul>
 *
 * @generated
 */
public class InventoryContainerImpl extends MinimalEObjectImpl.Container implements InventoryContainer {
	/**
	 * The cached value of the '{@link #getAttribute() <em>Attribute</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttribute()
	 * @generated
	 * @ordered
	 */
	protected EList<Attribute> attribute;

	/**
	 * The cached value of the '{@link #getAnnotation() <em>Annotation</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotation()
	 * @generated
	 * @ordered
	 */
	protected EList<Annotation> annotation;

	/**
	 * The cached value of the '{@link #getStereotype() <em>Stereotype</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStereotype()
	 * @generated
	 * @ordered
	 */
	protected EList<Stereotype> stereotype;

	/**
	 * The cached value of the '{@link #getTaggedValue() <em>Tagged Value</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTaggedValue()
	 * @generated
	 * @ordered
	 */
	protected EList<ExtendedValue> taggedValue;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInventoryRelation() <em>Inventory Relation</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInventoryRelation()
	 * @generated
	 * @ordered
	 */
	protected EList<AbstractInventoryRelationship> inventoryRelation;

	/**
	 * The cached value of the '{@link #getInventoryElement() <em>Inventory Element</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInventoryElement()
	 * @generated
	 * @ordered
	 */
	protected EList<AbstractInventoryElement> inventoryElement;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InventoryContainerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SourcePackage.Literals.INVENTORY_CONTAINER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Attribute> getAttribute() {
		if (attribute == null) {
			attribute = new EObjectContainmentEList<Attribute>(Attribute.class, this, SourcePackage.INVENTORY_CONTAINER__ATTRIBUTE);
		}
		return attribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Annotation> getAnnotation() {
		if (annotation == null) {
			annotation = new EObjectContainmentEList<Annotation>(Annotation.class, this, SourcePackage.INVENTORY_CONTAINER__ANNOTATION);
		}
		return annotation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Stereotype> getStereotype() {
		if (stereotype == null) {
			stereotype = new EObjectResolvingEList<Stereotype>(Stereotype.class, this, SourcePackage.INVENTORY_CONTAINER__STEREOTYPE);
		}
		return stereotype;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ExtendedValue> getTaggedValue() {
		if (taggedValue == null) {
			taggedValue = new EObjectContainmentEList<ExtendedValue>(ExtendedValue.class, this, SourcePackage.INVENTORY_CONTAINER__TAGGED_VALUE);
		}
		return taggedValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SourcePackage.INVENTORY_CONTAINER__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AbstractInventoryRelationship> getInventoryRelation() {
		if (inventoryRelation == null) {
			inventoryRelation = new EObjectContainmentEList<AbstractInventoryRelationship>(AbstractInventoryRelationship.class, this, SourcePackage.INVENTORY_CONTAINER__INVENTORY_RELATION);
		}
		return inventoryRelation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AbstractInventoryElement> getInventoryElement() {
		if (inventoryElement == null) {
			inventoryElement = new EObjectContainmentEList<AbstractInventoryElement>(AbstractInventoryElement.class, this, SourcePackage.INVENTORY_CONTAINER__INVENTORY_ELEMENT);
		}
		return inventoryElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createAggregation(KDMEntity otherEntity) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void deleteAggregation(AggregatedRelationship aggregation) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMRelationship> getInbound() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMRelationship> getOutbound() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMRelationship> getOwnedRelation() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AggregatedRelationship> getInAggregated() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AggregatedRelationship> getOutAggregated() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMEntity getOwner() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMEntity> getOwnedElement() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMEntity> getGroup() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<KDMEntity> getGroupedElement() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public KDMModel getModel() {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case SourcePackage.INVENTORY_CONTAINER__ATTRIBUTE:
				return ((InternalEList<?>)getAttribute()).basicRemove(otherEnd, msgs);
			case SourcePackage.INVENTORY_CONTAINER__ANNOTATION:
				return ((InternalEList<?>)getAnnotation()).basicRemove(otherEnd, msgs);
			case SourcePackage.INVENTORY_CONTAINER__TAGGED_VALUE:
				return ((InternalEList<?>)getTaggedValue()).basicRemove(otherEnd, msgs);
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_RELATION:
				return ((InternalEList<?>)getInventoryRelation()).basicRemove(otherEnd, msgs);
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_ELEMENT:
				return ((InternalEList<?>)getInventoryElement()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SourcePackage.INVENTORY_CONTAINER__ATTRIBUTE:
				return getAttribute();
			case SourcePackage.INVENTORY_CONTAINER__ANNOTATION:
				return getAnnotation();
			case SourcePackage.INVENTORY_CONTAINER__STEREOTYPE:
				return getStereotype();
			case SourcePackage.INVENTORY_CONTAINER__TAGGED_VALUE:
				return getTaggedValue();
			case SourcePackage.INVENTORY_CONTAINER__NAME:
				return getName();
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_RELATION:
				return getInventoryRelation();
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_ELEMENT:
				return getInventoryElement();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SourcePackage.INVENTORY_CONTAINER__ATTRIBUTE:
				getAttribute().clear();
				getAttribute().addAll((Collection<? extends Attribute>)newValue);
				return;
			case SourcePackage.INVENTORY_CONTAINER__ANNOTATION:
				getAnnotation().clear();
				getAnnotation().addAll((Collection<? extends Annotation>)newValue);
				return;
			case SourcePackage.INVENTORY_CONTAINER__STEREOTYPE:
				getStereotype().clear();
				getStereotype().addAll((Collection<? extends Stereotype>)newValue);
				return;
			case SourcePackage.INVENTORY_CONTAINER__TAGGED_VALUE:
				getTaggedValue().clear();
				getTaggedValue().addAll((Collection<? extends ExtendedValue>)newValue);
				return;
			case SourcePackage.INVENTORY_CONTAINER__NAME:
				setName((String)newValue);
				return;
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_RELATION:
				getInventoryRelation().clear();
				getInventoryRelation().addAll((Collection<? extends AbstractInventoryRelationship>)newValue);
				return;
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_ELEMENT:
				getInventoryElement().clear();
				getInventoryElement().addAll((Collection<? extends AbstractInventoryElement>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SourcePackage.INVENTORY_CONTAINER__ATTRIBUTE:
				getAttribute().clear();
				return;
			case SourcePackage.INVENTORY_CONTAINER__ANNOTATION:
				getAnnotation().clear();
				return;
			case SourcePackage.INVENTORY_CONTAINER__STEREOTYPE:
				getStereotype().clear();
				return;
			case SourcePackage.INVENTORY_CONTAINER__TAGGED_VALUE:
				getTaggedValue().clear();
				return;
			case SourcePackage.INVENTORY_CONTAINER__NAME:
				setName(NAME_EDEFAULT);
				return;
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_RELATION:
				getInventoryRelation().clear();
				return;
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_ELEMENT:
				getInventoryElement().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SourcePackage.INVENTORY_CONTAINER__ATTRIBUTE:
				return attribute != null && !attribute.isEmpty();
			case SourcePackage.INVENTORY_CONTAINER__ANNOTATION:
				return annotation != null && !annotation.isEmpty();
			case SourcePackage.INVENTORY_CONTAINER__STEREOTYPE:
				return stereotype != null && !stereotype.isEmpty();
			case SourcePackage.INVENTORY_CONTAINER__TAGGED_VALUE:
				return taggedValue != null && !taggedValue.isEmpty();
			case SourcePackage.INVENTORY_CONTAINER__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_RELATION:
				return inventoryRelation != null && !inventoryRelation.isEmpty();
			case SourcePackage.INVENTORY_CONTAINER__INVENTORY_ELEMENT:
				return inventoryElement != null && !inventoryElement.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
		switch (operationID) {
			case SourcePackage.INVENTORY_CONTAINER___CREATE_AGGREGATION__KDMENTITY:
				createAggregation((KDMEntity)arguments.get(0));
				return null;
			case SourcePackage.INVENTORY_CONTAINER___DELETE_AGGREGATION__AGGREGATEDRELATIONSHIP:
				deleteAggregation((AggregatedRelationship)arguments.get(0));
				return null;
			case SourcePackage.INVENTORY_CONTAINER___GET_INBOUND:
				return getInbound();
			case SourcePackage.INVENTORY_CONTAINER___GET_OUTBOUND:
				return getOutbound();
			case SourcePackage.INVENTORY_CONTAINER___GET_OWNED_RELATION:
				return getOwnedRelation();
			case SourcePackage.INVENTORY_CONTAINER___GET_IN_AGGREGATED:
				return getInAggregated();
			case SourcePackage.INVENTORY_CONTAINER___GET_OUT_AGGREGATED:
				return getOutAggregated();
			case SourcePackage.INVENTORY_CONTAINER___GET_OWNER:
				return getOwner();
			case SourcePackage.INVENTORY_CONTAINER___GET_OWNED_ELEMENT:
				return getOwnedElement();
			case SourcePackage.INVENTORY_CONTAINER___GET_GROUP:
				return getGroup();
			case SourcePackage.INVENTORY_CONTAINER___GET_GROUPED_ELEMENT:
				return getGroupedElement();
			case SourcePackage.INVENTORY_CONTAINER___GET_MODEL:
				return getModel();
		}
		return super.eInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: "); //$NON-NLS-1$
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //InventoryContainerImpl
