/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.omg.kdm.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MacroKind implements Enumerator
{
    REGULAR(0, "regular", "regular"),
    OPTION(1, "option", "option"),
    UNDEFINED(2, "undefined", "undefined"),
    EXTERNAL(3, "external", "external"),
    UNKNOWN(4, "unknown", "unknown");

    public static final int REGULAR_VALUE = 0;
    public static final int OPTION_VALUE = 1;
    public static final int UNDEFINED_VALUE = 2;
    public static final int EXTERNAL_VALUE = 3;
    public static final int UNKNOWN_VALUE = 4;
    private static final MacroKind[] VALUES_ARRAY;
    public static final List<MacroKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static MacroKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MacroKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static MacroKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MacroKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static MacroKind get(int value) {
        switch (value) {
            case 0: {
                return REGULAR;
            }
            case 1: {
                return OPTION;
            }
            case 2: {
                return UNDEFINED;
            }
            case 3: {
                return EXTERNAL;
            }
            case 4: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private MacroKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new MacroKind[]{REGULAR, OPTION, UNDEFINED, EXTERNAL, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

