/**
 */
package org.atlanmod.zoo.socialnetwork;

import org.atlanmod.SerializableEObject;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>User</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.atlanmod.zoo.socialnetwork.User#getId <em>Id</em>}</li>
 *   <li>{@link org.atlanmod.zoo.socialnetwork.User#getName <em>Name</em>}</li>
 *   <li>{@link org.atlanmod.zoo.socialnetwork.User#getSubmissions <em>Submissions</em>}</li>
 *   <li>{@link org.atlanmod.zoo.socialnetwork.User#getLikes <em>Likes</em>}</li>
 *   <li>{@link org.atlanmod.zoo.socialnetwork.User#getFriends <em>Friends</em>}</li>
 * </ul>
 *
 * @see org.atlanmod.zoo.socialnetwork.SocialNetworkPackage#getUser()
 * @model
 * @extends SerializableEObject
 * @generated
 */
public interface User extends SerializableEObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.atlanmod.zoo.socialnetwork.SocialNetworkPackage#getUser_Id()
	 * @model unique="false" id="true" required="true" ordered="false"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.atlanmod.zoo.socialnetwork.User#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.atlanmod.zoo.socialnetwork.SocialNetworkPackage#getUser_Name()
	 * @model unique="false" required="true" ordered="false"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.atlanmod.zoo.socialnetwork.User#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Submissions</b></em>' reference list.
	 * The list contents are of type {@link org.atlanmod.zoo.socialnetwork.Submission}.
	 * It is bidirectional and its opposite is '{@link org.atlanmod.zoo.socialnetwork.Submission#getSubmitter <em>Submitter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Submissions</em>' reference list.
	 * @see org.atlanmod.zoo.socialnetwork.SocialNetworkPackage#getUser_Submissions()
	 * @see org.atlanmod.zoo.socialnetwork.Submission#getSubmitter
	 * @model opposite="submitter" ordered="false"
	 * @generated
	 */
	EList<Submission> getSubmissions();

	/**
	 * Returns the value of the '<em><b>Likes</b></em>' reference list.
	 * The list contents are of type {@link org.atlanmod.zoo.socialnetwork.Comment}.
	 * It is bidirectional and its opposite is '{@link org.atlanmod.zoo.socialnetwork.Comment#getLikedBy <em>Liked By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Likes</em>' reference list.
	 * @see org.atlanmod.zoo.socialnetwork.SocialNetworkPackage#getUser_Likes()
	 * @see org.atlanmod.zoo.socialnetwork.Comment#getLikedBy
	 * @model opposite="likedBy" ordered="false"
	 * @generated
	 */
	EList<Comment> getLikes();

	/**
	 * Returns the value of the '<em><b>Friends</b></em>' reference list.
	 * The list contents are of type {@link org.atlanmod.zoo.socialnetwork.User}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Friends</em>' reference list.
	 * @see org.atlanmod.zoo.socialnetwork.SocialNetworkPackage#getUser_Friends()
	 * @model ordered="false"
	 * @generated
	 */
	EList<User> getFriends();

} // User
