/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VisibilityKind implements Enumerator
{
    NONE(1, "none", "none"),
    PUBLIC(2, "public", "public"),
    PRIVATE(3, "private", "private"),
    PROTECTED(4, "protected", "protected");

    public static final int NONE_VALUE = 1;
    public static final int PUBLIC_VALUE = 2;
    public static final int PRIVATE_VALUE = 3;
    public static final int PROTECTED_VALUE = 4;
    private static final VisibilityKind[] VALUES_ARRAY;
    public static final List<VisibilityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static VisibilityKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            VisibilityKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static VisibilityKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            VisibilityKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static VisibilityKind get(int value) {
        switch (value) {
            case 1: {
                return NONE;
            }
            case 2: {
                return PUBLIC;
            }
            case 3: {
                return PRIVATE;
            }
            case 4: {
                return PROTECTED;
            }
        }
        return null;
    }

    private VisibilityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new VisibilityKind[]{NONE, PUBLIC, PRIVATE, PROTECTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

