/*
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2007-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 */

// ========================================================================
// Copyright 2006 Mort Bay Consulting Pty. Ltd.
// ------------------------------------------------------------------------
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at 
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ========================================================================

package org.atmosphere.plugin.bayeux;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.cometd.server.ClientImpl;
import org.eclipse.jetty.util.thread.Timeout;

/* ------------------------------------------------------------ */
/**
 * Extension of {@link ClientImpl} that uses {@link Continuation}s to
 * resume clients waiting for messages. Continuation clients are used for
 * remote clients and have removed if they are not accessed within
 * an idle timeout (@link {@link AtmosphereContinuationBayeux#_clientTimer}).
 * 
 * @author gregw
 *
 */
public class AtmosphereBayeuxClient extends ClientImpl
{
    private long _accessed;
    public transient Timeout.Task _timeout;
    private AtmosphereContinuationBayeux _bayeux;
    private transient AtmosphereEvent<HttpServletRequest, HttpServletResponse> _event;

    /* ------------------------------------------------------------ */
    protected AtmosphereBayeuxClient(AtmosphereContinuationBayeux bayeux)
    {
        super(bayeux);
        _bayeux=bayeux;

        if (!isLocal())
        {
            _timeout=new Timeout.Task()
            {
                @Override
                public void expired()
                {
                    remove(true);
                }
                @Override
                public String toString()
                {
                    return "T-"+AtmosphereBayeuxClient.this.toString();
                }
            };
            _bayeux.startTimeout(_timeout,getTimeout());
        }
    }


    /* ------------------------------------------------------------ */
    public void setAtmosphereEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event)
    {
        if (event==null)
        {
            synchronized (this)
            {
                if (_event!=null)
                    _event.resume();
                _event=null;
                if(_timeout!=null)
                    _bayeux.startTimeout(_timeout,getTimeout());
            }
        }
        else
        {
            synchronized (this)
            {
                if (_event!=null)
                    _event.resume();
                _event=event;

                _bayeux.cancelTimeout(_timeout);
            }
        }
    }

    /* ------------------------------------------------------------ */
    public AtmosphereEvent getAtmosphereEvent()
    {
        return _event;
    }

    /* ------------------------------------------------------------ */
    @Override
    public void resume()
    {
        synchronized (this)
        {
            if (_event!=null)
            {
                _event.resume();
            }
            _event=null;
        }
    }

   /* ------------------------------------------------------------ */
    @Override
    public boolean isLocal()
    {
        return false;
    }

    /* ------------------------------------------------------------ */
    public void access()
    {
        synchronized(this)
        {
            // distribute access time in cluster
            _accessed=_bayeux.getNow();
            if (_timeout!=null && _timeout.isScheduled())
            {
                _timeout.reschedule();
            }
        }
    }


    /* ------------------------------------------------------------ */
    public synchronized long lastAccessed()
    {
        return _accessed;
    }

    /* ------------------------------------------------------------ */
    /* (non-Javadoc)
     * @see org.cometd.server.ClientImpl#remove(boolean)
     */
    @Override
    public void remove(boolean wasTimeout)
    {
        synchronized(this)
        {
            if (!wasTimeout && _timeout!=null)
                _bayeux.cancelTimeout(_timeout);
            _timeout=null;
        }
        super.remove(wasTimeout);
    }

}
