/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.bayeux;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.plugin.bayeux.AtmosphereContinuationBayeux;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.ClientImpl;
import org.eclipse.jetty.util.thread.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereBayeuxClient
extends ClientImpl {
    private long _accessed;
    public transient Timeout.Task _timeout;
    private AtmosphereContinuationBayeux _bayeux;
    private transient AtmosphereEvent<HttpServletRequest, HttpServletResponse> _event;

    protected AtmosphereBayeuxClient(AtmosphereContinuationBayeux bayeux) {
        super((AbstractBayeux)bayeux);
        this._bayeux = bayeux;
        if (!this.isLocal()) {
            this._timeout = new Timeout.Task(){

                public void expired() {
                    AtmosphereBayeuxClient.this.remove(true);
                }

                public String toString() {
                    return "T-" + AtmosphereBayeuxClient.this.toString();
                }
            };
            this._bayeux.startTimeout(this._timeout, this.getTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtmosphereEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) {
        if (event == null) {
            AtmosphereBayeuxClient atmosphereBayeuxClient = this;
            synchronized (atmosphereBayeuxClient) {
                if (this._event != null) {
                    this._event.resume();
                }
                this._event = null;
                if (this._timeout != null) {
                    this._bayeux.startTimeout(this._timeout, this.getTimeout());
                }
            }
        }
        AtmosphereBayeuxClient atmosphereBayeuxClient = this;
        synchronized (atmosphereBayeuxClient) {
            if (this._event != null) {
                this._event.resume();
            }
            this._event = event;
            this._bayeux.cancelTimeout(this._timeout);
        }
    }

    public AtmosphereEvent getAtmosphereEvent() {
        return this._event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        AtmosphereBayeuxClient atmosphereBayeuxClient = this;
        synchronized (atmosphereBayeuxClient) {
            if (this._event != null) {
                this._event.resume();
            }
            this._event = null;
        }
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        AtmosphereBayeuxClient atmosphereBayeuxClient = this;
        synchronized (atmosphereBayeuxClient) {
            this._accessed = this._bayeux.getNow();
            if (this._timeout != null && this._timeout.isScheduled()) {
                this._timeout.reschedule();
            }
        }
    }

    public synchronized long lastAccessed() {
        return this._accessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean wasTimeout) {
        AtmosphereBayeuxClient atmosphereBayeuxClient = this;
        synchronized (atmosphereBayeuxClient) {
            if (!wasTimeout && this._timeout != null) {
                this._bayeux.cancelTimeout(this._timeout);
            }
            this._timeout = null;
        }
        super.remove(wasTimeout);
    }
}

