/*
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2007-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 */


// ========================================================================
// Copyright 2006 Mort Bay Consulting Pty. Ltd.
// ------------------------------------------------------------------------
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at 
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//========================================================================

package org.atmosphere.plugin.bayeux;

import java.util.Timer;
import java.util.TimerTask;

import javax.servlet.ServletContext;
import org.cometd.server.continuation.ContinuationBayeux;
import org.cometd.server.ClientImpl;
import org.eclipse.jetty.util.thread.Timeout;

/* ------------------------------------------------------------ */
/**
 * Extension of Bayeux that uses {@link AtmosphereBayeuxClient}s.
 * @author gregw
 *
 * @author Jeanfrancois Arcand
 *
 */
public class AtmosphereContinuationBayeux extends ContinuationBayeux
{
    private static int __id;
    private transient Timer _tick;
    private transient Timeout _timeout;
    private long _now;
    
    
    /* ------------------------------------------------------------ */
    /* (non-Javadoc)
     * @see org.cometd.server.AbstractBayeux#newClient(java.lang.String, dojox.io.cometd.Destination)
     */
    @Override
    public ClientImpl newRemoteClient()
    {
        return new AtmosphereBayeuxClient(this);
    }


    /* ------------------------------------------------------------ */
    /* (non-Javadoc)
     * @see org.cometd.server.AbstractBayeux#initialize(javax.servlet.ServletContext)
     */
    @Override
    protected void initialize(ServletContext context)
    {
        super.initialize(context);
        
        _tick=new Timer("ContinuationBayeux-"+__id++, true);
        _timeout=new Timeout();
        _timeout.setDuration(getMaxInterval());
    
        _tick.schedule(new TimerTask()
        {
            @Override
            public void run()
            {
                _now=System.currentTimeMillis();
                _timeout.tick(_now);
            }
        },500L,500L);
    }

    /* ------------------------------------------------------------ */
    long getNow()
    {
        return _now;
    }
    
    /* ------------------------------------------------------------ */
    @Override
	public void setMaxInterval(long ms)
    {
        _timeout.setDuration(ms);
        super.setMaxInterval(ms);
    }

    /* ------------------------------------------------------------ */
    /* (non-Javadoc)
     * @see org.cometd.server.AbstractBayeux#initialize(javax.servlet.ServletContext)
     */
    @Override
    public void destroy()
    {
        _tick.cancel();
    }

    /* ------------------------------------------------------------ */
    void startTimeout(Timeout.Task timeout,long delay)
    {
        synchronized(_timeout)
        {
            if (delay==0)
                _timeout.schedule(timeout);
            else
                _timeout.schedule(timeout,delay);
        }
    }

    /* ------------------------------------------------------------ */
    @Override
    public void cancelTimeout(Timeout.Task timeout)
    {
        synchronized(_timeout)
        {
            if (timeout!=null)
                timeout.cancel();
        }
    }
    
}
