/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.bayeux;

import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import org.atmosphere.plugin.bayeux.AtmosphereBayeuxClient;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.ClientImpl;
import org.eclipse.jetty.util.thread.Timeout;

public class AtmosphereContinuationBayeux
extends AbstractBayeux {
    private static int __id;
    private transient Timer _tick;
    private transient Timeout _timeout;
    private long _now;

    public ClientImpl newRemoteClient() {
        return new AtmosphereBayeuxClient(this);
    }

    protected void initialize(ServletContext context) {
        super.initialize(context);
        this._tick = new Timer("AtmosphereBayeuxClient-" + __id++, true);
        this._timeout = new Timeout();
        this._tick.schedule(new TimerTask(){

            public void run() {
                AtmosphereContinuationBayeux.this._now = System.currentTimeMillis();
                AtmosphereContinuationBayeux.this._timeout.tick(AtmosphereContinuationBayeux.this._now);
            }
        }, 100L, 100L);
    }

    long getNow() {
        return this._now;
    }

    public void destroy() {
        this._tick.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTimeout(Timeout.Task timeout, long interval) {
        Timeout timeout2 = this._timeout;
        synchronized (timeout2) {
            this._timeout.schedule(timeout, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelTimeout(Timeout.Task timeout) {
        Timeout timeout2 = this._timeout;
        synchronized (timeout2) {
            if (timeout != null) {
                timeout.cancel();
            }
        }
    }
}

