/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.bayeux;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.plugin.bayeux.AtmosphereContinuationBayeux;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.ClientImpl;
import org.eclipse.jetty.util.thread.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereBayeuxClient
extends ClientImpl {
    private final AtmosphereContinuationBayeux _bayeux;
    private final Timeout.Task _intervalTimeoutTask;
    private final Timeout.Task _lazyTimeoutTask;
    private long _accessed;
    private volatile AtmosphereResource<HttpServletRequest, HttpServletResponse> _continuation;
    private volatile boolean _lazyResuming;

    protected AtmosphereBayeuxClient(AtmosphereContinuationBayeux bayeux) {
        super((AbstractBayeux)bayeux);
        this._bayeux = bayeux;
        if (this.isLocal()) {
            this._intervalTimeoutTask = null;
            this._lazyTimeoutTask = null;
        } else {
            this._intervalTimeoutTask = new Timeout.Task(){

                public void expired() {
                    AtmosphereBayeuxClient.this.remove(true);
                }

                public String toString() {
                    return "T-" + AtmosphereBayeuxClient.this.toString();
                }
            };
            this._lazyTimeoutTask = new Timeout.Task(){

                public void expired() {
                    AtmosphereBayeuxClient.this._lazyResuming = false;
                    if (AtmosphereBayeuxClient.this.hasMessages()) {
                        AtmosphereBayeuxClient.this.resume();
                    }
                }

                public String toString() {
                    return "L-" + AtmosphereBayeuxClient.this.toString();
                }
            };
            this._bayeux.startTimeout(this._intervalTimeoutTask, this._bayeux.getMaxInterval());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContinuation(AtmosphereResource<HttpServletRequest, HttpServletResponse> continuation) {
        if (continuation == null) {
            AtmosphereBayeuxClient atmosphereBayeuxClient = this;
            synchronized (atmosphereBayeuxClient) {
                this._continuation = null;
                if (this._intervalTimeoutTask != null) {
                    this._bayeux.startTimeout(this._intervalTimeoutTask, this._bayeux.getMaxInterval());
                }
            }
        }
        AtmosphereBayeuxClient atmosphereBayeuxClient = this;
        synchronized (atmosphereBayeuxClient) {
            if (this._continuation != null) {
                this._continuation.resume();
            }
            this._continuation = continuation;
            this._bayeux.cancelTimeout(this._intervalTimeoutTask);
            this._accessed = this._bayeux.getNow();
        }
    }

    public AtmosphereResource<HttpServletRequest, HttpServletResponse> getContinuation() {
        return this._continuation;
    }

    public void lazyResume() {
        int max = this._bayeux.getMaxLazyLatency();
        if (max > 0 && this._lazyTimeoutTask != null && !this._lazyResuming) {
            this._lazyResuming = true;
            this._bayeux.startTimeout(this._lazyTimeoutTask, this._accessed % (long)max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        AtmosphereBayeuxClient atmosphereBayeuxClient = this;
        synchronized (atmosphereBayeuxClient) {
            if (this._continuation != null) {
                this._continuation.resume();
            }
            this._continuation = null;
        }
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        AtmosphereBayeuxClient atmosphereBayeuxClient = this;
        synchronized (atmosphereBayeuxClient) {
            this._accessed = this._bayeux.getNow();
            if (this._intervalTimeoutTask != null && this._intervalTimeoutTask.isScheduled()) {
                this._intervalTimeoutTask.reschedule();
            }
        }
    }

    public synchronized long lastAccessed() {
        return this._accessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean wasTimeout) {
        AtmosphereBayeuxClient atmosphereBayeuxClient = this;
        synchronized (atmosphereBayeuxClient) {
            if (!wasTimeout && this._intervalTimeoutTask != null) {
                this._bayeux.cancelTimeout(this._intervalTimeoutTask);
            }
        }
        super.remove(wasTimeout);
    }
}

