/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.plugin.bayeux;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.plugin.bayeux.AtmosphereBayeuxClient;
import org.atmosphere.plugin.bayeux.AtmosphereContinuationBayeux;
import org.cometd.Client;
import org.cometd.Message;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.AbstractCometdServlet;
import org.cometd.server.ClientImpl;
import org.cometd.server.JSONTransport;
import org.cometd.server.MessageImpl;
import org.cometd.server.Transport;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.log.Log;

public class AtmosphereBayeuxServlet
extends AbstractCometdServlet {
    public static final int __DEFAULT_REFS_THRESHOLD = 0;
    protected int _refsThreshold = 0;
    String _responseBuffer;

    public void init() throws ServletException {
        String refsThreshold = this.getInitParameter("refsThreshold");
        if (refsThreshold != null) {
            this._refsThreshold = Integer.parseInt(refsThreshold);
        }
        if (this._refsThreshold > 0) {
            String server = this.getServletContext().getServerInfo();
            if (server.startsWith("jetty/6")) {
                this._responseBuffer = "org.mortbay.jetty.ResponseBuffer";
            } else if (server.startsWith("jetty/")) {
                this._responseBuffer = "org.eclipse.jetty.server.ResponseBuffer";
            } else {
                this._refsThreshold = 0;
            }
        }
        super.init();
    }

    protected AbstractBayeux newBayeux() {
        return new AtmosphereContinuationBayeux();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean initial;
        AtmosphereBayeuxClient client;
        Object clientObj = request.getAttribute("org.cometd.server.client");
        Transport transport = null;
        int received = -1;
        boolean metaConnectDeliveryOnly = false;
        boolean pendingResponse = false;
        boolean metaConnect = false;
        AtmosphereBayeuxClient atmosphereBayeuxClient = client = clientObj instanceof ClientImpl ? (AtmosphereBayeuxClient)((Object)clientObj) : null;
        if (client != null) {
            initial = false;
            transport = (Transport)request.getAttribute("org.cometd.server.transport");
            transport.setResponse(response);
            metaConnectDeliveryOnly = client.isMetaConnectDeliveryOnly() || transport.isMetaConnectDeliveryOnly();
            metaConnect = true;
        } else {
            initial = true;
            Message[] messages = this.getMessages(request);
            received = messages.length;
            String jsonpParam = request.getParameter("jsonp");
            try {
                for (Message message : messages) {
                    String clientId;
                    if (jsonpParam != null) {
                        message.put((Object)"jsonp", (Object)jsonpParam);
                    }
                    if (client == null && (client = (AtmosphereBayeuxClient)this._bayeux.getClient(clientId = (String)message.get((Object)"clientId"))) == null) {
                        String browser_id = this.findBrowserId(request);
                        if (browser_id == null) {
                            browser_id = this.setBrowserId(request, response);
                        }
                        if (transport == null) {
                            transport = this._bayeux.newTransport((ClientImpl)client, (Map)message);
                            transport.setResponse(response);
                            metaConnectDeliveryOnly = transport.isMetaConnectDeliveryOnly();
                        }
                        this._bayeux.handle(null, transport, message);
                        message = null;
                        continue;
                    }
                    String browser_id = this.findBrowserId(request);
                    if (!(browser_id == null || client.getBrowserId() != null && client.getBrowserId().equals(browser_id))) {
                        client.setBrowserId(browser_id);
                    }
                    if (transport == null) {
                        transport = this._bayeux.newTransport((ClientImpl)client, (Map)message);
                        transport.setResponse(response);
                        boolean bl = metaConnectDeliveryOnly = client.isMetaConnectDeliveryOnly() || transport.isMetaConnectDeliveryOnly();
                    }
                    if (!metaConnectDeliveryOnly && !pendingResponse) {
                        pendingResponse = true;
                        client.responsePending();
                    }
                    if ("/meta/connect".equals(message.getChannel())) {
                        metaConnect = true;
                    }
                    this._bayeux.handle((ClientImpl)client, transport, message);
                }
            }
            finally {
                for (Message message : messages) {
                    ((MessageImpl)message).decRef();
                }
                if (pendingResponse) {
                    client.responded();
                }
            }
        }
        Message metaConnectReply = null;
        if (transport != null) {
            metaConnectReply = transport.getMetaConnectReply();
            if (metaConnectReply != null) {
                long timeout = client.getTimeout();
                if (timeout == 0L) {
                    timeout = this._bayeux.getTimeout();
                }
                AtmosphereResource continuation = (AtmosphereResource)request.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
                AtmosphereBayeuxClient i$ = client;
                synchronized (i$) {
                    if (!client.hasNonLazyMessages() && initial && received <= 1) {
                        request.setAttribute("org.cometd.server.client", (Object)client);
                        request.setAttribute("org.cometd.server.transport", (Object)transport);
                        continuation.suspend(timeout, false);
                        client.setContinuation(continuation);
                        return;
                    }
                }
                client.setContinuation(null);
                transport.setMetaConnectReply(null);
            } else if (client != null) {
                client.access();
            }
        }
        if (client != null) {
            if (metaConnectDeliveryOnly && !metaConnect) {
                client.resume();
            } else {
                ArrayList messages;
                AtmosphereBayeuxClient atmosphereBayeuxClient2 = client;
                synchronized (atmosphereBayeuxClient2) {
                    client.doDeliverListeners();
                    ArrayQueue clientMessages = (ArrayQueue)client.getQueue();
                    messages = new ArrayList(clientMessages);
                    clientMessages.clear();
                }
                int n = messages.size();
                for (int i = 0; i < n; ++i) {
                    MessageImpl mesgImpl;
                    Message message = (Message)messages.get(i);
                    MessageImpl messageImpl = mesgImpl = message instanceof MessageImpl ? (MessageImpl)message : null;
                    if (i == 0 && n == 1 && mesgImpl != null && this._refsThreshold > 0 && metaConnectReply != null && transport instanceof JSONTransport) {
                        ByteBuffer buffer = mesgImpl.getBuffer();
                        if (buffer != null) {
                            request.setAttribute("org.mortbay.jetty.ResponseBuffer", (Object)buffer);
                            if (metaConnectReply instanceof MessageImpl) {
                                ((MessageImpl)metaConnectReply).decRef();
                            }
                            metaConnectReply = null;
                            transport = null;
                            mesgImpl.decRef();
                            continue;
                        }
                        if (mesgImpl.getRefs() >= this._refsThreshold) {
                            byte[] contentBytes = ("[" + mesgImpl.getJSON() + ",{\"" + "successful" + "\":true,\"" + "channel" + "\":\"" + "/meta/connect" + "\"}]").getBytes("UTF-8");
                            int contentLength = contentBytes.length;
                            String headerString = "HTTP/1.1 200 OK\r\nContent-Type: text/json; charset=utf-8\r\nContent-Length: " + contentLength + "\r\n" + "\r\n";
                            byte[] headerBytes = headerString.getBytes("UTF-8");
                            buffer = ByteBuffer.allocateDirect(headerBytes.length + contentLength);
                            buffer.put(headerBytes);
                            buffer.put(contentBytes);
                            buffer.flip();
                            mesgImpl.setBuffer(buffer);
                            request.setAttribute("org.mortbay.jetty.ResponseBuffer", (Object)buffer);
                            metaConnectReply = null;
                            if (metaConnectReply instanceof MessageImpl) {
                                ((MessageImpl)metaConnectReply).decRef();
                            }
                            transport = null;
                            mesgImpl.decRef();
                            continue;
                        }
                    }
                    if (message != null) {
                        transport.send(message);
                    }
                    if (mesgImpl == null) continue;
                    mesgImpl.decRef();
                }
                if (metaConnectReply != null) {
                    metaConnectReply = this._bayeux.extendSendMeta((ClientImpl)client, metaConnectReply);
                    transport.send(metaConnectReply);
                    if (metaConnectReply instanceof MessageImpl) {
                        ((MessageImpl)metaConnectReply).decRef();
                    }
                }
            }
        }
        if (transport != null) {
            transport.complete();
        }
    }

    public void destroy() {
        AtmosphereContinuationBayeux bayeux = (AtmosphereContinuationBayeux)this._bayeux;
        if (bayeux != null) {
            for (Client c : bayeux.getClients()) {
                if (!(c instanceof AtmosphereBayeuxClient)) continue;
                AtmosphereBayeuxClient client = (AtmosphereBayeuxClient)c;
                AtmosphereResource continuation = client.getContinuation();
                client.setContinuation(null);
                if (continuation == null || !continuation.getAtmosphereResourceEvent().isSuspended()) continue;
                try {
                    ((HttpServletResponse)continuation.getResponse()).sendError(503);
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
            }
            bayeux.destroy();
        }
    }
}

