/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cdi;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDIObjectFactory
implements AtmosphereObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(CDIObjectFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T newClassInstance(AtmosphereFramework framework, Class<T> classToInstantiate) throws InstantiationException, IllegalAccessException {
        Object cc = null;
        try {
            Object dao;
            BeanManager bm = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
            Iterator i = bm.getBeans(classToInstantiate, new Annotation[0]).iterator();
            if (!i.hasNext()) {
                logger.trace("Unable to find {}. Creating the object directly.", (Object)classToInstantiate.getName());
                T t = classToInstantiate.newInstance();
                return t;
            }
            Bean bean = (Bean)i.next();
            CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
            Object object = dao = bm.getReference(bean, classToInstantiate, ctx);
            return (T)object;
        }
        catch (Exception e) {
            logger.trace("Unable to construct {}. Creating the object directly.", (Object)classToInstantiate.getName());
            T t = classToInstantiate.newInstance();
            return t;
        }
        finally {
            if (cc != null) {
                cc.release();
            }
        }
    }

    public String toString() {
        return "CDI ObjectFactory";
    }
}

