/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cdi;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.inject.AtmosphereConfigAware;
import org.atmosphere.inject.CDIProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDIObjectFactory
implements AtmosphereObjectFactory<Object> {
    private static final Logger logger = LoggerFactory.getLogger(CDIObjectFactory.class);
    private final ServiceLoader<CDIProducer> producerServiceLoader = ServiceLoader.load(CDIProducer.class);
    private final BeanManager bm;

    public CDIObjectFactory() {
        BeanManager beanManager = null;
        try {
            beanManager = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
        }
        catch (NamingException ex) {
            try {
                beanManager = (BeanManager)new InitialContext().lookup("java:comp/env/BeanManager");
            }
            catch (NamingException e) {
                logger.error("{}", (Throwable)e);
            }
        }
        this.bm = beanManager;
        for (CDIProducer p : this.producerServiceLoader) {
            Iterator i = this.bm.getBeans(p.getClass(), new Annotation[0]).iterator();
            if (i.hasNext()) continue;
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> classToInstantiate) throws InstantiationException, IllegalAccessException {
        Object cc = null;
        try {
            Object dao;
            Iterator i = this.bm.getBeans(classToInstantiate, new Annotation[0]).iterator();
            if (!i.hasNext()) {
                logger.trace("Unable to find {}. Creating the object directly.", (Object)classToInstantiate.getName());
                U u = classToInstantiate.newInstance();
                return u;
            }
            Bean bean = (Bean)i.next();
            CreationalContext ctx = this.bm.createCreationalContext((Contextual)bean);
            Object object = dao = this.bm.getReference(bean, classToInstantiate, ctx);
            return (U)object;
        }
        catch (Exception e) {
            logger.error("Unable to construct {}. Creating the object directly.", (Object)classToInstantiate.getName());
            U u = classToInstantiate.newInstance();
            return u;
        }
        finally {
            if (cc != null) {
                cc.release();
            }
        }
    }

    public AtmosphereObjectFactory allowInjectionOf(Object o) {
        return this;
    }

    public String toString() {
        return "CDI ObjectFactory";
    }

    public void configure(AtmosphereConfig config) {
        try {
            for (CDIProducer p : this.producerServiceLoader) {
                ((AtmosphereConfigAware)AtmosphereConfigAware.class.cast(p)).configure(config);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }
}

