/*
 * Decompiled with CFR 0.152.
 */
package org.webtide.demo.auction;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.Seti;
import org.cometd.oort.SetiServlet;
import org.cometd.server.AbstractService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuctionChatService
extends AbstractService {
    private final ConcurrentMap<String, Set<String>> _members = new ConcurrentHashMap();
    private Oort _oort;
    private Seti _seti;

    public AuctionChatService(ServletContext context) {
        super((BayeuxServer)context.getAttribute("org.cometd.bayeux"), "chat");
        this._oort = (Oort)context.getAttribute(Oort.OORT_ATTRIBUTE);
        if (this._oort == null) {
            throw new RuntimeException("Missing " + Oort.OORT_ATTRIBUTE + " from " + ServletContext.class.getSimpleName() + "; " + "is an Oort servlet declared in web.xml ?");
        }
        this._seti = (Seti)context.getAttribute(Seti.SETI_ATTRIBUTE);
        if (this._seti == null) {
            throw new RuntimeException("Missing " + Seti.SETI_ATTRIBUTE + " from " + ServletContext.class.getSimpleName() + "; " + "is " + SetiServlet.class.getSimpleName() + " declared in web.xml ?");
        }
        this.getBayeux().createIfAbsent("/auction/chat/**", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */});
        this.getBayeux().createIfAbsent("/service/auction/chat", new ConfigurableServerChannel.Initializer[]{new /* Unavailable Anonymous Inner Class!! */});
        this.addService("/auction/chat/**", "trackMembers");
        this.addService("/service/auction/chat", "privateChat");
    }

    public void trackMembers(ServerSession joiner, String channelName, Object data, String messageId) {
        if (data instanceof Object[]) {
            HashSet<String> newMembers;
            HashSet<String> members = (HashSet<String>)this._members.get(channelName);
            if (members == null && (members = (Set)this._members.putIfAbsent(channelName, newMembers = new HashSet<String>())) == null) {
                members = newMembers;
            }
            boolean added = false;
            for (Object user : (Object[])data) {
                added |= members.add(user.toString());
            }
            if (added) {
                this._logger.info("Members: {}", members);
                this.getBayeux().getChannel(channelName).publish((Session)this.getServerSession(), members, messageId);
            }
        } else if (data instanceof Map) {
            String userName;
            HashSet<String> newMembers;
            Set<String> members;
            Map map = (Map)data;
            if (Boolean.TRUE.equals(map.get("join"))) {
                members = (HashSet<String>)this._members.get(channelName);
                if (members == null && (members = (Set)this._members.putIfAbsent(channelName, newMembers = new HashSet<String>())) == null) {
                    members = newMembers;
                }
                userName = (String)map.get("user");
                members.add(userName);
                if (!this._oort.isOort(joiner)) {
                    this._seti.associate(userName, joiner);
                }
                joiner.addListener((ServerSession.ServerSessionListener)new /* Unavailable Anonymous Inner Class!! */);
                this._logger.info("Members: {}", members);
                this.getBayeux().getChannel(channelName).publish((Session)this.getServerSession(), members, messageId);
            }
            if (Boolean.TRUE.equals(map.get("leave"))) {
                members = (Set)this._members.get(channelName);
                if (members == null && (members = (Set)this._members.putIfAbsent(channelName, newMembers = new HashSet())) == null) {
                    members = newMembers;
                }
                userName = (String)map.get("user");
                members.remove(userName);
                this._logger.info("Members: {}", members);
                this.getBayeux().getChannel(channelName).publish((Session)this.getServerSession(), members, messageId);
            }
        }
    }

    public void privateChat(ServerSession source, String channel, Map<String, Object> data, String messageId) {
        String toUid = (String)data.get("peer");
        String toChannel = (String)data.get("room");
        source.deliver((Session)source, toChannel, data, messageId);
        this._seti.sendMessage(toUid, toChannel, data);
    }

    static /* synthetic */ Oort access$000(AuctionChatService x0) {
        return x0._oort;
    }

    static /* synthetic */ Seti access$100(AuctionChatService x0) {
        return x0._seti;
    }
}

