/*
 * Decompiled with CFR 0.152.
 */
package org.webtide.demo.auction.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.webtide.demo.auction.Category;
import org.webtide.demo.auction.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryDao {
    static final ConcurrentMap<Integer, Item> _items = new ConcurrentHashMap();
    static final ConcurrentMap<Integer, Category> _categories = new ConcurrentHashMap();

    public List<Item> getItemsInCategory(Integer categoryId) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item item : _items.values()) {
            if (!item.getCategory().getId().equals(categoryId)) continue;
            items.add(item);
        }
        return items;
    }

    public void addItem(Item item) {
        Category category = item.getCategory();
        _categories.putIfAbsent(category.getId(), category.clone());
        _items.putIfAbsent(item.getId(), item.clone());
    }

    public Category getCategory(int categoryId) {
        return (Category)_categories.get(categoryId);
    }

    public List<Category> getAllCategories() {
        ArrayList<Category> all = new ArrayList<Category>(_categories.values());
        Collections.sort(all);
        return all;
    }

    public List<Item> findItems(String expression) {
        ArrayList<Item> items = new ArrayList<Item>();
        String[] words = expression.toLowerCase().split("[ ,]");
        for (Item item : _items.values()) {
            for (String word : words) {
                if (!item.getDescription().toLowerCase().contains(word) && !item.getItemName().toLowerCase().contains(word)) continue;
                items.add(item);
            }
        }
        return items;
    }

    public Item getItem(int itemId) {
        return (Item)_items.get(itemId);
    }

    public Collection<Item> getAllItems() {
        return _items.values();
    }
}

