/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cometd;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import org.atmosphere.cometd.JettyAsyncSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.FrameworkConfig;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometdAtmosphereInterceptor
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(JettyAsyncSupport.class);

    public void configure(AtmosphereConfig config) {
        if (config.getServletContext().getServerInfo().contains("jetty")) {
            config.framework().setAsyncSupport((AsyncSupport)new JettyAsyncSupport(config));
        }
    }

    public Action inspect(AtmosphereResource r) {
        AtmosphereRequest request = r.getRequest();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET) && r.getRequest().getAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE) != null) {
            return Action.CANCELLED;
        }
        request.setAttribute("org.eclipse.jetty.continuation", (Object)new AtmosphereContinuation(r));
        return Action.CONTINUE;
    }

    public void postInspect(AtmosphereResource r) {
    }

    public String toString() {
        return "CometD/Bayeux Protocol";
    }

    public static final class AtmosphereContinuation
    implements Continuation {
        private long timeoutMs = -1L;
        private ServletResponse response;
        private final AtmosphereResource r;

        public AtmosphereContinuation(AtmosphereResource r) {
            this.r = r;
        }

        public void setTimeout(long timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public void suspend() {
            this.r.suspend(this.timeoutMs, false);
        }

        public void suspend(ServletResponse response) {
            this.response = response;
            this.r.suspend(this.timeoutMs, false);
        }

        public void resume() {
            try {
                this.r.getAtmosphereConfig().framework().doCometSupport(this.r.getRequest(), this.r.getResponse());
            }
            catch (IOException e) {
                logger.warn("", (Throwable)e);
            }
            catch (ServletException e) {
                logger.warn("", (Throwable)e);
            }
            this.r.resume();
        }

        public void complete() {
            this.r.resume();
        }

        public boolean isSuspended() {
            return this.r.isSuspended();
        }

        public boolean isResumed() {
            return this.r.isResumed();
        }

        public boolean isExpired() {
            return this.r.isResumed();
        }

        public boolean isInitial() {
            return this.r.isSuspended();
        }

        public boolean isResponseWrapped() {
            return true;
        }

        public ServletResponse getServletResponse() {
            return this.response;
        }

        public void addContinuationListener(final ContinuationListener listener) {
            this.r.addEventListener(new AtmosphereResourceEventListener(){

                public void onSuspend(AtmosphereResourceEvent event) {
                }

                public void onResume(AtmosphereResourceEvent event) {
                    if (event.isResuming()) {
                        listener.onComplete((Continuation)AtmosphereContinuation.this);
                    } else {
                        try {
                            AtmosphereContinuation.this.r.getAtmosphereConfig().framework().doCometSupport(AtmosphereContinuation.this.r.getRequest(), AtmosphereContinuation.this.r.getResponse());
                        }
                        catch (IOException e) {
                            logger.warn("", (Throwable)e);
                        }
                        catch (ServletException e) {
                            logger.warn("", (Throwable)e);
                        }
                        listener.onTimeout((Continuation)AtmosphereContinuation.this);
                    }
                }

                public void onDisconnect(AtmosphereResourceEvent event) {
                }

                public void onBroadcast(AtmosphereResourceEvent event) {
                }

                public void onThrowable(AtmosphereResourceEvent event) {
                }
            });
        }

        public void setAttribute(String name, Object attribute) {
            this.r.getRequest().setAttribute(name, attribute);
        }

        public Object getAttribute(String name) {
            return this.r.getRequest().getAttribute(name);
        }

        public void removeAttribute(String name) {
            this.r.getRequest().removeAttribute(name);
        }

        public void undispatch() throws ContinuationThrowable {
        }
    }
}

