/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cometd;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.LongPollingTransport;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends LongPollingTransport {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PREFIX = "long-polling.ws";
    public static final String NAME = "websocket";
    public static final String MIME_TYPE_OPTION = "mimeType";
    public static final String CALLBACK_PARAMETER_OPTION = "callbackParameter";
    private String _mimeType = "text/javascript;charset=UTF-8";
    private String _callbackParam = "jsonp";
    private boolean _autoBatch = true;
    private boolean _allowMultiSessionsNoBrowser = false;
    private long _multiSessionInterval = 2000L;

    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    protected boolean isAlwaysFlushingAfterHandle() {
        return true;
    }

    protected void init() {
        super.init();
        this._callbackParam = this.getOption(CALLBACK_PARAMETER_OPTION, this._callbackParam);
        this._mimeType = this.getOption(MIME_TYPE_OPTION, this._mimeType);
    }

    public boolean accept(HttpServletRequest request) {
        return request.getHeader("X-Atmosphere-Transport") == NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        scheduler = (LongPollScheduler)request.getAttribute("org.cometd.scheduler");
        if (scheduler == null) {
            batch = false;
            session = null;
            connect = false;
            try {
                messages = this.parseMessages(request);
                if (messages == null) {
                    return;
                }
                writer = null;
                for (ServerMessage.Mutable message : messages) {
                    connect = "/meta/connect".equals(message.getChannel());
                    client_id = message.getClientId();
                    if (session == null || client_id != null && !client_id.equals(session.getId())) {
                        session = (ServerSessionImpl)this.getBayeux().getSession(client_id);
                        if (this._autoBatch && !batch && session != null && !connect && !message.isMeta()) {
                            batch = true;
                            session.startBatch();
                        }
                    } else if (!session.isHandshook()) {
                        batch = false;
                        session = null;
                    }
                    if (connect && session != null) {
                        session.setScheduler(null);
                    }
                    wasConnected = session != null && session.isConnected() != false;
                    reply = this.bayeuxServerHandle(session, message);
                    if (reply != null) {
                        if (session == null) {
                            session = (ServerSessionImpl)this.getBayeux().getSession(reply.getClientId());
                            if (session != null) {
                                userAgent = request.getHeader("User-Agent");
                                session.setUserAgent(userAgent);
                                browserId = this.findBrowserId(request);
                                if (browserId == null) {
                                    this.setBrowserId(request, response);
                                }
                            }
                        } else if (connect) {
                            try {
                                writer = this.sendQueue(request, response, session, writer);
                                if (writer != null || !reply.isSuccessful() || !session.isQueueEmpty()) ** GOTO lbl79
                                browserId = this.findBrowserId(request);
                                allowSuspendConnect = browserId != null ? this.incBrowserId(browserId) : this._allowMultiSessionsNoBrowser;
                                if (allowSuspendConnect) {
                                    timeout = session.calculateTimeout(this.getTimeout());
                                    if (timeout > 0L && wasConnected && session.isConnected()) {
                                        continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                                        continuation.setTimeout(timeout);
                                        continuation.suspend((ServletResponse)response);
                                        scheduler = new LongPollScheduler(session, continuation, reply, browserId);
                                        session.setScheduler((AbstractServerTransport.Scheduler)scheduler);
                                        request.setAttribute("org.cometd.scheduler", (Object)scheduler);
                                        reply = null;
                                        this.metaConnectSuspended(request, (ServerSession)session, timeout);
                                    }
                                    this.decBrowserId(browserId);
                                }
                                advice = reply.getAdvice(true);
                                if (browserId != null) {
                                    advice.put("multiple-clients", true);
                                }
                                if (this._multiSessionInterval > 0L) {
                                    advice.put("reconnect", "retry");
                                    advice.put("interval", this._multiSessionInterval);
                                } else {
                                    advice.put("reconnect", "none");
                                    reply.setSuccessful(false);
                                }
                                session.reAdvise();
                            }
                            finally {
                                if (reply != null && session.isConnected()) {
                                    session.startIntervalTimeout(this.getInterval());
                                }
                            }
                        } else if (!this.isMetaConnectDeliveryOnly() && !session.isMetaConnectDeliveryOnly()) {
                            writer = this.sendQueue(request, response, session, writer);
                        }
lbl79:
                        // 8 sources

                        if (reply != null) {
                            if (connect && session != null && !session.isConnected()) {
                                reply.getAdvice(true).put("reconnect", "none");
                            }
                            if ((reply = this.getBayeux().extendReply(session, session, reply)) != null) {
                                this.getBayeux().freeze(reply);
                                writer = this.send(request, response, writer, (ServerMessage)reply);
                            }
                        }
                    }
                    message.setAssociated(null);
                }
                if (writer == null) ** GOTO lbl121
                this.complete(writer);
            }
            catch (ParseException x) {
                this.handleJSONParseException(request, response, x.getMessage(), x.getCause());
            }
            finally {
                if (batch) {
                    ended = session.endBatch();
                    if (!ended && this.isAlwaysFlushingAfterHandle()) {
                        session.flush();
                    }
                } else if (session != null && !connect && this.isAlwaysFlushingAfterHandle()) {
                    session.flush();
                }
            }
        } else {
            session = scheduler.getSession();
            this.metaConnectResumed(request, (ServerSession)session);
            try {
                writer = this.sendQueue(request, response, session, null);
            }
            finally {
                if (session.isConnected()) {
                    session.startIntervalTimeout(this.getInterval());
                }
            }
            reply = scheduler.getReply();
            if (!session.isConnected()) {
                reply.getAdvice(true).put("reconnect", "none");
            }
            if ((reply = this.getBayeux().extendReply(session, session, reply)) != null) {
                this.getBayeux().freeze(reply);
                writer = this.send(request, response, writer, (ServerMessage)reply);
            }
            this.complete(writer);
        }
lbl121:
        // 4 sources

    }

    private PrintWriter sendQueue(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, PrintWriter writer) throws IOException {
        List queue = session.takeQueue();
        for (ServerMessage m : queue) {
            writer = this.send(request, response, writer, m);
        }
        return writer;
    }

    protected ServerMessage.Mutable[] parseMessages(HttpServletRequest request) throws IOException, ParseException {
        return super.parseMessages(request.getReader(), true);
    }

    protected PrintWriter send(HttpServletRequest request, HttpServletResponse response, PrintWriter writer, ServerMessage message) throws IOException {
        StringBuilder builder = new StringBuilder(message.size() * 32);
        if (writer == null) {
            response.setContentType(this._mimeType);
            writer = response.getWriter();
        }
        builder.append("[").append(message.getJSON()).append("]");
        writer.append(builder.toString());
        return writer;
    }

    protected void complete(PrintWriter writer) throws IOException {
    }

    private class LongPollScheduler
    implements AbstractServerTransport.OneTimeScheduler,
    ContinuationListener {
        private static final String ATTRIBUTE = "org.cometd.scheduler";
        private final ServerSessionImpl _session;
        private final Continuation _continuation;
        private final ServerMessage.Mutable _reply;
        private String _browserId;

        public LongPollScheduler(ServerSessionImpl session, Continuation continuation, ServerMessage.Mutable reply, String browserId) {
            this._session = session;
            this._continuation = continuation;
            this._continuation.addContinuationListener((ContinuationListener)this);
            this._reply = reply;
            this._browserId = browserId;
        }

        public void cancel() {
            if (this._continuation != null && this._continuation.isSuspended() && !this._continuation.isExpired()) {
                try {
                    this.decBrowserId();
                    ((HttpServletResponse)this._continuation.getServletResponse()).sendError(408);
                }
                catch (IOException x) {
                    WebSocketTransport.this.logger.trace("", (Throwable)x);
                }
                try {
                    this._continuation.complete();
                }
                catch (Exception x) {
                    WebSocketTransport.this.logger.trace("", (Throwable)x);
                }
            }
        }

        public void schedule() {
            this.decBrowserId();
            this._continuation.resume();
        }

        public ServerSessionImpl getSession() {
            return this._session;
        }

        public ServerMessage.Mutable getReply() {
            Map advice = this._session.takeAdvice();
            if (advice != null) {
                this._reply.put((Object)"advice", (Object)advice);
            }
            return this._reply;
        }

        public void onComplete(Continuation continuation) {
            this.decBrowserId();
        }

        public void onTimeout(Continuation continuation) {
            this._session.setScheduler(null);
        }

        private void decBrowserId() {
            WebSocketTransport.this.decBrowserId(this._browserId);
            this._browserId = null;
        }
    }
}

