/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cometd;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.container.JettyWebSocketUtil;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAsyncSupport
extends Jetty7CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(JettyAsyncSupport.class);
    private final WebSocketFactory webSocketFactory;

    public JettyAsyncSupport(AtmosphereConfig config) {
        super(config);
        Object wsf;
        WebSocketProcessor webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        try {
            String[] jettyVersion = config.getServletContext().getServerInfo().substring(6).split("\\.");
            wsf = Integer.valueOf(jettyVersion[0]) > 7 || Integer.valueOf(jettyVersion[0]) == 7 && Integer.valueOf(jettyVersion[1]) > 4 ? JettyWebSocketUtil.getFactory((AtmosphereConfig)config, (WebSocketProcessor)webSocketProcessor) : null;
        }
        catch (Throwable e) {
            try {
                logger.trace("Unable to parse Jetty version {}", (Object)config.getServletContext().getServerInfo());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            wsf = JettyWebSocketUtil.getFactory((AtmosphereConfig)config, (WebSocketProcessor)webSocketProcessor);
        }
        this.webSocketFactory = wsf;
    }

    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = JettyWebSocketUtil.doService((AsynchronousProcessor)this, (AtmosphereRequest)req, (AtmosphereResponse)res, (WebSocketFactory)this.webSocketFactory);
        return action == null ? super.service(req, res) : action;
    }

    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    public boolean supportWebSocket() {
        return true;
    }

    protected Continuation getContinuation(AtmosphereRequest req) {
        Continuation falseContinuation = (Continuation)req.getAttribute("org.eclipse.jetty.continuation");
        req.setAttribute("org.eclipse.jetty.continuation", null);
        Continuation c = ContinuationSupport.getContinuation((ServletRequest)req);
        req.setAttribute("org.eclipse.jetty.continuation", (Object)falseContinuation);
        return c;
    }
}

