/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.core;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.atmosphere.core.Broadcastable;
import org.atmosphere.core.annotation.Broadcast;
import org.atmosphere.core.annotation.Resume;
import org.atmosphere.core.annotation.ResumeOnBroadcast;
import org.atmosphere.core.annotation.Suspend;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereFilter
implements ResourceFilterFactory {
    private Logger logger = LoggerUtils.getLogger();
    @Context
    private HttpServletRequest httpServletRequest;

    void resume(AtmosphereEvent e) {
        Iterator i = e.getBroadcaster().getAtmosphereEvents();
        while (i.hasNext()) {
            ((AtmosphereEvent)i.next()).resume();
        }
    }

    void broadcast(ContainerResponse r, AtmosphereEvent e) {
        Object o = r.getEntity();
        if (o instanceof Broadcastable) {
            r.setEntity((Object)((Broadcastable)o).broadcast());
        } else if (o != null) {
            e.getBroadcaster().broadcast(o);
        }
    }

    public List<ResourceFilter> create(AbstractMethod am) {
        int value;
        LinkedList<ResourceFilter> list = new LinkedList<ResourceFilter>();
        if (am.isAnnotationPresent(Broadcast.class)) {
            list.addLast(new Filter(Action.BROADCAST, 0, null));
        }
        if (am.isAnnotationPresent(Suspend.class)) {
            value = ((Suspend)am.getAnnotation(Suspend.class)).value();
            Suspend.SCOPE scope = ((Suspend)am.getAnnotation(Suspend.class)).scope();
            list.addFirst(new Filter(Action.SUSPEND, value, scope));
        }
        if (am.isAnnotationPresent(Resume.class)) {
            value = ((Resume)am.getAnnotation(Resume.class)).value();
            list.addFirst(new Filter(Action.RESUME, value, null));
        }
        if (am.isAnnotationPresent(ResumeOnBroadcast.class)) {
            list.addLast(new Filter(Action.RESUME_ON_BROADCAST, 0, null));
        }
        return list.size() > 0 ? list : null;
    }

    private final class Adapter
    implements ContainerResponseWriter {
        private final ContainerResponseWriter crw;

        Adapter(ContainerResponseWriter crw) {
            this.crw = crw;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
            return this.crw.writeStatusAndHeaders(contentLength, response);
        }

        public void finish() throws IOException {
        }
    }

    private class Filter
    implements ResourceFilter,
    ContainerResponseFilter {
        private Action action;
        private int value;
        private Suspend.SCOPE scope;

        protected Filter(Action action, int value, Suspend.SCOPE scope) {
            this.action = action;
            this.value = value;
            this.scope = scope;
        }

        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            AtmosphereEvent event = (AtmosphereEvent)AtmosphereFilter.this.httpServletRequest.getAttribute(ReflectorServletProcessor.ATMOSPHERE_EVENT);
            AtmosphereHandler handler = (AtmosphereHandler)AtmosphereFilter.this.httpServletRequest.getAttribute(ReflectorServletProcessor.ATMOSPHERE_HANDLER);
            if (this.action == Action.SUSPEND) {
                Object o = response.getEntity();
                response.setContainerResponseWriter((ContainerResponseWriter)new Adapter(response.getContainerResponseWriter()));
                if (o != null) {
                    try {
                        response.getOutputStream().write(o.toString().getBytes());
                        response.getOutputStream().flush();
                    }
                    catch (IOException ex) {
                        AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                    }
                }
                if (this.scope == Suspend.SCOPE.REQUEST) {
                    event.setBroadcaster((Broadcaster)new DefaultBroadcaster());
                }
                event.suspend((long)this.value);
            } else if (this.action == Action.RESUME) {
                AtmosphereFilter.this.resume(event);
            } else if (this.action == Action.BROADCAST) {
                AtmosphereFilter.this.broadcast(response, event);
            } else if (this.action == Action.RESUME_ON_BROADCAST) {
                AtmosphereFilter.this.broadcast(response, event);
                AtmosphereFilter.this.resume(event);
            }
            return response;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        SUSPEND,
        RESUME,
        BROADCAST,
        RESUME_ON_BROADCAST;

    }
}

