/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.core;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.atmosphere.core.Broadcastable;
import org.atmosphere.core.annotation.Broadcast;
import org.atmosphere.core.annotation.BroadcastFilter;
import org.atmosphere.core.annotation.Cluster;
import org.atmosphere.core.annotation.Resume;
import org.atmosphere.core.annotation.ResumeOnBroadcast;
import org.atmosphere.core.annotation.Suspend;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereFilter
implements ResourceFilterFactory {
    private Logger logger = LoggerUtils.getLogger();
    static final String CONTAINER_RESPONSE = "cr";
    @Context
    private HttpServletRequest httpServletRequest;

    public List<ResourceFilter> create(AbstractMethod am) {
        LinkedList<ResourceFilter> list = new LinkedList<ResourceFilter>();
        if (am.isAnnotationPresent(Broadcast.class)) {
            Class[] value;
            Filter f = new Filter(Action.BROADCAST);
            list.addLast(f);
            if (am.isAnnotationPresent(BroadcastFilter.class)) {
                value = ((BroadcastFilter)am.getAnnotation(BroadcastFilter.class)).value();
                f.setFilter(value);
            }
            if (am.isAnnotationPresent(Cluster.class)) {
                for (Class c : value = ((Cluster)am.getAnnotation(Cluster.class)).value()) {
                    try {
                        ClusterBroadcastFilter cbf = (ClusterBroadcastFilter)c.newInstance();
                        cbf.setClusterName(((Cluster)am.getAnnotation(Cluster.class)).name());
                        f.addCluster(cbf);
                    }
                    catch (Throwable t) {
                        this.logger.log(Level.WARNING, "Invalid ClusterBroadcastFilter", t);
                    }
                }
            }
        }
        if (am.isAnnotationPresent(Suspend.class)) {
            int value = ((Suspend)am.getAnnotation(Suspend.class)).value();
            Suspend.SCOPE scope = ((Suspend)am.getAnnotation(Suspend.class)).scope();
            list.addFirst(new Filter(Action.SUSPEND, value, scope));
        }
        if (am.isAnnotationPresent(Resume.class)) {
            int value = ((Resume)am.getAnnotation(Resume.class)).value();
            list.addFirst(new Filter(Action.RESUME, value));
        }
        if (am.isAnnotationPresent(ResumeOnBroadcast.class)) {
            list.addLast(new Filter(Action.RESUME_ON_BROADCAST));
        }
        return list.size() > 0 ? list : null;
    }

    private final class Adapter
    implements ContainerResponseWriter {
        private final ContainerResponseWriter crw;

        Adapter(ContainerResponseWriter crw) {
            this.crw = crw;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse response) throws IOException {
            return this.crw.writeStatusAndHeaders(contentLength, response);
        }

        public void finish() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Filter
    implements ResourceFilter,
    ContainerResponseFilter {
        private ConcurrentLinkedQueue<Broadcaster> configuredBroadcaster = new ConcurrentLinkedQueue();
        private Action action = Action.NONE;
        private int value = 0;
        private Suspend.SCOPE scope;
        private Class<org.atmosphere.cpr.BroadcastFilter>[] filters = null;
        private final ArrayList<ClusterBroadcastFilter> clusters = new ArrayList();

        protected Filter(Action action) {
            this.action = action;
        }

        protected Filter(Action action, int value) {
            this.action = action;
            this.value = value;
        }

        protected Filter(Action action, int value, Suspend.SCOPE scope) {
            this.action = action;
            this.value = value;
            this.scope = scope;
        }

        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            AtmosphereEvent event = (AtmosphereEvent)AtmosphereFilter.this.httpServletRequest.getAttribute(ReflectorServletProcessor.ATMOSPHERE_EVENT);
            if (this.action == Action.SUSPEND) {
                Object o = response.getEntity();
                response.setContainerResponseWriter((ContainerResponseWriter)new Adapter(response.getContainerResponseWriter()));
                if (o != null) {
                    try {
                        response.write();
                    }
                    catch (IOException ex) {
                        AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                    }
                }
                Broadcaster bc = event.getBroadcaster();
                if (this.scope == Suspend.SCOPE.REQUEST) {
                    try {
                        bc = (Broadcaster)bc.getClass().newInstance();
                        event.setBroadcaster(bc);
                    }
                    catch (InstantiationException ex) {
                        AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                    }
                }
                AtmosphereFilter.this.httpServletRequest.getSession().setAttribute("suspendedEvent", (Object)event);
                AtmosphereFilter.this.httpServletRequest.getSession().setAttribute(AtmosphereFilter.CONTAINER_RESPONSE, (Object)response);
                event.suspend((long)this.value);
            } else if (this.action == Action.RESUME) {
                this.resume(event);
            } else if (this.action == Action.BROADCAST) {
                AtmosphereEvent e = (AtmosphereEvent)AtmosphereFilter.this.httpServletRequest.getAttribute("suspendedEvent");
                if (e != null) {
                    event = e;
                }
                this.broadcast(response, event);
            } else if (this.action == Action.RESUME_ON_BROADCAST) {
                this.broadcast(response, event);
                this.resume(event);
            }
            return response;
        }

        void configureFilter(Broadcaster bc) {
            BroadcasterConfig c = bc.getBroadcasterConfig();
            for (ClusterBroadcastFilter cbf : this.clusters) {
                cbf.setBroadcaster(bc);
                c.addFilter((org.atmosphere.cpr.BroadcastFilter)cbf);
            }
            org.atmosphere.cpr.BroadcastFilter f = null;
            if (this.filters != null) {
                for (Class<org.atmosphere.cpr.BroadcastFilter> filter : this.filters) {
                    try {
                        f = filter.newInstance();
                    }
                    catch (Throwable t) {
                        AtmosphereFilter.this.logger.warning("Invalid @BroadcastFilter: " + filter);
                    }
                    c.addFilter(f);
                }
            }
        }

        private void setFilter(Class<org.atmosphere.cpr.BroadcastFilter>[] filters) {
            this.filters = filters;
        }

        void broadcast(ContainerResponse r, AtmosphereEvent e) {
            Object o = r.getEntity();
            if (o instanceof Broadcastable) {
                this.addFilter(((Broadcastable)o).b);
                r.setEntity(((Broadcastable)o).broadcast());
            } else if (o != null) {
                this.addFilter(e.getBroadcaster());
                try {
                    e.getBroadcaster().broadcast(o).get();
                }
                catch (InterruptedException ex) {
                    AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    AtmosphereFilter.this.logger.log(Level.SEVERE, null, ex);
                }
            }
        }

        void addFilter(Broadcaster bc) {
            if (!this.configuredBroadcaster.contains(bc)) {
                this.configureFilter(bc);
                this.configuredBroadcaster.offer(bc);
            }
        }

        void resume(AtmosphereEvent e) {
            Iterator i = e.getBroadcaster().getAtmosphereEvents();
            while (i.hasNext()) {
                ((AtmosphereEvent)i.next()).resume();
            }
        }

        void addCluster(ClusterBroadcastFilter f) {
            this.clusters.add(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        SUSPEND,
        RESUME,
        BROADCAST,
        RESUME_ON_BROADCAST,
        NONE;

    }
}

