/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.core;

import com.sun.jersey.spi.container.ContainerResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JerseyBroadcaster
implements Broadcaster<HttpServletRequest, HttpServletResponse, Object> {
    private final ConcurrentLinkedQueue<ContainerResponse> containerResponses = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<AtmosphereEvent<HttpServletRequest, HttpServletResponse>> events = new ConcurrentLinkedQueue();
    private BroadcasterConfig<Object> bc;
    private final BlockingQueue<Entry> messages = new LinkedBlockingQueue<Entry>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Broadcaster.SCOPE scope = Broadcaster.SCOPE.APPLICATION;
    private String name = DefaultBroadcaster.class.getSimpleName();

    public JerseyBroadcaster() {
        this.bc = new BroadcasterConfig();
    }

    public void destroy() {
        this.bc.destroy();
    }

    public Iterator<AtmosphereEvent<HttpServletRequest, HttpServletResponse>> getAtmosphereEvents() {
        return this.events.iterator();
    }

    public void setScope(Broadcaster.SCOPE scope) {
        this.scope = scope;
    }

    public Broadcaster.SCOPE getScope() {
        return this.scope;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    final void start() {
        if (!this.started.getAndSet(true)) {
            this.bc.getExecutorService().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Entry msg = null;
                    try {
                        msg = (Entry)JerseyBroadcaster.this.messages.take();
                        JerseyBroadcaster.this.bc.getExecutorService().submit(this);
                        if (msg.eventsToPush != null) return;
                        Iterator i$ = JerseyBroadcaster.this.containerResponses.iterator();
                        while (i$.hasNext()) {
                            ContainerResponse r;
                            ContainerResponse containerResponse = r = (ContainerResponse)i$.next();
                            synchronized (containerResponse) {
                                r.reset();
                                r.setEntity(msg.message);
                                JerseyBroadcaster.this.broadcast(r);
                            }
                        }
                        return;
                    }
                    catch (InterruptedException ex) {
                        LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
                        return;
                    }
                    finally {
                        if (msg != null) {
                            msg.f.done();
                        }
                    }
                }
            });
        }
    }

    private final void broadcast(ContainerResponse r) {
        try {
            r.write();
        }
        catch (IOException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
        }
        catch (IllegalStateException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
            this.containerResponses.remove(r);
        }
    }

    public BroadcasterFuture<Object> broadcast(Object msg) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture f = new BroadcasterFuture(msg);
        this.messages.offer(new Entry(msg, null, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, AtmosphereEvent event) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture f = new BroadcasterFuture(msg);
        this.messages.offer(new Entry(msg, event, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, Set<AtmosphereEvent> subset) {
        this.start();
        msg = this.bc.filter(msg);
        if (msg == null) {
            return null;
        }
        BroadcasterFuture f = new BroadcasterFuture(msg);
        this.messages.offer(new Entry(msg, subset, f));
        return f;
    }

    public AtmosphereEvent<HttpServletRequest, HttpServletResponse> addAtmosphereEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) {
        this.containerResponses.add((ContainerResponse)((HttpServletRequest)event.getRequest()).getSession().getAttribute("cr"));
        this.events.offer(event);
        return event;
    }

    public AtmosphereEvent<HttpServletRequest, HttpServletResponse> removeAtmosphereEvent(AtmosphereEvent<HttpServletRequest, HttpServletResponse> event) {
        this.containerResponses.remove((ContainerResponse)((HttpServletRequest)event.getRequest()).getSession().getAttribute("cr"));
        this.events.remove(event);
        return event;
    }

    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
    }

    public BroadcasterConfig getBroadcasterConfig() {
        return this.bc;
    }

    private final class Entry {
        Object message;
        Object eventsToPush;
        BroadcasterFuture f;

        Entry(Object message, Object eventsToPush, BroadcasterFuture f) {
            this.message = message;
            this.eventsToPush = eventsToPush;
            this.f = f;
        }
    }
}

